/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.common.logging.client.Logger;
import com.datastax.driver.core.PreparedStatement;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public abstract class PreparedStatements<E extends Enum<E>> {
    private final Logger log = AsmLogger.getLogger(PreparedStatements.class);
    private final Class<E> enumType;
    protected SessionDAO dao;
    protected Map<UserStoreKeyspace, EnumMap<E, PreparedStatement>> keyspaceMap = new HashMap<UserStoreKeyspace, EnumMap<E, PreparedStatement>>();

    public PreparedStatements(Class<E> enumType, SessionDAO dao) {
        this.enumType = enumType;
        this.dao = dao;
    }

    protected abstract PreparedStatement prepareStatement(E var1, UserStoreKeyspaceBuilder var2) throws DMException;

    protected PreparedStatement prepareQuery(String query, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        String fcn_name = "prepareQuery";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("prepareQuery: enter with query = " + query + ", KeyspaceBuilder.getKeyspace() = " + keyspaceBuilder.getKeyspace()));
        }
        String queryString = query.replace("__KEYSPACE__", keyspaceBuilder.getKeyspace().toString());
        return this.dao.prepareQuery(queryString, keyspaceBuilder);
    }

    protected PreparedStatement prepareQuery(String query) throws DMException {
        String fcn_name = "prepareQuery";
        if (this.log.isFinerEnabled()) {
            this.log.finer((Object)("prepareQuery: enter with query = " + query));
        }
        return this.dao.prepareQuery(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement getPreparedStatement(E queryType, UserStoreKeyspaceBuilder keyspaceBuilder) throws DMException {
        String fcn_name = "getPreparedStatement";
        boolean isFinestEnabled = this.log.isFinestEnabled();
        boolean isFinerEnabled = this.log.isFinerEnabled();
        if (isFinerEnabled) {
            this.log.finer((Object)("getPreparedStatement: enter with queryType = " + queryType + ", KeyspaceBuilder = " + keyspaceBuilder));
        }
        PreparedStatements preparedStatements = this;
        synchronized (preparedStatements) {
            if (keyspaceBuilder != null) {
                PreparedStatement ps;
                EnumMap<E, Object> psMap;
                UserStoreKeyspace keyspace = keyspaceBuilder.getKeyspace();
                if (isFinestEnabled) {
                    this.log.finest((Object)("getPreparedStatement: keyspace = " + keyspace));
                }
                if ((psMap = this.keyspaceMap.get(keyspace)) == null) {
                    psMap = new EnumMap(this.enumType);
                    this.keyspaceMap.put(keyspace, psMap);
                }
                if ((ps = psMap.get(queryType)) == null) {
                    if (isFinestEnabled) {
                        this.log.finest((Object)("getPreparedStatement: query not already prepared for queryType=" + queryType + ", preparing it..."));
                    }
                    ps = this.prepareStatement(queryType, keyspaceBuilder);
                    psMap.put(queryType, (Object)ps);
                } else if (isFinestEnabled) {
                    this.log.finest((Object)("getPreparedStatement: query already prepared for queryType=" + queryType));
                }
                return ps;
            }
            if (isFinestEnabled) {
                this.log.finest((Object)("getPreparedStatement: no KeyspaceBuilder so preparing queryType=" + queryType + ", preparing it..."));
            }
            return this.prepareStatement(queryType, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMap() {
        PreparedStatements preparedStatements = this;
        synchronized (preparedStatements) {
            this.keyspaceMap.clear();
        }
    }
}

