/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ppm;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.jdbc.JDBCBasedDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.objectapi.ContactRecord;
import com.avaya.asm.datamgr.objectapi.ContactRecords;
import com.avaya.asm.datamgr.objectapi.ppm.ContactAddress;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ContactOnDemandDAO {
    private static final Logger log = AsmLogger.getLogger(ContactOnDemandDAO.class);
    private static JDBCBasedDAO dataSource;
    protected static final String getContactRecordListQueryPart1 = "SELECT 'I' as \"contact_type\", u_contact.id, u_contact.displayname, u_contact.displaynameascii, u_contact.givenname,  u_contact.givennameascii, u_contact.surname, u_contact.surnameascii, '' AS \"contact_notes\",  u_contact.preferredlanguage, u_contact.preferredgivenname, 'FALSE' AS \"ispublic\", null as \"csuserid\",  u_contact.updatedatetime as contactupdatedatetime,  m.id AS member_id, m.altlabel, m.isfavourite, m.isspeeddial, m.label, m.cscontactaddressid, m.cshandleid,  m.cscontactlistid, m.ispresencebuddy, m.entryindex, m.csprivatecontactinfoid,  m.updatedatetime as clmupdatedatetime,  p.id AS p_id, p.displayname AS private_displayname, p.notes AS private_notes,  p.cspersonid as private_personid, p.ownerid, CASE WHEN p.csuserid IS NULL THEN 'FALSE' ELSE 'TRUE' END AS isCsUserId,  p.updatedatetime as pciupdatedatetime,  CASE WHEN p.id IS NULL THEN 'FALSE' ELSE 'TRUE' END as hasPCI  FROM cscontactlistmember m  JOIN csuser u_contact ON m.csuserid=u_contact.id LEFT JOIN csprivatecontactinfo p ON m.csprivatecontactinfoid = p.id ";
    protected static final String whereContactListId = " WHERE m.cscontactlistid=:defaultcontactlistid ";
    protected static final String whereContactListMemberId = " WHERE m.id=:clmid ";
    protected static final String getContactRecordListQueryPart2 = " SELECT CASE WHEN c.ispublic='t' THEN 'P' ELSE 'E' END AS \"contact_type\",  c.id, c.displayname, c.displaynameascii, c.givenname,  c.givennameascii, c.surname, c.surnameascii, c.notes AS \"contact_notes\",  c.preferredlanguage, c.preferredgivenname, c.ispublic, c.csuserid,  c.updatedatetime as contactupdatedatetime,  m.id AS \"member_id\", m.altlabel, m.isfavourite, m.isspeeddial, m.label, m.cscontactaddressid, m.cshandleid,  m.cscontactlistid, m.ispresencebuddy, m.entryindex, m.csprivatecontactinfoid,  m.updatedatetime as clmupdatedatetime,  p.id AS \"p_id\", p.displayname  AS \"private_displayname\", p.notes AS \"private_notes\",  p.cspersonid as private_personid, p.ownerid, CASE WHEN p.csuserid IS NULL THEN 'FALSE' ELSE 'TRUE' END AS isCsUserId,  p.updatedatetime as pciupdatedatetime,  CASE WHEN p.id IS NULL THEN 'FALSE' ELSE 'TRUE' END as hasPCI  FROM cscontactlistmember m  JOIN cscontact c ON m.cscontactid = c.id LEFT JOIN csprivatecontactinfo p ON m.csprivatecontactinfoid = p.id ";
    public static final String getContactAddressQuery = "SELECT DISTINCT id, address, altlabel, label,  updatedatetime, cscontactaddresscategoryid, cscontactaddresstypeid, cscontactid, csprivatecontactinfoid  from cscontactaddress where ";
    private static final String whereClauseForContactIdOrPCIId = " cscontactid=:contactId OR csprivatecontactinfoid=:pciId ";
    private static final String whereClauseForContactAddressId = " id=:addressId";
    private static final String isVideoCapableUserQuery = "select is_ipvideosoftphone from ipt_station  ipt_s, cmcommprofile cm_cp, cscommprofile cs_cp, csuser cu where  cu.defaultcommprofilesetid = cs_cp.cscommprofilesetid AND  cs_cp.commprofiletype = 'CM' AND cm_cp.id=cs_cp.id AND  cm_cp.station_id=ipt_s.id AND cu.id=:csUserId";
    private static final String getAsmInstancesQuery = "select asminstance_id, priorityorder from asmusercommunityassign  where asmusercommunity_id=(select usercommunity_id from asmcommprofile  where id = (select id from cscommprofile where cscommprofilesetid =  (select defaultcommprofilesetid from csuser where id=:cs_user_id)  AND commprofiletype='SIP'))";
    public static final String getOwnerIdFromCsContactListId = " select id from csuser  where  defaultcontactlistid=:defaultContactListId";
    public static final String getContactListNameFromCsContactListId = " select name from cscontactlist  where  id=:contactListId";
    public static final String getOwnerIdFromCsContactId = "select csuserid AS id from cscontact  where id=:csContactId";
    public static final String getCsUserIdFromClmId = "select id from csuser where defaultcontactlistid=(select cscontactlistid from cscontactlistmember where id=:clmId)";
    public static final String getCommunityIdsAssociatedWithAsmInstanceIdQuery = "SELECT DISTINCT ac.usercommunity_id as id FROM csuser u, cscommprofile c, asmcommprofile ac WHERE  u.defaultcommprofilesetid = c.cscommprofilesetid AND c.commprofiletype = 'SIP' AND ac.id = c.id AND ac.usercommunity_id  IN ( SELECT asmusercommunity_id FROM asmusercommunityassign a WHERE a.asminstance_id = :asmInstanceId )";
    public static final String getUserClIdAndCPIdsAndUIdForCommunityIdQuery = "SELECT u.defaultcontactlistid as clid, acp.id as acpid, u.id as uid FROM  csuser u, cscommprofile c, asmcommprofile acp  WHERE u.defaultcommprofilesetid = c.cscommprofilesetid AND c.commprofiletype = 'SIP'  AND acp.id = c.id AND acp.usercommunity_id = :communityId";
    public static final String getCsContactListMemberCountForCsUserId = "SELECT count(*) FROM cscontactlistmember m WHERE m.csuserid = :csuserId";

    public static void setDataSource(JDBCBasedDAO source) {
        dataSource = source;
    }

    protected static final ResultSetMapper getContactRecordsDataMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ArrayList<ContactRecord> contactRecordList = new ArrayList<ContactRecord>();
                while (rs.next()) {
                    ContactRecord cr = new ContactRecord(rs.getString("contact_type"), rs.getLong("id"), rs.getString("displayname"), rs.getString("displaynameascii"), rs.getString("givenname"), rs.getString("givennameascii"), rs.getString("surname"), rs.getString("surnameascii"), rs.getString("contact_notes"), rs.getString("preferredlanguage"), rs.getString("preferredgivenname"), rs.getBoolean("ispublic"), rs.getLong("csuserid"), rs.getLong("member_id"), rs.getString("altlabel"), rs.getBoolean("isfavourite"), rs.getBoolean("isspeeddial"), rs.getString("label"), (Long)rs.getObject("cscontactaddressid"), (Long)rs.getObject("cshandleid"), rs.getLong("cscontactlistid"), rs.getBoolean("ispresencebuddy"), rs.getInt("entryindex"), rs.getLong("csprivatecontactinfoid"), rs.getLong("p_id"), rs.getString("private_displayname"), rs.getString("private_notes"), rs.getLong("private_personid"), rs.getLong("ownerid"), rs.getBoolean("isCsUserId"), rs.getBoolean("hasPCI"), rs.getTimestamp("contactupdatedatetime"), rs.getTimestamp("pciupdatedatetime"), rs.getTimestamp("clmupdatedatetime"));
                    contactRecordList.add(cr);
                }
                return contactRecordList;
            }
        };
    }

    protected static final ResultSetMapper getContactAddressesDataMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ArrayList<ContactAddress> contactAddressList = new ArrayList<ContactAddress>();
                while (rs.next()) {
                    ContactAddress ca = new ContactAddress(rs.getLong("id"), rs.getLong("cscontactid"), rs.getLong("csprivatecontactinfoid"), rs.getString("address"), rs.getString("altlabel"), rs.getString("label"), rs.getInt("cscontactaddresscategoryid"), rs.getInt("cscontactaddresstypeid"), rs.getTimestamp("updatedatetime"));
                    contactAddressList.add(ca);
                }
                return contactAddressList;
            }
        };
    }

    protected static final ResultSetMapper getCsUserIdMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                Long csUserId = 0L;
                if (rs.next()) {
                    csUserId = rs.getLong("id");
                }
                return csUserId;
            }
        };
    }

    protected static final ResultSetMapper getCsContactListMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                String contactlistname = null;
                if (rs.next()) {
                    contactlistname = rs.getString("name");
                }
                return contactlistname;
            }
        };
    }

    protected static final ResultSetMapper getVideoEnabledDataMapper() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                Boolean isVideoEnabled = false;
                while (rs.next()) {
                    isVideoEnabled = rs.getBoolean("is_ipvideosoftphone");
                }
                return isVideoEnabled;
            }
        };
    }

    protected static final ResultSetMapper getAsmInstanceIdsForUser() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                HashMap<Long, Integer> asmInstanceIdAndPOmap = new HashMap<Long, Integer>();
                while (rs.next()) {
                    asmInstanceIdAndPOmap.put(rs.getLong("asminstance_id"), rs.getInt("priorityorder"));
                }
                return asmInstanceIdAndPOmap;
            }
        };
    }

    @SMConsole(description="Get all Internal, Public and External for a particular handle")
    public static ContactRecords loadContacts(long defaultContactListId) {
        String fcn_name = "loadContacts";
        Boolean isFinest = log.isFinestEnabled();
        ContactRecords contactRecords = new ContactRecords();
        Object[] params = new Object[]{};
        String subQuery = whereContactListId.replaceAll(":defaultcontactlistid", Long.toString(defaultContactListId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("loadContacts: QUERY #1 = SELECT 'I' as \"contact_type\", u_contact.id, u_contact.displayname, u_contact.displaynameascii, u_contact.givenname,  u_contact.givennameascii, u_contact.surname, u_contact.surnameascii, '' AS \"contact_notes\",  u_contact.preferredlanguage, u_contact.preferredgivenname, 'FALSE' AS \"ispublic\", null as \"csuserid\",  u_contact.updatedatetime as contactupdatedatetime,  m.id AS member_id, m.altlabel, m.isfavourite, m.isspeeddial, m.label, m.cscontactaddressid, m.cshandleid,  m.cscontactlistid, m.ispresencebuddy, m.entryindex, m.csprivatecontactinfoid,  m.updatedatetime as clmupdatedatetime,  p.id AS p_id, p.displayname AS private_displayname, p.notes AS private_notes,  p.cspersonid as private_personid, p.ownerid, CASE WHEN p.csuserid IS NULL THEN 'FALSE' ELSE 'TRUE' END AS isCsUserId,  p.updatedatetime as pciupdatedatetime,  CASE WHEN p.id IS NULL THEN 'FALSE' ELSE 'TRUE' END as hasPCI  FROM cscontactlistmember m  JOIN csuser u_contact ON m.csuserid=u_contact.id LEFT JOIN csprivatecontactinfo p ON m.csprivatecontactinfoid = p.id " + subQuery + " QUERY #2 = " + getContactRecordListQueryPart2 + subQuery));
        }
        try {
            ArrayList<ContactRecord> totalContactRecordList = new ArrayList<ContactRecord>();
            Long currentTime = System.currentTimeMillis();
            List contactRecordList = (List)dataSource.executeQuery(getContactRecordListQueryPart1 + subQuery, params, ContactOnDemandDAO.getContactRecordsDataMapper());
            totalContactRecordList.addAll(contactRecordList);
            currentTime = System.currentTimeMillis();
            contactRecordList = (List)dataSource.executeQuery(getContactRecordListQueryPart2 + subQuery, params, ContactOnDemandDAO.getContactRecordsDataMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("loadContacts: Time required for loadContacts query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
            totalContactRecordList.addAll(contactRecordList);
            contactRecords.setContactRecordList(totalContactRecordList);
        }
        catch (DMException dme) {
            log.error((Object)("loadContacts: contactlistid = " + defaultContactListId + " Caught DMException "), (Throwable)dme);
            contactRecords = null;
        }
        if (isFinest.booleanValue() && contactRecords.getContactRecordList() != null) {
            log.finest((Object)("loadContacts: contactRecords list size = " + contactRecords.getContactRecordList().size() + " CONTACT RECORDS = { " + contactRecords + " }"));
        }
        return contactRecords;
    }

    @SMConsole(description="Get a contact (could be one of Internal, Public and External) for a particular ContactListMember.id")
    public static ContactRecord loadContactFromCLMID(long contactListMemberId) {
        String fcn_name = "loadContactFromCLMID";
        Boolean isFinest = log.isFinestEnabled();
        ContactRecord contactRecord = null;
        Object[] params = new Object[]{};
        List recordList = null;
        String subQuery = whereContactListMemberId.replaceAll(":clmid", Long.toString(contactListMemberId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("loadContactFromCLMID: QUERY #1 = SELECT 'I' as \"contact_type\", u_contact.id, u_contact.displayname, u_contact.displaynameascii, u_contact.givenname,  u_contact.givennameascii, u_contact.surname, u_contact.surnameascii, '' AS \"contact_notes\",  u_contact.preferredlanguage, u_contact.preferredgivenname, 'FALSE' AS \"ispublic\", null as \"csuserid\",  u_contact.updatedatetime as contactupdatedatetime,  m.id AS member_id, m.altlabel, m.isfavourite, m.isspeeddial, m.label, m.cscontactaddressid, m.cshandleid,  m.cscontactlistid, m.ispresencebuddy, m.entryindex, m.csprivatecontactinfoid,  m.updatedatetime as clmupdatedatetime,  p.id AS p_id, p.displayname AS private_displayname, p.notes AS private_notes,  p.cspersonid as private_personid, p.ownerid, CASE WHEN p.csuserid IS NULL THEN 'FALSE' ELSE 'TRUE' END AS isCsUserId,  p.updatedatetime as pciupdatedatetime,  CASE WHEN p.id IS NULL THEN 'FALSE' ELSE 'TRUE' END as hasPCI  FROM cscontactlistmember m  JOIN csuser u_contact ON m.csuserid=u_contact.id LEFT JOIN csprivatecontactinfo p ON m.csprivatecontactinfoid = p.id " + subQuery + " QUERY #2 = " + getContactRecordListQueryPart2 + subQuery));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            recordList = (List)dataSource.executeQuery(getContactRecordListQueryPart1 + subQuery, params, ContactOnDemandDAO.getContactRecordsDataMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("loadContactFromCLMID: QUERY #1: Output - " + recordList));
            }
            if (recordList == null || recordList.size() == 0) {
                recordList = (List)dataSource.executeQuery(getContactRecordListQueryPart2 + subQuery, params, ContactOnDemandDAO.getContactRecordsDataMapper());
            }
            if (recordList != null && recordList.size() > 0) {
                contactRecord = (ContactRecord)recordList.get(0);
                if (isFinest.booleanValue()) {
                    log.finest((Object)("loadContactFromCLMID: contactRecord = " + contactRecord));
                }
                if (recordList.size() > 1 && isFinest.booleanValue()) {
                    log.finest((Object)("loadContactFromCLMID: More than one record found - " + recordList));
                }
            } else if (isFinest.booleanValue()) {
                log.finest((Object)("loadContactFromCLMID: contactRecord not found for contactListMemberId = " + contactListMemberId));
            }
            if (isFinest.booleanValue()) {
                log.finest((Object)("loadContactFromCLMID: Time required for loadContacts query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("loadContactFromCLMID: contactListMemberId = " + contactListMemberId + " Caught DMException "), (Throwable)dme);
            contactRecord = null;
        }
        if (isFinest.booleanValue() && contactRecord != null) {
            log.finest((Object)("loadContactFromCLMID: contactRecord = " + contactRecord.toString()));
        }
        return contactRecord;
    }

    @SMConsole(description="Get ContactAddress list for a particular cscontactid OR CsPrivateContatInfoId")
    public static List<ContactAddress> loadContactAddressList(Long csContactId, Long csPrivContInfoId) {
        String fcn_name = "loadContactAddressList";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        ArrayList contactAddressList = null;
        String id = null;
        id = csContactId != null ? Long.toString(csContactId) : "0";
        String subQuery = whereClauseForContactIdOrPCIId.replaceAll(":contactId", id);
        id = csPrivContInfoId != null ? Long.toString(csPrivContInfoId) : "0";
        subQuery = subQuery.replaceAll(":pciId", id);
        if (isFinest.booleanValue()) {
            log.finest((Object)("loadContactAddressList: QUERY = SELECT DISTINCT id, address, altlabel, label,  updatedatetime, cscontactaddresscategoryid, cscontactaddresstypeid, cscontactid, csprivatecontactinfoid  from cscontactaddress where " + subQuery));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            contactAddressList = (ArrayList)dataSource.executeQuery(getContactAddressQuery + subQuery, params, ContactOnDemandDAO.getContactAddressesDataMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("loadContactAddressList: Time required for loadContactAddressList query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("loadContactAddressList: csContactId = " + csContactId + " pciId = " + csPrivContInfoId + " Caught DMException "), (Throwable)dme);
            contactAddressList = null;
        }
        return contactAddressList;
    }

    @SMConsole(description="Get ContactAddress for a particular cscontactaddressid")
    public static ContactAddress loadContactAddress(long contactAddressId) {
        String fcn_name = "loadContactAddress";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        ContactAddress contactAddress = null;
        ArrayList contactAddressList = null;
        String subQuery = whereClauseForContactAddressId.replaceAll(":addressId", Long.toString(contactAddressId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("loadContactAddress: QUERY = SELECT DISTINCT id, address, altlabel, label,  updatedatetime, cscontactaddresscategoryid, cscontactaddresstypeid, cscontactid, csprivatecontactinfoid  from cscontactaddress where " + subQuery));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            contactAddressList = (ArrayList)dataSource.executeQuery(getContactAddressQuery + subQuery, params, ContactOnDemandDAO.getContactAddressesDataMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("loadContactAddress: Time required for loadContactAddress query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("loadContactAddress: contactAddressId = " + contactAddressId + " Caught DMException "), (Throwable)dme);
            contactAddress = null;
        }
        if (contactAddressList != null && contactAddressList.size() > 0) {
            contactAddress = (ContactAddress)contactAddressList.get(0);
        }
        return contactAddress;
    }

    @SMConsole(description="Get if the user is video enabled.")
    public static Boolean isUserVideoEnabled(long csUserId) {
        String fcn_name = "isUserVideoEnabled";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        Boolean isVideoEnabled = false;
        String query = isVideoCapableUserQuery.replaceAll(":csUserId", Long.toString(csUserId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("isUserVideoEnabled: QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            isVideoEnabled = (Boolean)dataSource.executeQuery(query, params, ContactOnDemandDAO.getVideoEnabledDataMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("isUserVideoEnabled: Time required for isVideoCapableUserQuery query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("isUserVideoEnabled: csuserid = " + csUserId + " Caught DMException "), (Throwable)dme);
        }
        return isVideoEnabled;
    }

    @SMConsole(description="Get contact's ownerCsUserId from contactListId.")
    public static Long getCsUserIdFromCsContactListId(Long contactListId) {
        String fcn_name = "getCsUserIdFromCsContactListId";
        Long csUserId = null;
        String query = getOwnerIdFromCsContactListId.replaceAll(":defaultContactListId", Long.toString(contactListId));
        try {
            csUserId = ContactOnDemandDAO.executeQueryForCsUserId(query);
        }
        catch (DMException dme) {
            log.error((Object)(fcn_name + ": contactListId = " + contactListId + " Caught DMException "), (Throwable)dme);
        }
        return csUserId;
    }

    private static Long executeQueryForCsUserId(String query) throws DMException {
        String fcn_name = "executeQueryForCsUserId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        Long csUserId = null;
        if (isFinest.booleanValue()) {
            log.finest((Object)("executeQueryForCsUserId: QUERY = " + query));
        }
        Long currentTime = System.currentTimeMillis();
        csUserId = (Long)dataSource.executeQuery(query, params, ContactOnDemandDAO.getCsUserIdMapper());
        if (isFinest.booleanValue()) {
            log.finest((Object)("executeQueryForCsUserId: Time required for getOwnerIdFromCsContactListId query = " + (System.currentTimeMillis() - currentTime) + " ms."));
        }
        return csUserId;
    }

    @SMConsole(description="Get csUserId from clmId.")
    public static Long getCsUserIdFromClmId(Long clmId) {
        String fcn_name = "getCsUserIdFromClmId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        Long csUserId = null;
        String query = getCsUserIdFromClmId.replaceAll(":clmId", Long.toString(clmId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("getCsUserIdFromClmId: QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            csUserId = (Long)dataSource.executeQuery(query, params, ContactOnDemandDAO.getCsUserIdMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("getCsUserIdFromClmId: Time required for getCsUserIdFromClmId query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("getCsUserIdFromClmId: csPciId = " + clmId + " Caught DMException "), (Throwable)dme);
        }
        return csUserId;
    }

    public static String getCsContactListNameFromCsContactListId(Long contactListId) {
        String fcn_name = "getCsContactListNameFromCsContactListId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        String contactlistName = null;
        String query = getContactListNameFromCsContactListId.replaceAll(":contactListId", Long.toString(contactListId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("getCsContactListNameFromCsContactListId: QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            contactlistName = (String)dataSource.executeQuery(query, params, ContactOnDemandDAO.getCsContactListMapper());
            if (isFinest.booleanValue()) {
                log.finest((Object)("getCsContactListNameFromCsContactListId: Time required for getCsContactListNameFromCsContactListId query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("getCsContactListNameFromCsContactListId: csContactlistId = " + contactListId + " Caught DMException "), (Throwable)dme);
        }
        return contactlistName;
    }

    @SMConsole(description="Get asminstance ids for ownerCsUserId.")
    public static Map<Long, Integer> getListOfAsmInstanceIdsForCsUserId(Long csUserId) {
        String fcn_name = "getListOfAsmInstanceIdsForCsUserId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        HashMap asmInstanceIdsAndPOmap = null;
        String query = getAsmInstancesQuery.replaceAll(":cs_user_id", Long.toString(csUserId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("getListOfAsmInstanceIdsForCsUserId: QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            asmInstanceIdsAndPOmap = (HashMap)dataSource.executeQuery(query, params, ContactOnDemandDAO.getAsmInstanceIdsForUser());
            if (isFinest.booleanValue()) {
                log.finest((Object)("getListOfAsmInstanceIdsForCsUserId: Time required for getListOfAsmInstanceIdsForCsUserId query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("getListOfAsmInstanceIdsForCsUserId: csUserId = " + csUserId + " Caught DMException "), (Throwable)dme);
        }
        return asmInstanceIdsAndPOmap;
    }

    protected static final ResultSetMapper getUserDataFromResultSet() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ArrayList<UserInitialLoadData> userILDataList = new ArrayList<UserInitialLoadData>();
                while (rs.next()) {
                    ContactOnDemandDAO contactOnDemandDAO = new ContactOnDemandDAO();
                    contactOnDemandDAO.getClass();
                    UserInitialLoadData udata = contactOnDemandDAO.new UserInitialLoadData(rs.getLong("uid"), rs.getLong("clid"), rs.getLong("acpid"));
                    userILDataList.add(udata);
                }
                return userILDataList;
            }
        };
    }

    protected static final ResultSetMapper getIdsFromResultSet() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                ArrayList<Long> idsList = new ArrayList<Long>();
                while (rs.next()) {
                    idsList.add(rs.getLong("id"));
                }
                return idsList;
            }
        };
    }

    @SMConsole(description="Get List comprising of community ids for asmInstanceId.")
    public static List<Long> getListOfCommunityIdsAssociatedWithAsmInstanceId(Long asmInstanceId) {
        String fcn_name = "getListOfCommunityIdsAssociatedWithAsmInstanceId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        ArrayList communityIds = null;
        String query = getCommunityIdsAssociatedWithAsmInstanceIdQuery.replaceAll(":asmInstanceId", Long.toString(asmInstanceId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("getListOfCommunityIdsAssociatedWithAsmInstanceId: getCommunityIdsAssociatedWithAsmInstanceIdQuery QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            communityIds = (ArrayList)dataSource.executeQuery(query, params, ContactOnDemandDAO.getIdsFromResultSet());
            if (isFinest.booleanValue()) {
                log.finest((Object)("getListOfCommunityIdsAssociatedWithAsmInstanceId: Time required for getCommunityIdsAssociatedWithAsmInstanceIdQuery query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("getListOfCommunityIdsAssociatedWithAsmInstanceId: asmInstanceId = " + asmInstanceId + " Caught DMException "), (Throwable)dme);
            communityIds = new ArrayList();
        }
        return communityIds;
    }

    @SMConsole(description="Get List comprising of contact list ids, asmcommprofileids and csuserid for communityId.")
    public static List<UserInitialLoadData> getUserILDataListForCommunityId(Long communityId) {
        String fcn_name = "getUserInitialLoadDataListForCommunityId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        List userDataList = null;
        String query = getUserClIdAndCPIdsAndUIdForCommunityIdQuery.replaceAll(":communityId", Long.toString(communityId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("getUserInitialLoadDataListForCommunityId: getUserClIdAndCPIdsAndUIdForCommunityIdQuery QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            userDataList = (List)dataSource.executeQuery(query, params, ContactOnDemandDAO.getUserDataFromResultSet());
            if (isFinest.booleanValue()) {
                log.finest((Object)("getUserInitialLoadDataListForCommunityId: Time required for getUserClIdAndCPIdsAndUIdForCommunityIdQuery query = " + (System.currentTimeMillis() - currentTime) + " ms."));
            }
        }
        catch (DMException dme) {
            log.error((Object)("getUserInitialLoadDataListForCommunityId: communityId = " + communityId + " Caught DMException "), (Throwable)dme);
        }
        return userDataList;
    }

    @SMConsole(description="Get contact count for csUserId.")
    public static Integer getContactCount(Long csuserId) {
        String fcn_name = "getContactCountForcsUserId";
        Boolean isFinest = log.isFinestEnabled();
        Object[] params = new Object[]{};
        Integer contactCount = 0;
        String query = getCsContactListMemberCountForCsUserId.replaceAll(":csuserId", Long.toString(csuserId));
        if (isFinest.booleanValue()) {
            log.finest((Object)("getContactCountForcsUserId: QUERY = " + query));
        }
        try {
            Long currentTime = System.currentTimeMillis();
            contactCount = (int)((Integer)dataSource.executeQuery(query, params, ContactOnDemandDAO.getcountFromResultSet()));
            if (isFinest.booleanValue()) {
                log.finest((Object)("getContactCountForcsUserId: Time required for getContactCountForcsUserIdQuery = " + (System.currentTimeMillis() - currentTime) + " ms. ANd count is :" + contactCount));
            }
        }
        catch (DMException dme) {
            log.error((Object)("getContactCountForcsUserId: csuserId = " + csuserId + " Caught DMException "), (Throwable)dme);
        }
        return contactCount;
    }

    protected static final ResultSetMapper getcountFromResultSet() {
        return new ResultSetMapper(){

            @Override
            public Object mapResults(ResultSet rs) throws SQLException {
                int count = 0;
                while (rs.next()) {
                    count = rs.getInt("count");
                }
                return count;
            }
        };
    }

    public class UserInitialLoadData {
        private Long userId = null;
        private Long contactListId = null;
        private Long asmCommProfileId = null;

        public UserInitialLoadData(Long userId, Long contactListId, Long asmCommProfileId) {
            this.userId = userId;
            this.contactListId = contactListId;
            this.asmCommProfileId = asmCommProfileId;
        }

        public Long getUserId() {
            return this.userId;
        }

        public Long getContactListId() {
            return this.contactListId;
        }

        public Long getAsmCommProfileId() {
            return this.asmCommProfileId;
        }

        public String toString() {
            return "UserInitialLoadData [userId=" + this.userId + ", contactListId=" + this.contactListId + ", asmCommProfileId=" + this.asmCommProfileId + "]";
        }
    }
}

