/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DDLConstants;
import com.avaya.asm.datamgr.datadistributionlayer.DDLException;
import com.avaya.asm.datamgr.datadistributionlayer.DDLInterClusterHelper;
import com.avaya.asm.datamgr.datadistributionlayer.DDLUtilities;
import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMessage;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.util.List;

public interface GroupCommIntf {
    public static final Logger log = AsmLogger.getLogger(GroupCommIntf.class);

    public void addChannelListener();

    public void destroy();

    public List<Object> getCurrentMembers();

    public Object getThisHostId();

    public void multicastMessage(DataDistLayerMessage var1, boolean var2);

    public Object queryTheHost(Object var1, DataDistLayerMessage var2);

    public Object queryTheHost(Object var1, DataDistLayerMessage var2, int var3);

    public void sendMessage(Object var1, DataDistLayerMessage var2);

    public void sendAsyncMessage(Object var1, DataDistLayerMessage var2);

    public void connectGroup();

    public boolean isConnected();

    public boolean reconnectChannel() throws DDLException;

    public void setView(Object var1);

    public Object getCurrentView();

    public String getGroupName();

    public DDLGroupType getGroupType();

    public String getClusterVersion();

    public void updateForHost(String var1, String var2);

    public StringBuilder dumpStats(boolean var1);

    public void updateLogicalNames();

    public static enum JGroupsVersion {
        JGROUPS_3_0("jgroups-3.0.10.Final.jar", "jgroupsWrappers3.jar", "udp.3.0.xml", "tcp.3.0.xml", "jgroupsKeystore.gen.jceks", "interddl", new DDLInterClusterHelper(), "com.avaya.asm.datamgr.datadistributionlayer.JGroupWrapper30"),
        JGROUPS_3_6("jgroups-3.6.4.Final.jar", "jgroupsWrappers3.jar", "udp.3.6.xml", "tcp.3.6.xml", "jgroupsKeystore.gen.jceks", "interddl", new DDLInterClusterHelper(), "com.avaya.asm.datamgr.datadistributionlayer.JGroupWrapper30");

        private String jgroupsJarName;
        private String wrapperJarName;
        private String udpStack;
        private String tcpStack;
        private String keyStore;
        private String storeAlias;
        private DDLInterClusterHelper interHelper;
        private String jarPath = "/opt/Avaya/CommonServerPlatform/lib/jgroups";
        private String wrapperClass;
        private String intraClusterName = null;
        private String interClusterName = null;
        public String s1 = "ya1";

        private JGroupsVersion(String jgroupsJarName, String wrapperJarName, String udpStack, String tcpStack, String keyStore, String storeAlias, DDLInterClusterHelper interHelper, String wrapperClass) {
            this.jgroupsJarName = jgroupsJarName;
            this.wrapperJarName = wrapperJarName;
            this.udpStack = udpStack;
            this.tcpStack = tcpStack;
            this.keyStore = keyStore;
            this.storeAlias = storeAlias;
            this.interHelper = interHelper;
            this.wrapperClass = wrapperClass;
        }

        public void setJarPath(String path) {
            this.jarPath = path;
        }

        public static JGroupsVersion getVersion(String minSmVersion) {
            int minSmVersionIntvalue;
            if (minSmVersion != null && (minSmVersionIntvalue = Integer.parseInt(minSmVersion)) >= DDLConstants.SM_VERSION_JGROUPS_36 && JGROUPS_3_6.getJgroupsJar().exists()) {
                return JGROUPS_3_6;
            }
            return JGROUPS_3_0;
        }

        public File getJgroupsJar() {
            return new File(this.jarPath + "/" + this.jgroupsJarName);
        }

        public File getWrapperJar() {
            return new File(this.jarPath + "/" + this.wrapperJarName);
        }

        public String getUdpStack() {
            return this.udpStack;
        }

        public String getTcpStack() {
            return this.tcpStack;
        }

        public String getKeyStoreName() {
            return this.keyStore;
        }

        public DDLInterClusterHelper getInterClusterHelper() {
            return this.interHelper;
        }

        public String getStorePassword() {
            String ret = "";
            if (this.interHelper != null) {
                ret = this.interHelper.getKeyPassword();
            }
            return ret;
        }

        public String getKeyPassword() {
            return this.getStorePassword();
        }

        public String getStoreAlias() {
            return this.storeAlias;
        }

        public String getWrapperClass() {
            return this.wrapperClass;
        }

        public String getIntraClusterName() {
            if (this.intraClusterName == null) {
                this.intraClusterName = System.getProperty("jboss.bind.address");
                if (this.intraClusterName == null) {
                    this.intraClusterName = DDLUtilities.getManagementIP();
                }
            }
            return this.intraClusterName;
        }

        public String getInterClusterName() {
            if (this.interClusterName == null) {
                this.interClusterName = DMUtilities.readPropFile("/opt/Avaya/install.properties", "InterClusterName");
                if (this.interClusterName == null) {
                    this.interClusterName = DMUtilities.getSMGRIpAddr();
                }
            }
            String curInterClusterName = this.interClusterName;
            if (this == JGROUPS_3_0) {
                String md5Hash = this.interHelper.getMD5HashJGroupsKeyStore();
                if (md5Hash != null) {
                    md5Hash = "_" + md5Hash;
                    curInterClusterName = curInterClusterName + "_InterCluster-3.0" + (md5Hash == null ? "" : md5Hash);
                } else {
                    log.error((Object)"MD5 Hash for the JGroupsKeyStore is null.\nRun select jgrpkeyfile from AsmGlobalParm; \nMake sure jgrpkeyfile is populated.");
                }
            } else if (this == JGROUPS_3_6) {
                String md5Hash = this.interHelper.getMD5HashJGroupsKeyStore();
                if (md5Hash != null) {
                    md5Hash = "_" + md5Hash;
                    curInterClusterName = curInterClusterName + "_InterCluster-3.6" + (md5Hash == null ? "" : md5Hash);
                } else {
                    log.error((Object)"MD5 Hash for the JGroupsKeyStore is null.\nRun select jgrpkeyfile from AsmGlobalParm; \nMake sure jgrpkeyfile is populated.");
                }
            } else {
                curInterClusterName = curInterClusterName + "_InterCluster6.0c";
            }
            return curInterClusterName;
        }
    }

    public static enum DDLGroupType {
        INTRA_SM_CLUSTER,
        INTER_SM_CLUSTER;

    }
}

