/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.DigitTree;
import com.avaya.asm.datamgr.objectapi.DigitTreeNode;
import com.avaya.asm.datamgr.objectapi.DigitTreeNodeMatcher;
import com.avaya.asm.datamgr.objectapi.DigitTreeObjectNode;
import com.avaya.asm.datamgr.objectapi.DigitTreeObjectNodeMatch;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.util.TreeSet;

public class DigitTreeDigitNode<E>
implements DigitTreeNode<E>,
Serializable {
    private static final Logger log = AsmLogger.getLogger(DigitTreeDigitNode.class);
    private static final long serialVersionUID = -6606656555516656041L;
    private final DigitTreeNode<E>[] dgtRoute;

    public DigitTreeDigitNode(DigitTree<E> tree) {
        this.dgtRoute = new DigitTreeNode[tree.getMaxDigits()];
    }

    public synchronized boolean isEmpty() {
        for (DigitTreeNode<E> node : this.dgtRoute) {
            if (node == null) continue;
            return false;
        }
        return true;
    }

    @Override
    public DigitTreeObjectNodeMatch<E> findBestMatch(DigitTree<E> tree, int depth, String digits, DigitTreeNodeMatcher<E> matcher) {
        if (digits.length() <= depth) {
            return null;
        }
        int index = tree.nodeIndex(digits, depth);
        DigitTreeNode<E> exactSubtree = this.dgtRoute[index];
        DigitTreeNode<E> wildcardSubtree = this.dgtRoute[tree.getWildCardIndex()];
        DigitTreeObjectNodeMatch<E> exactMatch = null;
        DigitTreeObjectNodeMatch<E> wildcardMatch = null;
        if (exactSubtree != null) {
            exactMatch = exactSubtree.findBestMatch(tree, depth + 1, digits, matcher);
        }
        if (wildcardSubtree != null) {
            wildcardMatch = wildcardSubtree.findBestMatch(tree, depth + 1, digits, matcher);
        }
        return matcher.pickBetterMatch(exactMatch, wildcardMatch);
    }

    @Override
    public void getAllMatches(DigitTree<E> tree, int depth, String digits, DigitTreeNodeMatcher<E> matcher, TreeSet<E> set) {
        if (digits.length() <= depth) {
            return;
        }
        int index = tree.nodeIndex(digits, depth);
        DigitTreeNode<E> exactSubtree = this.dgtRoute[index];
        DigitTreeNode<E> wildcardSubtree = this.dgtRoute[tree.getWildCardIndex()];
        if (exactSubtree != null) {
            exactSubtree.getAllMatches(tree, depth + 1, digits, matcher, set);
        }
        if (wildcardSubtree != null) {
            wildcardSubtree.getAllMatches(tree, depth + 1, digits, matcher, set);
        }
    }

    @Override
    public synchronized void insert(DigitTree<E> tree, int depth, String digits, short min, short max, E object, DigitTreeNodeMatcher<E> matcher) {
        if (log.isFinestEnabled()) {
            log.finest((Object)("insert(" + digits + "/" + min + "/" + max + ") inserting " + object + " at depth " + depth));
        }
        int index = tree.nodeIndex(digits, depth);
        DigitTreeNode<E> node = this.dgtRoute[index];
        if (digits.length() == depth + 1) {
            if (node == null || !node.insertedInSubtree(tree, depth, digits, min, max, object, matcher)) {
                this.dgtRoute[index] = new DigitTreeObjectNode<E>(tree, node, min, max, object);
            }
            return;
        }
        if (node == null) {
            node = new DigitTreeDigitNode<E>(tree);
            this.dgtRoute[index] = node;
        }
        node.insert(tree, depth + 1, digits, min, max, object, matcher);
    }

    @Override
    public boolean insertedInSubtree(DigitTree<E> tree, int depth, String digits, short min, short max, E object, DigitTreeNodeMatcher<E> matcher) {
        if (log.isFinestEnabled()) {
            log.finest((Object)("insertedInSubtree(" + digits + "/" + min + "/" + max + ") inserting " + object + " at depth " + depth));
        }
        return false;
    }

    @Override
    public synchronized DigitTreeNode<E> delete(DigitTree<E> tree, int depth, String digits, short min, short max, DigitTreeNodeMatcher<E> matcher) {
        int index = tree.nodeIndex(digits, depth);
        DigitTreeNode<E> node = this.dgtRoute[index];
        if (node == null) {
            log.error((Object)("Delete null subnode digits=" + digits + " index=" + index + " depth=" + depth));
            throw new UnsupportedOperationException("Pattern/min/max not found");
        }
        DigitTreeNode<E> newSubtree = node.delete(tree, depth + 1, digits, min, max, matcher);
        if (newSubtree == node) {
            return this;
        }
        this.dgtRoute[index] = newSubtree;
        if (newSubtree != null) {
            return this;
        }
        for (int i = 0; i < tree.getMaxDigits(); ++i) {
            if (this.dgtRoute[i] == null) continue;
            return this;
        }
        return null;
    }

    @Override
    public synchronized void update(DigitTree<E> tree, int depth, String digits, short min, short max, E object, DigitTreeNodeMatcher<E> matcher) {
        int index = tree.nodeIndex(digits, depth);
        DigitTreeNode<E> node = this.dgtRoute[index];
        if (node == null) {
            log.error((Object)("Update pattern " + digits + " not found index=" + index + " depth=" + depth));
            throw new IllegalArgumentException("Pattern/min/max not found");
        }
        node.update(tree, depth + 1, digits, min, max, object, matcher);
    }

    @Override
    public synchronized StringBuffer dumpNode(DigitTree<E> tree, String currentDigits) {
        int i;
        char[] map = new char[]{'-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-', '-'};
        for (i = 0; i < tree.getMaxDigits(); ++i) {
            if (this.dgtRoute[i] == null) continue;
            map[i] = tree.getGDAChar(i);
        }
        StringBuffer buf = new StringBuffer(32);
        buf.append("DT: pattern:");
        buf.append(currentDigits);
        buf.append(" subtrees:");
        buf.append(new String(map, 0, tree.getMaxDigits()));
        buf.append("\n");
        for (i = 0; i < tree.getMaxDigits(); ++i) {
            if (this.dgtRoute[i] == null) continue;
            buf.append(this.dgtRoute[i].dumpNode(tree, currentDigits + tree.getGDAChar(i)));
        }
        return buf;
    }

    public static void setLogLevelForJUnit() {
        log.setLevel(LogLevel.INFO);
    }
}

