/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

public class Location {
    protected final Long id;
    protected final String name;
    protected final CACFields cacFields;
    protected final boolean dptEnabled;
    protected final String listedDirectoryNumber;
    protected final Long dptSipEntityId;

    public Location(Long id, String name) {
        this(id, name, false, null, null);
    }

    public Location(Long id, String name, boolean dptEnabled, String listedDirectoryNumber, Long dptSipEntityId) {
        this.id = id;
        this.name = name;
        this.cacFields = null;
        this.dptEnabled = dptEnabled;
        this.listedDirectoryNumber = listedDirectoryNumber;
        this.dptSipEntityId = dptSipEntityId;
    }

    public Location(Long id, String name, Long totalBw, Long multimediaBw, boolean canBorrow, Integer intraLimit, Integer interLimit, long defaultBw, Integer downspeedMinimum, Integer audioAlarmThreshold, Integer multimediaAlarmThreshold, int audioAlarmLatency, int multimediaAlarmLatency, boolean dptEnabled, String listedDirectoryNumber, Long dptSipEntityId) {
        this.id = id;
        this.name = name;
        this.cacFields = new CACFields(totalBw, multimediaBw, canBorrow, intraLimit, interLimit, defaultBw, downspeedMinimum, audioAlarmThreshold, multimediaAlarmThreshold, audioAlarmLatency, multimediaAlarmLatency);
        this.dptEnabled = dptEnabled;
        this.listedDirectoryNumber = listedDirectoryNumber;
        this.dptSipEntityId = dptSipEntityId;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Long getTotalBwAllowed() {
        return this.cacFields == null ? null : this.cacFields.totalBw;
    }

    public Long getMultimediaBwAllowed() {
        return this.cacFields == null ? null : this.cacFields.multimediaBw;
    }

    public boolean getCanBorrow() {
        if (this.cacFields == null) {
            return false;
        }
        return this.cacFields.canBorrow;
    }

    public Long getIntraLimit() {
        if (this.cacFields == null || this.cacFields.intraLimit == null) {
            return null;
        }
        return this.cacFields.intraLimit.longValue();
    }

    public Long getInterLimit() {
        if (this.cacFields == null || this.cacFields.interLimit == null) {
            return null;
        }
        return this.cacFields.interLimit.longValue();
    }

    public Long getDownspeedLimit() {
        if (this.cacFields == null || this.cacFields.downspeedMinimum == null) {
            return null;
        }
        return this.cacFields.downspeedMinimum.longValue();
    }

    public Long getDefaultBandwidthPerCall() {
        if (this.cacFields == null) {
            return null;
        }
        return this.cacFields.defaultBw;
    }

    public Integer getAudioAlarmThreshold() {
        if (this.cacFields == null) {
            return null;
        }
        return this.cacFields.audioAlarmThreshold;
    }

    public Integer getMultimediaAlarmThreshold() {
        if (this.cacFields == null) {
            return null;
        }
        return this.cacFields.multimediaAlarmThreshold;
    }

    public int getAudioAlarmLatency() {
        if (this.cacFields == null) {
            return 0;
        }
        return this.cacFields.audioAlarmLatency;
    }

    public int getMultimediaAlarmLatency() {
        if (this.cacFields == null) {
            return 0;
        }
        return this.cacFields.multimediaAlarmLatency;
    }

    public boolean getDPTEnabled() {
        return this.dptEnabled;
    }

    public String getListedDirectoryNumber() {
        return this.listedDirectoryNumber;
    }

    public Long getDptSipEntityId() {
        return this.dptSipEntityId;
    }

    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.cacFields == null ? other.cacFields != null : !this.cacFields.equals(other.cacFields)) {
            return false;
        }
        if (this.dptEnabled != other.dptEnabled) {
            return false;
        }
        if (this.dptSipEntityId == null ? other.dptSipEntityId != null : !this.dptSipEntityId.equals(other.dptSipEntityId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.listedDirectoryNumber == null ? other.listedDirectoryNumber != null : !this.listedDirectoryNumber.equals(other.listedDirectoryNumber)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "Location [id=" + this.id + ", name=" + this.name + ", cacFields=" + this.cacFields + ", dptEnabled=" + this.dptEnabled + ", listedDirectoryNumber=" + this.listedDirectoryNumber + ", dptSipEntityId=" + this.dptSipEntityId + "]";
    }

    private static class CACFields {
        protected final Long totalBw;
        protected final Long multimediaBw;
        protected final boolean canBorrow;
        protected final Integer intraLimit;
        protected final Integer interLimit;
        protected final long defaultBw;
        protected final Integer downspeedMinimum;
        protected final Integer audioAlarmThreshold;
        protected final Integer multimediaAlarmThreshold;
        protected final int audioAlarmLatency;
        protected final int multimediaAlarmLatency;

        public CACFields(Long totalBw, Long multimediaBw, boolean canBorrow, Integer intraLimit, Integer interLimit, long defaultBw, Integer downspeedMinimum, Integer audioAlarmThreshold, Integer multimediaAlarmThreshold, int audioAlarmLatency, int multimediaAlarmLatency) {
            this.totalBw = totalBw;
            this.multimediaBw = multimediaBw;
            this.canBorrow = canBorrow;
            this.intraLimit = intraLimit;
            this.interLimit = interLimit;
            this.defaultBw = defaultBw;
            this.downspeedMinimum = downspeedMinimum;
            this.audioAlarmThreshold = audioAlarmThreshold;
            this.multimediaAlarmThreshold = multimediaAlarmThreshold;
            this.audioAlarmLatency = audioAlarmLatency;
            this.multimediaAlarmLatency = multimediaAlarmLatency;
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof CACFields)) {
                return false;
            }
            CACFields other = (CACFields)obj;
            if (this.audioAlarmLatency != other.audioAlarmLatency) {
                return false;
            }
            if (this.audioAlarmThreshold == null ? other.audioAlarmThreshold != null : !this.audioAlarmThreshold.equals(other.audioAlarmThreshold)) {
                return false;
            }
            if (this.canBorrow != other.canBorrow) {
                return false;
            }
            if (this.defaultBw != other.defaultBw) {
                return false;
            }
            if (this.downspeedMinimum == null ? other.downspeedMinimum != null : !this.downspeedMinimum.equals(other.downspeedMinimum)) {
                return false;
            }
            if (this.interLimit == null ? other.interLimit != null : !this.interLimit.equals(other.interLimit)) {
                return false;
            }
            if (this.intraLimit == null ? other.intraLimit != null : !this.intraLimit.equals(other.intraLimit)) {
                return false;
            }
            if (this.multimediaAlarmLatency != other.multimediaAlarmLatency) {
                return false;
            }
            if (this.multimediaAlarmThreshold == null ? other.multimediaAlarmThreshold != null : !this.multimediaAlarmThreshold.equals(other.multimediaAlarmThreshold)) {
                return false;
            }
            if (this.multimediaBw == null ? other.multimediaBw != null : !this.multimediaBw.equals(other.multimediaBw)) {
                return false;
            }
            return !(this.totalBw == null ? other.totalBw != null : !this.totalBw.equals(other.totalBw));
        }

        public String toString() {
            return "CACFields[totalBw=" + this.totalBw + ", multimediaBw=" + this.multimediaBw + ", canBorrow=" + this.canBorrow + ", intraLimit=" + this.intraLimit + ", interLimit=" + this.interLimit + ", defaultBw=" + this.defaultBw + ", downspeedMinimum=" + this.downspeedMinimum + ", audioAlarmThreshold=" + this.audioAlarmThreshold + ", multimediaAlarmThreshold=" + this.multimediaAlarmThreshold + ", audioAlarmLatency=" + this.audioAlarmLatency + ", multimediaAlarmLatency=" + this.multimediaAlarmLatency + "]";
        }
    }
}

