/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.RevocationInfoUtilities;
import com.avaya.common.logging.client.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class CRLHolder {
    private static final Logger log = AsmLogger.getLogger(CRLHolder.class);
    private final RevocationInfoUtilities revocationInfoUtilities = RevocationInfoUtilities.getInstance();
    private final String crlFolder = this.revocationInfoUtilities.getCrlFolder();
    private static CopyOnWriteArrayList<X509CRL> crlList = new CopyOnWriteArrayList();
    private static CRLHolder instance = null;

    private CRLHolder() {
        String functionName = "CRLHolder";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)"CRLHolder: Creating new instance.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static CRLHolder getInstance() {
        if (instance != null) return instance;
        Class<CRLHolder> clazz = CRLHolder.class;
        synchronized (CRLHolder.class) {
            if (instance != null) return instance;
            instance = new CRLHolder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected List<X509CRL> getCrlList() {
        String functionName = "getCrlList";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("getCrlList: returning crlList.size()=" + crlList.size()));
        }
        return crlList;
    }

    protected void clearCRLs() {
        String functionName = "clearCRLs";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("clearCRLs: entered. crlFolder=" + this.crlFolder + ", crlList.size()=" + crlList.size()));
        }
        crlList.clear();
        if (isFinerEnabled) {
            log.finer((Object)("clearCRLs: leaving. crlList.size()=" + crlList.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadCRLs() {
        block26: {
            String functionName = "loadCRLs";
            boolean isFinerEnabled = log.isFinerEnabled();
            if (isFinerEnabled) {
                log.finer((Object)("loadCRLs: entered. crlFolder=" + this.crlFolder));
            }
            if (this.crlFolder != null) {
                ArrayList<X509CRL> crls = new ArrayList<X509CRL>();
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                    File folder = new File(this.crlFolder);
                    if (folder.exists() && folder.isDirectory()) {
                        for (File fileEntry : folder.listFiles()) {
                            if (!fileEntry.isFile()) continue;
                            String crlFilename = fileEntry.getAbsolutePath();
                            if (this.revocationInfoUtilities.isValidCrlFilename(crlFilename)) {
                                FileInputStream inStream = null;
                                try {
                                    inStream = new FileInputStream(fileEntry);
                                    if (isFinerEnabled) {
                                        log.finer((Object)("loadCRLs: Loading CRL. crlFileName=" + crlFilename));
                                    }
                                    X509CRL crl = (X509CRL)cf.generateCRL(inStream);
                                    crls.add(crl);
                                    continue;
                                }
                                catch (CRLException e) {
                                    log.error((Object)("loadCRLs: Unable to parse. crlFilename=" + crlFilename));
                                    continue;
                                }
                                catch (FileNotFoundException e) {
                                    log.error((Object)("loadCRLs: File not found. crlFilename=" + crlFilename));
                                    continue;
                                }
                                finally {
                                    if (inStream != null) {
                                        try {
                                            ((InputStream)inStream).close();
                                        }
                                        catch (IOException e) {
                                            log.error((Object)("loadCRLs: Unable to close. crlFilename=" + crlFilename), (Throwable)e);
                                        }
                                    }
                                }
                            }
                            if (!isFinerEnabled) continue;
                            log.finer((Object)("loadCRLs: Invalid CRL filename. crlFilename=" + crlFilename));
                        }
                        crlList.clear();
                        crlList.addAll(crls);
                        if (isFinerEnabled) {
                            log.finer((Object)("loadCRLs: leaving. Number of CRLs loaded=" + crlList.size()));
                        }
                        break block26;
                    }
                    log.error((Object)("loadCRLs: leaving. CRL Folder does not exist. crlFolder=" + this.crlFolder));
                }
                catch (CertificateException e1) {
                    log.error((Object)"loadCRLs: leaving. Unable to find the X.509 CertificateFactory", (Throwable)e1);
                }
            } else {
                log.error((Object)"loadCRLs: leaving. CRL Location is null");
            }
        }
    }
}

