/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.authorization.resource;

import com.avaya.collaboration.authorization.AuthorizationHelperException;
import com.avaya.collaboration.authorization.resource.AuthorizationData;
import com.avaya.collaboration.authorization.spi.ResourceHelperProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProviderException;

public final class AuthorizationResourceHelper {
    private static ResourceHelperProvider resourceHelperDelegate;
    private static String authorizationResourceHelperDelegateImpl;
    private static Object lock;

    private AuthorizationResourceHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResourceHelperProvider getAuthorizationResourceHelperDelegate() {
        Object object = lock;
        synchronized (object) {
            if (resourceHelperDelegate == null) {
                Constructor<?> constructor;
                Class<?> clazz;
                try {
                    clazz = Class.forName(authorizationResourceHelperDelegateImpl);
                }
                catch (ClassNotFoundException e) {
                    throw new ProviderException("failed to find delegate class: " + authorizationResourceHelperDelegateImpl, e);
                }
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new ProviderException("failed to find the default constructor of the delegate class: " + authorizationResourceHelperDelegateImpl, e);
                }
                try {
                    resourceHelperDelegate = (ResourceHelperProvider)constructor.newInstance(new Object[0]);
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new ProviderException("failed to instanstiate the delegate class: " + authorizationResourceHelperDelegateImpl, e);
                }
            }
        }
        return resourceHelperDelegate;
    }

    public static boolean isValid(String bearerToken) throws AuthorizationHelperException {
        return AuthorizationResourceHelper.getAuthorizationResourceHelperDelegate().isValid(bearerToken);
    }

    public static AuthorizationData getAuthorizationData(String bearerToken) throws AuthorizationHelperException {
        return AuthorizationResourceHelper.getAuthorizationResourceHelperDelegate().getAuthorizationData(bearerToken);
    }

    static {
        authorizationResourceHelperDelegateImpl = "com.avaya.collaboration.authorization.resource.ResourceHelperProviderImpl";
        lock = new Object();
    }
}

