/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.avaya.commons.lang.CanNotCloseProcessStreamException;
import com.avaya.commons.lang.CanNotReadProcessOutputException;
import com.avaya.commons.lang.CanNotStartProcessException;
import com.avaya.commons.lang.IllegalProcessInterruptionException;
import com.avaya.commons.lang.ProcessException;
import com.avaya.commons.lang.ProcessResult;
import com.avaya.commons.lang.ProcessRunner;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;

final class ProcessBuilderRunner
implements ProcessRunner {
    private final ProcessBuilder processBuilder;

    public ProcessBuilderRunner(File workingDir, String ... processArguments) {
        this(processArguments);
        ArgAssert.assertNotNull(workingDir, "workingDir");
        if (!workingDir.exists()) {
            throw new IllegalArgumentException("Specified base directory doesn't exist: " + workingDir);
        }
        this.processBuilder.directory(workingDir);
    }

    public ProcessBuilderRunner(String ... processArguments) {
        ArgAssert.assertNotNull(processArguments, "processArguments");
        this.processBuilder = new ProcessBuilder(processArguments);
        this.processBuilder.redirectErrorStream(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessResult runProcess() throws ProcessException {
        int terminationStatus;
        String processOutput;
        Process process = this.startProcess();
        try {
            processOutput = this.readOutputOfProcess(process);
            terminationStatus = this.waitFor(process);
        }
        finally {
            this.closeOutputStreams(process);
        }
        return new ProcessResult(terminationStatus, processOutput);
    }

    private int waitFor(Process process) throws IllegalProcessInterruptionException {
        try {
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new IllegalProcessInterruptionException(process, (Throwable)e);
        }
    }

    private Process startProcess() throws CanNotStartProcessException {
        try {
            return this.processBuilder.start();
        }
        catch (IOException e) {
            throw new CanNotStartProcessException("Working directory = " + this.processBuilder.directory() + "Command = " + this.processBuilder.command().get(0), e);
        }
    }

    private String readOutputOfProcess(Process process) throws CanNotReadProcessOutputException {
        InputStreamReader outputOfProcess = new InputStreamReader(process.getInputStream());
        try {
            return IOUtils.toString((Reader)outputOfProcess);
        }
        catch (IOException e) {
            throw new CanNotReadProcessOutputException(e);
        }
    }

    private void closeOutputStreams(Process process) throws CanNotCloseProcessStreamException {
        try {
            process.getInputStream().close();
        }
        catch (IOException e) {
            throw new CanNotCloseProcessStreamException(e);
        }
        finally {
            try {
                process.getErrorStream().close();
            }
            catch (IOException e) {
                throw new CanNotCloseProcessStreamException(e);
            }
        }
    }
}

