/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.platform.dal.api;

import com.avaya.aus.archiveschemas.properties.ObjectFactory;
import com.avaya.aus.archiveschemas.properties.Service;
import com.avaya.common.logging.client.Logger;
import com.avaya.zephyr.platform.dal.api.ServiceDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class ServiceUtil {
    private static Logger logger = Logger.getLogger(ServiceUtil.class);
    private static volatile ServiceDescriptor sd = null;
    private static volatile boolean configFileReadAttempted = false;
    private static boolean propertiesXmlFileRead = false;
    private static ClassLoader classLoader = ServiceDescriptor.class.getClassLoader();
    private static String configFile = "/service.properties";
    private static String propertiesFile = "/properties.xml";

    private ServiceUtil() {
    }

    public static ServiceDescriptor getServiceDescriptor() {
        if (sd != null) {
            return sd;
        }
        ServiceUtil.readConfig();
        if (sd == null) {
            return null;
        }
        ServiceUtil.readProperties();
        return sd;
    }

    protected static void setSd(ServiceDescriptor sd) {
        ServiceUtil.sd = sd;
    }

    protected static void setConfigFile(String configFile) {
        ServiceUtil.configFile = configFile;
    }

    protected static void setPropertiesFile(String propertiesFile) {
        ServiceUtil.propertiesFile = propertiesFile;
    }

    protected static boolean getPropertiesXmlFileRead() {
        return propertiesXmlFileRead;
    }

    protected static void setPropertiesXmlFileRead(boolean propertiesXmlFileRead) {
        ServiceUtil.propertiesXmlFileRead = propertiesXmlFileRead;
    }

    protected static void setConfigFileReadAttempted(boolean configFileReadAttempted) {
        ServiceUtil.configFileReadAttempted = configFileReadAttempted;
    }

    protected static synchronized void readConfig() {
        if (configFileReadAttempted) {
            return;
        }
        Properties properties = new Properties();
        InputStream configIn = classLoader.getResourceAsStream(configFile);
        configFileReadAttempted = true;
        if (logger.isFinestEnabled()) {
            logger.finest((Object)("class:" + ServiceDescriptor.class + " classLoader " + classLoader));
        }
        if (configIn == null) {
            logger.error((Object)("Config file does not exist: " + configFile));
            return;
        }
        try {
            properties.load(configIn);
            sd = new ServiceDescriptor(properties.getProperty("serviceName"), properties.getProperty("serviceVersion"));
        }
        catch (Exception e) {
            logger.error((Object)("Caught Exception: " + e));
        }
        try {
            configIn.close();
        }
        catch (IOException e) {
            logger.error((Object)("Caught IO Exception: " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void readProperties() {
        InputStream propertiesIn = classLoader.getResourceAsStream(propertiesFile);
        if (propertiesIn == null) {
            if (logger.isFineEnabled()) {
                logger.fine((Object)("Properties file does not exist: " + propertiesFile));
            }
            return;
        }
        JAXBContext jaxbContext = null;
        Unmarshaller unmarshaller = null;
        Service service = null;
        try {
            jaxbContext = JAXBContext.newInstance((String)"com.avaya.aus.archiveschemas.properties", (ClassLoader)ObjectFactory.class.getClassLoader());
            unmarshaller = jaxbContext.createUnmarshaller();
            service = (Service)unmarshaller.unmarshal(propertiesIn);
        }
        catch (JAXBException e) {
            logger.error((Object)("Unmarshalling of properties.xml file failed" + (Object)((Object)e)));
            return;
        }
        finally {
            try {
                propertiesIn.close();
            }
            catch (IOException iOException) {}
        }
        propertiesXmlFileRead = true;
        if (service != null) {
            sd.setEventListenerClass(service.getEventListenerClass());
            sd.setCallListenerClass(service.getCallListenerClass());
        }
    }
}

