/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.cassandra.locator;

import java.nio.ByteBuffer;

public class TokenComps {
    long asmId = 0L;
    long bsmId = 0L;
    long commId = 0L;
    long setId = 0L;
    boolean valid = false;

    public TokenComps() {
    }

    public TokenComps(long asmId, long bsmId, long commId, long setId, boolean valid) {
        this.asmId = asmId;
        this.bsmId = bsmId;
        this.commId = commId;
        this.setId = setId;
        this.valid = valid;
    }

    public TokenComps(ByteBuffer byteBuffer) {
        this.init(byteBuffer);
    }

    public void init(ByteBuffer byteBuffer) {
        byteBuffer.getShort();
        this.asmId = byteBuffer.getLong();
        byteBuffer.get();
        byteBuffer.getShort();
        this.bsmId = byteBuffer.getLong();
        byteBuffer.get();
        byteBuffer.getShort();
        this.commId = byteBuffer.getLong();
        byteBuffer.get();
        byteBuffer.getShort();
        this.setId = byteBuffer.getLong();
        this.valid = true;
    }

    public long getAsmId() {
        return this.asmId;
    }

    public long getBsmId() {
        return this.bsmId;
    }

    public long getCommId() {
        return this.commId;
    }

    public long getSetId() {
        return this.setId;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "TokenComps [asmId=" + this.asmId + ", bsmId=" + this.bsmId + ", commId=" + this.commId + ", setId=" + this.setId + ", valid=" + this.valid + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.asmId ^ this.asmId >>> 32);
        result = 31 * result + (int)(this.bsmId ^ this.bsmId >>> 32);
        result = 31 * result + (int)(this.commId ^ this.commId >>> 32);
        result = 31 * result + (int)(this.setId ^ this.setId >>> 32);
        result = 31 * result + (this.valid ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TokenComps other = (TokenComps)obj;
        if (this.asmId != other.asmId) {
            return false;
        }
        if (this.bsmId != other.bsmId) {
            return false;
        }
        if (this.commId != other.commId) {
            return false;
        }
        if (this.setId != other.setId) {
            return false;
        }
        return this.valid == other.valid;
    }
}

