/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.core;

import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmConstants;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.Limits;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.dao.LocalParamDAO;
import com.avaya.common.logging.client.Logger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocalSettings {
    private static final Logger log = AsmLogger.getLogger(LocalSettings.class);
    protected static Map<String, Limits> limitMap = null;
    protected static List<Field> loadedFields = null;
    protected static DMFactory dmFactory = null;
    protected static final int MAX_PROFILE_CPUS = 20;

    public static void setJUnitDMFactory(DMFactory dmFactory) {
        LocalSettings.dmFactory = dmFactory;
    }

    protected static DMFactory getDMFactory() {
        if (AsmCommon.jUnitEnvironment) {
            return dmFactory;
        }
        return DMFactory.getInstance();
    }

    protected static synchronized void loadLocalSettings(Class<?> localParameters) {
        if (limitMap == null) {
            limitMap = new ConcurrentHashMap<String, Limits>();
            loadedFields = new ArrayList<Field>();
        }
        for (Field field : localParameters.getFields()) {
            Limits limits = field.getAnnotation(Limits.class);
            limitMap.put(field.getName(), limits);
            if (loadedFields.contains(field)) continue;
            loadedFields.add(field);
        }
    }

    public static String verifyLimits(String settingName, String value) throws IllegalArgumentException {
        String foundField = null;
        for (Map.Entry<String, Limits> field : limitMap.entrySet()) {
            String name = field.getKey();
            if (!name.equalsIgnoreCase(settingName)) continue;
            Limits limits = field.getValue();
            if (limits == null) {
                log.error((Object)("SMConsole unable to set local setting \"" + settingName + "\" due to lack of Limits annotation"));
                throw new IllegalArgumentException("Setting is broken. No Limits annotation was provided for it.");
            }
            if (limits.type().equals(Long.class) || limits.type().equals(Integer.class)) {
                long parsedValue = Long.parseLong(value);
                if (limits.minimum() != Long.MIN_VALUE && parsedValue < limits.minimum()) {
                    throw new IllegalArgumentException("minimum value " + limits.minimum() + " exceeded!");
                }
                if (limits.maximum() != Long.MAX_VALUE && parsedValue > limits.maximum()) {
                    throw new IllegalArgumentException("maximum value " + limits.maximum() + " exceeded!");
                }
            } else if (limits.type().equals(Float.class) || limits.type().equals(Double.class)) {
                double parsedValue = Double.parseDouble(value);
                if (limits.minimum() != Long.MIN_VALUE && parsedValue < (double)limits.minimum()) {
                    throw new IllegalArgumentException("minimum value " + limits.minimum() + " exceeded!");
                }
                if (limits.maximum() != Long.MAX_VALUE && parsedValue > (double)limits.maximum()) {
                    throw new IllegalArgumentException("maximum value " + limits.maximum() + " exceeded!");
                }
            } else if (limits.type().equals(Boolean.class)) {
                if (!value.equalsIgnoreCase("false") && !value.equalsIgnoreCase("true")) {
                    throw new IllegalArgumentException("incorrect boolean value: " + value);
                }
            } else if (!limits.type().equals(String.class)) {
                log.error((Object)("SMConsole unable to set local setting \"" + settingName + "\" of type " + limits.type().toString()));
                throw new IllegalArgumentException("type " + limits.type().toString() + " not supported!");
            }
            if (log.isFinestEnabled()) {
                log.finest((Object)("verifyLimits: Found " + name + " and verified."));
            }
            foundField = name;
        }
        return foundField;
    }

    public static String getLocalParameter(String paramName) {
        String dbValue = LocalSettings.getDBValue(paramName);
        if (dbValue != null) {
            return dbValue;
        }
        for (Map.Entry<String, Limits> field : limitMap.entrySet()) {
            String name = field.getKey();
            if (!name.equalsIgnoreCase(paramName)) continue;
            dbValue = null;
            try {
                dbValue = LocalSettings.getDBValue(name);
            }
            catch (Exception e) {
                log.warn((Object)("Error getting " + name + " value from database."));
            }
            if (dbValue == null) {
                Limits limits = field.getValue();
                if (limits == null) break;
                String defaultValue = LocalSettings.getDefaultValue(limits);
                try {
                    LocalSettings.setDBValue(name, defaultValue);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return defaultValue;
            }
            return dbValue;
        }
        if (log.isFinestEnabled()) {
            log.finest((Object)("getLocalParameter: paramName not found: " + paramName));
        }
        return dbValue;
    }

    public static String getDefaultValue(String settingName) {
        for (Map.Entry<String, Limits> field : limitMap.entrySet()) {
            if (!field.getKey().equalsIgnoreCase(settingName)) continue;
            return LocalSettings.getDefaultValue(field.getValue());
        }
        return null;
    }

    public static String getDefaultValue(Limits limits) {
        return limits.scaleToProfile() ? LocalSettings.scaleToProfile(limits.defaultValue()) : limits.defaultValue();
    }

    private static String scaleToProfile(String defaultValue) {
        if (defaultValue == null) {
            return null;
        }
        try {
            long longValue = Long.parseLong(defaultValue);
            defaultValue = Long.toString((longValue * (long)Runtime.getRuntime().availableProcessors() + 10L) / 20L);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Cannot scale local setting, bad defaultValue number format: " + defaultValue));
        }
        return defaultValue;
    }

    public static String getDBValue(String name) {
        if (AsmCommon.jUnitEnvironment && dmFactory == null) {
            return null;
        }
        return ((LocalParamDAO)LocalSettings.getDMFactory().getDataMgr(LocalParamDAO.class)).getParameter(name);
    }

    public static void setDBValue(String name, String value) {
        if (AsmCommon.jUnitEnvironment && dmFactory == null) {
            return;
        }
        ((LocalParamDAO)LocalSettings.getDMFactory().getDataMgr(LocalParamDAO.class)).setParameter(name, value);
    }

    public static List<Field> getLoadedSettings() {
        ArrayList<Field> rtnList = new ArrayList<Field>(loadedFields);
        Collections.sort(rtnList, new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return rtnList;
    }

    public static Integer getDatabaseRetries() {
        try {
            return Integer.parseInt(LocalSettings.getLocalParameter("DATABASE_RETRIES"));
        }
        catch (NumberFormatException e) {
            return 2;
        }
    }

    public static Integer getDatabaseTimeout() {
        try {
            return Integer.parseInt(LocalSettings.getLocalParameter("DATABASE_TIMEOUT"));
        }
        catch (NumberFormatException e) {
            return 10000;
        }
    }

    public static Long getJGroupTypeRetryInterval() {
        try {
            return 1000L * Long.parseLong(LocalSettings.getLocalParameter("JGROUP_TYPE_RETRY_INTERVAL"));
        }
        catch (NumberFormatException e) {
            return 10000L;
        }
    }

    public static int getMinContiguousEventsForReinit() {
        try {
            return Integer.parseInt(LocalSettings.getLocalParameter("MIN_CONTIG_EVENTS_REINIT"));
        }
        catch (NumberFormatException e) {
            return 50;
        }
    }

    public static double getMinThresholdContiguousEventsForReinit() {
        try {
            return Double.parseDouble(LocalSettings.getLocalParameter("MIN_CONTIG_EVENTS_REINIT_THRESHOLD"));
        }
        catch (NumberFormatException e) {
            return 0.1;
        }
    }

    public static int getAssetMonitoringInterval() {
        try {
            return Integer.parseInt(LocalSettings.getLocalParameter("ASSET_MONITORING_INTERVAL"));
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static {
        LocalSettings.loadLocalSettings(AsmConstants.LOCAL_PARAMETERS.class);
    }
}

