/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.BLDMEnumType;
import com.avaya.asm.datamgr.CallHistoryDM_70;
import com.avaya.asm.datamgr.DMFactory;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.SMCallHistoryAPI;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.SetCommunityDAO;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.dao.UserSetDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.CallLog;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.KeyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class SMCallHistoryDM_70
extends DataAccessObject
implements SMCallHistoryAPI {
    CallHistoryDM_70 callHistoryDM = new CallHistoryDM_70();
    private final Logger log = AsmLogger.getLogger(SMCallHistoryDM_70.class);
    private static DMFactory factory;

    public static DMFactory getFactory() {
        if (factory == null) {
            factory = DMFactory.getInstance();
        }
        return factory;
    }

    public void setFactory(DMFactory dmFactory) {
        factory = dmFactory;
    }

    @Override
    public void addCallHistory(long cscommprofilesetId, Integer maxLogs, List<CallLog> callLogs) {
        String fcn_name = "addCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("addCallHistory: enter, cscommProfilesetId=" + cscommprofilesetId + ", maxLog=" + maxLogs + ", callLogs.size()=" + callLogs.size()));
        }
        KeyInfo keyInfo = this.getKeyInfo(cscommprofilesetId);
        try {
            this.callHistoryDM.addCallHistory(keyInfo, maxLogs, callLogs);
        }
        catch (DMException exc) {
            this.log.error((Object)("addCallHistory: DMException thrown by callHistoryDM.addCallHistory() for keyInfo = " + keyInfo + ", maxLogs = " + maxLogs + ", callLogs = " + callLogs), (Throwable)exc);
        }
        if (isFiner) {
            this.log.finer((Object)"addCallHistory: leave");
        }
    }

    @Override
    public void deleteCallHistoryById(long cscommprofilesetId, List<UUID> callLogUuids) {
        KeyInfo keyInfo;
        String fcn_name = "deleteCallHistoryById";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryById: enter, cscommProfilesetId=" + cscommprofilesetId + ", callLogUuids.size()=" + callLogUuids.size()));
        }
        if ((keyInfo = this.getKeyInfo(cscommprofilesetId)) == null) {
            this.log.warn((Object)("deleteCallHistoryById: cannot get keyInfo for set id " + cscommprofilesetId));
            return;
        }
        try {
            this.callHistoryDM.deleteCallHistoryById(keyInfo, callLogUuids);
        }
        catch (DMException exc) {
            this.log.error((Object)("deleteCallHistoryById: DMException thrown by callHistoryDM.deleteCallHistoryById() for keyInfo=" + keyInfo + ", callLogUuids=" + callLogUuids), (Throwable)exc);
        }
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryById: leave");
        }
    }

    @Override
    public void deleteCallHistoryByLimit(long cscommprofilesetId, int maxLogs) {
        String fcn_name = "deleteCallHistoryByLimit";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteCallHistoryByLimit: enter, cscommProfilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs));
        }
        KeyInfo keyInfo = this.getKeyInfo(cscommprofilesetId);
        try {
            this.callHistoryDM.deleteCallHistoryByLimit(keyInfo, maxLogs);
        }
        catch (DMException exc) {
            this.log.error((Object)("deleteCallHistoryByLimit: DMException thrown by callHistoryDM.deleteCallHistoryByLimit() for keyInfo = " + keyInfo + ", maxLogs = " + maxLogs), (Throwable)exc);
        }
        if (isFiner) {
            this.log.finer((Object)"deleteCallHistoryByLimit: leave");
        }
    }

    @Override
    public List<CallLog> getCallHistory(long cscommprofilesetId, Integer maxLogs) {
        String fcn_name = "getCallHistory";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: enter, cscommProfilesetId=" + cscommprofilesetId + ", maxLogs=" + maxLogs));
        }
        KeyInfo keyInfo = this.getKeyInfo(cscommprofilesetId);
        List<CallLog> callLogs = null;
        try {
            callLogs = this.callHistoryDM.getCallHistory(keyInfo, maxLogs);
        }
        catch (DMException exc) {
            this.log.error((Object)("getCallHistory: DMException thrown by callHistoryDM.getCallHistory() for keyInfo = " + keyInfo + ", maxLogs = " + maxLogs), (Throwable)exc);
        }
        if (isFiner) {
            this.log.finer((Object)("getCallHistory: leave, having found " + callLogs.size() + " Call Logs."));
        }
        return callLogs;
    }

    @Override
    public void init() {
        this.log.info((Object)"Started initializing SMCallHistoryDM");
        DataMgr.Status status = DataMgr.Status.OKAY;
        for (dmTypes dm : dmTypes.values()) {
            DataMgr dataMgr = dm.get();
            if (dataMgr.okay()) continue;
            status = DataMgr.Status.FAIL;
            this.log.error((Object)("Failed to init: " + dm));
        }
        this.setStatus(status);
        this.log.info((Object)"Finished initializing SMCallHistoryDM");
    }

    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        boolean isFine = this.log.isFineEnabled();
        if (isFine) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        if (isFine) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "No changes performed currently in this updateDAO method."));
        }
    }

    KeyInfo getKeyInfo(long cscommprofilesetId) {
        String fcn_name = "getKeyInfo";
        Long csuserId = ((UserSetDAO)dmTypes.USER_SET_DAO.get()).getUserId(cscommprofilesetId);
        if (csuserId == null) {
            this.log.warn((Object)("getKeyInfo: cannot get the csuserId for set id " + cscommprofilesetId));
            return null;
        }
        Long userCommId = ((SetCommunityDAO)dmTypes.SET_COMMUNITY_DAO.get()).getUserCommunityId(cscommprofilesetId);
        if (userCommId == null) {
            this.log.warn((Object)("getKeyInfo: cannot get userCommId for set id " + cscommprofilesetId));
            return null;
        }
        List<Long> asmInstIds = ((UserCommunityDAO)dmTypes.USER_COMMUNITY_DAO.get()).getUserCommAsmInstanceIds(userCommId);
        if (asmInstIds == null) {
            this.log.warn((Object)("getKeyInfo: cannot get asmInstIds for comm id " + userCommId + ", set id " + cscommprofilesetId));
            return null;
        }
        return new KeyInfo(asmInstIds.get(0), userCommId, 0L, csuserId, cscommprofilesetId, asmInstIds.size());
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csuser");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return null;
    }

    @Override
    public void deleteAllCallHistory(long cscommprofilesetId) throws DMException {
    }

    @Override
    public void moveCallHistory(long oldCommProfileSetId, long newCommProfileSetId) throws DMException {
    }

    public static enum dmTypes implements BLDMEnumType
    {
        USER_SET_DAO(UserSetDAO.class),
        USER_COMMUNITY_DAO(UserCommunityDAO.class),
        SET_COMMUNITY_DAO(SetCommunityDAO.class);

        private Class<? extends DataMgr> subDM;

        private dmTypes(Class<? extends DataMgr> dm) {
            this.subDM = dm;
        }

        @Override
        public DataMgr get() {
            return SMCallHistoryDM_70.getFactory().getDataMgr(this.subDM);
        }
    }
}

