/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AppSetRegExp;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.PatternSyntaxException;

public class AppSetRegExpDAO
extends DataAccessObject
implements Serializable {
    private static final long serialVersionUID = 8229479868651843012L;
    protected final Logger log = AsmLogger.getLogger(AppSetRegExpDAO.class);
    protected Map<Long, AppSetRegExp> appsetRegexpMap = new ConcurrentHashMap<Long, AppSetRegExp>();
    protected ConcurrentSkipListSet<AppSetRegExp> ranked = new ConcurrentSkipListSet();
    protected static final String getAppSetRegExpMaps = "SELECT id, pattern, origappset_id, termappset_id, emer_origappset_id, emer_termappset_id FROM asmregexptoappset";
    protected static final String getAppSetRegExpMap = "SELECT id, pattern, origappset_id, termappset_id, emer_origappset_id, emer_termappset_id FROM asmregexptoappset WHERE id = ?";
    protected final ResultSetMapper appsetRegexpMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ConcurrentHashMap<Long, AppSetRegExp> map = new ConcurrentHashMap<Long, AppSetRegExp>();
            while (rs.next()) {
                try {
                    long id = rs.getLong("id");
                    AppSetRegExp appsetregexp = new AppSetRegExp(id, rs.getString("pattern"), rs.getLong("origappset_id"), rs.getLong("termappset_id"), rs.getLong("emer_origappset_id"), rs.getLong("emer_termappset_id"));
                    map.put(id, appsetregexp);
                }
                catch (PatternSyntaxException e) {
                    AppSetRegExpDAO.this.log.error((Object)"appsetregexpMapper()", (Throwable)e);
                }
            }
            return map;
        }
    };

    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(AppSetRegExpDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        if (tableName.equalsIgnoreCase("asmregexptoappset")) {
            this.updateAppSetRegexpmap(id, operation);
            return;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(AppSetRegExpDAO.class.getSimpleName() + " update successful"));
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("asmregexptoappset");
        return list;
    }

    @Override
    protected Object getMainCollection() {
        return null;
    }

    @Override
    public void init() {
        Map regexpMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + AppSetRegExpDAO.class.getSimpleName()));
        }
        ConcurrentSkipListSet<AppSetRegExp> rankedTMP = new ConcurrentSkipListSet<AppSetRegExp>();
        try {
            Object[] params = new Object[]{};
            regexpMapTMP = (Map)this.dataSource.executeQuery(getAppSetRegExpMaps, params, this.appsetRegexpMapper);
            for (AppSetRegExp appsetregexp : regexpMapTMP.values()) {
                rankedTMP.add(appsetregexp);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            this.handleFailureEvent(e);
            return;
        }
        this.appsetRegexpMap = regexpMapTMP;
        this.ranked = rankedTMP;
    }

    protected void handleFailureEvent(Exception e) {
        GenericAlarmHandler.handleFailureEvent(this, e);
    }

    private boolean updateAppSetRegexpmap(long id, DAOReplicationEvent.OperationType operation) {
        block6: {
            if (this.appsetRegexpMap.containsKey(id)) {
                AppSetRegExp re = this.appsetRegexpMap.get(id);
                this.ranked.remove(re);
                this.appsetRegexpMap.remove(id);
            }
            if (operation == DAOReplicationEvent.OperationType.UPDATE || operation == DAOReplicationEvent.OperationType.INSERT) {
                try {
                    Object[] params = new Object[]{id};
                    Map map = (Map)this.dataSource.executeQuery(getAppSetRegExpMap, params, this.appsetRegexpMapper);
                    if (map.size() == 0) {
                        throw new DMException("read " + map.size() + " appsetregexpmap(" + id + ") from database");
                    }
                    AppSetRegExp re = (AppSetRegExp)map.get(id);
                    if (this.log.isFinerEnabled()) {
                        this.log.finer((Object)("Retrieved new AppSetRegExp " + re));
                    }
                    this.appsetRegexpMap.put(id, re);
                    this.ranked.add(re);
                }
                catch (DMException e) {
                    this.log.error((Object)"Error updating AsmRegExpToAppSetDAO object; re-initializing", (Throwable)e);
                    this.reinit();
                    if (this.okay()) break block6;
                    this.log.error((Object)(this.getClass().getSimpleName() + " Update NOT successful!"));
                    return false;
                }
            }
        }
        return true;
    }

    public AppSetRegExp getMatchingAppSetRegExp(String address) {
        for (AppSetRegExp regexp : this.ranked) {
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("getMatchingAppSetRegExp(" + address + "): trying " + regexp));
            }
            if (!regexp.matches(address)) continue;
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("getMatchingAppSetRegExp(" + address + ") returning " + regexp));
            }
            return regexp;
        }
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("getMatchingAppSetRegExp(" + address + ") returned not found"));
        }
        return null;
    }

    public void setLogLevelForJUnit() {
        this.log.setLevel(LogLevel.INFO);
    }

    @SMConsole(description="Get All The AppSet ReqExp Info.")
    public Map<Long, AppSetRegExp> getAllAppSetRegExps() {
        try {
            this.lock.acquireReadLock();
            Map<Long, AppSetRegExp> map = Collections.unmodifiableMap(this.appsetRegexpMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

