/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CassandraEventingDAO
extends DataAccessObject {
    public static final String DEVICE_DATA_TABLE_NAME = "device";
    public static final String DAO_TABLE_EVENT_KEY_DEVICEHANDLE = "deviceHandle";
    public static final String DAO_TABLE_EVENT_KEY_CMID = "cmId";
    private List<String> dependentTables = new ArrayList<String>();
    Map<?, ?> mainCollection = new HashMap();

    public CassandraEventingDAO() {
        super(true);
        this.dependentTables.add(DEVICE_DATA_TABLE_NAME);
    }

    @Override
    public void updateDAO(DAOTableEvent tableEvent) {
        DAOReplicationEvent.OperationType operation = tableEvent.getOperation();
        String tableName = tableEvent.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        DAOTableEvent oldObject = null;
        DAOTableEvent newObject = null;
        switch (operation) {
            case INSERT: {
                oldObject = null;
                newObject = tableEvent;
                break;
            }
            case UPDATE: {
                oldObject = tableEvent;
                newObject = tableEvent;
                break;
            }
            case DELETE: {
                oldObject = tableEvent;
                newObject = null;
            }
        }
        this.updateListeners(oldObject, newObject);
    }

    @Override
    public List<String> getDependentTables() {
        return this.dependentTables;
    }

    @Override
    public int numChangesBeforeReinit() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected Object getMainCollection() {
        return this.mainCollection;
    }

    @Override
    public void init() {
        this.setStatus(DataMgr.Status.OKAY);
    }
}

