/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.LocationPatternStructure;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DigitMapDAO
extends DataAccessObject {
    private static final Logger log = AsmLogger.getLogger(DigitMapDAO.class);
    private Map<Long, LocationPatternStructure> emergencyDMMap = new HashMap<Long, LocationPatternStructure>();
    private Map<Long, ArrayList<Long>> emergencyLocationMap = new HashMap<Long, ArrayList<Long>>();
    private static final String queryDMs = "SELECT id, digitpattern, routingorigination_id, deny, emergency_desc, emergency_order, digitmap_origination_pattern_set_id FROM digitmap WHERE treatasemergency = 't'";
    private static final String queryDM = "SELECT id, digitpattern, routingorigination_id, deny, emergency_desc, emergency_order, digitmap_origination_pattern_set_id FROM digitmap WHERE treatasemergency = 't' AND id = ?";
    static Long Location_ALL = new Long(0L);
    private static final ResultSetMapper digitMapsMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, LocationPatternStructure> dmMap = new HashMap<Long, LocationPatternStructure>();
            while (rs.next()) {
                Long id = rs.getLong("id");
                dmMap.put(id, DigitMapDAO.retrieveMapperData(rs));
            }
            return dmMap;
        }
    };
    private static final ResultSetMapper digitMapMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return DigitMapDAO.retrieveMapperData(rs);
            }
            return null;
        }
    };

    public DigitMapDAO() {
        super(true);
    }

    public static ResultSetMapper getDigitMapsMapper() {
        return digitMapsMapper;
    }

    public static ResultSetMapper getDigitMapMapper() {
        return digitMapMapper;
    }

    private static LocationPatternStructure retrieveMapperData(ResultSet rs) throws SQLException {
        String digitpattern = rs.getString("digitpattern");
        long routingorigination_id = rs.getLong("routingorigination_id");
        boolean deny = rs.getBoolean("deny");
        String emerDesc = rs.getString("emergency_desc");
        int emerOrder = rs.getInt("emergency_order");
        long origination_pattern_set_id = rs.getLong("digitmap_origination_pattern_set_id");
        return new LocationPatternStructure(routingorigination_id, digitpattern, deny, emerDesc, emerOrder, origination_pattern_set_id);
    }

    @Override
    public Object getMainCollection() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void init() {
        boolean isFineEnabled = log.isFineEnabled();
        if (isFineEnabled) {
            log.fine((Object)("Initializing " + DigitMapDAO.class.getSimpleName()));
        }
        Map digitMapTMP = null;
        HashMap<Long, LocationPatternStructure> emergencyDMMapTMP = null;
        HashMap<Long, ArrayList<Long>> emergencyLocationMapTMP = null;
        try {
            Object[] params = new Object[]{};
            digitMapTMP = (Map)this.dataSource.executeQuery(queryDMs, params, DigitMapDAO.getDigitMapsMapper());
            emergencyDMMapTMP = new HashMap<Long, LocationPatternStructure>();
            emergencyLocationMapTMP = new HashMap<Long, ArrayList<Long>>();
            this.initializeEmergencyMaps(digitMapTMP, emergencyDMMapTMP, emergencyLocationMapTMP);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e2) {
            this.setStatus(DataMgr.Status.FAIL);
            log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e2);
            GenericAlarmHandler.handleFailureEvent(this, e2);
        }
        try {
            this.lock.acquireWriteLock();
            this.emergencyDMMap = emergencyDMMapTMP;
            this.emergencyLocationMap = emergencyLocationMapTMP;
        }
        finally {
            this.lock.releaseWriteLock();
            log.fine((Object)"DigitMapDAO: completing init");
        }
    }

    private void initializeEmergencyMaps(Map<Long, LocationPatternStructure> digitMapTMP, Map<Long, LocationPatternStructure> emergencyDMMapTMP, Map<Long, ArrayList<Long>> emergencyLocationMapTMP) {
        for (Map.Entry<Long, LocationPatternStructure> mapEntry : digitMapTMP.entrySet()) {
            long id = mapEntry.getKey();
            LocationPatternStructure locationPatternStruct = mapEntry.getValue();
            long locationId = locationPatternStruct.getLocationId();
            if (!emergencyDMMapTMP.containsKey(id)) {
                emergencyDMMapTMP.put(id, locationPatternStruct);
            } else {
                log.warn((Object)"DigitMapDAO - duplicate id in emergencyDM Map");
            }
            if (!emergencyLocationMapTMP.containsKey(locationId)) {
                emergencyLocationMapTMP.put(locationId, new ArrayList());
            }
            emergencyLocationMapTMP.get(locationId).add(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void updateDAO(DAOTableEvent event) {
        boolean isFineEnabled = log.isFineEnabled();
        boolean isFinerEnabled = log.isFinerEnabled();
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        if (!this.getDependentTables().contains(tableName) || operation == null) {
            return;
        }
        LocationPatternStructure locationPatternStructOld = null;
        long id = event.getKey();
        if (isFineEnabled) {
            log.fine((Object)(DigitMapDAO.class.getSimpleName() + ".updateDAO: " + (Object)((Object)operation) + " " + tableName + " " + id));
        }
        boolean locked = false;
        try {
            Object[] params;
            this.lock.acquireWriteLock();
            locked = true;
            locationPatternStructOld = this.emergencyDMMap.remove(id);
            if (locationPatternStructOld == null && operation == DAOReplicationEvent.OperationType.DELETE) {
                log.warn((Object)("emergencyDMMap was null for " + (Object)((Object)operation) + " operation; we are probably out of sync"));
            }
            Long locationIDToUpdate = null;
            ArrayList<Long> Ids = null;
            block5: for (Long locationId : this.emergencyLocationMap.keySet()) {
                if (locationIDToUpdate != null) break;
                Ids = this.emergencyLocationMap.get(locationId);
                for (Long perLocationId : Ids) {
                    if (perLocationId != id) continue;
                    locationIDToUpdate = locationId;
                    continue block5;
                }
            }
            if (locationIDToUpdate != null) {
                this.emergencyLocationMap.remove(locationIDToUpdate);
                if (Ids.size() > 1) {
                    Ids.remove(id);
                    this.emergencyLocationMap.put(locationIDToUpdate, Ids);
                }
            }
            LocationPatternStructure locationPatternStruct = null;
            if ((operation == DAOReplicationEvent.OperationType.UPDATE || operation == DAOReplicationEvent.OperationType.INSERT) && (locationPatternStruct = (LocationPatternStructure)this.dataSource.executeQuery(queryDM, params = new Object[]{id}, DigitMapDAO.getDigitMapMapper())) != null) {
                if (isFinerEnabled) {
                    log.finer((Object)("Retrieved  digit pattern " + locationPatternStruct.getDigitPattern() + " and " + locationPatternStruct.getLocationId() + " for id " + id));
                }
                Long locationId = locationPatternStruct.getLocationId();
                String digitsPattern = locationPatternStruct.getDigitPattern();
                if (digitsPattern != null) {
                    this.emergencyDMMap.put(id, locationPatternStruct);
                }
                if (locationId != null) {
                    Ids = this.emergencyLocationMap.get(locationId);
                    if (Ids == null) {
                        Ids = new ArrayList();
                    } else {
                        this.emergencyLocationMap.remove(locationId);
                    }
                    Ids.add(id);
                    this.emergencyLocationMap.put(locationId, Ids);
                }
            }
            if (this.isReloadRequired(operation, locationPatternStructOld, locationPatternStruct)) {
                this.updateListeners(locationPatternStructOld, locationPatternStruct);
            }
        }
        catch (DMException e) {
            if (locked) {
                this.lock.releaseWriteLock();
                locked = false;
            }
            log.error((Object)("Error updating " + DigitMapDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                log.finer((Object)"Update NOT successful.");
                return;
            }
        }
        finally {
            if (locked) {
                this.lock.releaseWriteLock();
            }
        }
        if (isFineEnabled) {
            log.fine((Object)(DigitMapDAO.class.getSimpleName() + " update successful"));
        }
    }

    private boolean isReloadRequired(DAOReplicationEvent.OperationType operation, LocationPatternStructure oldObj, LocationPatternStructure newObj) {
        String fcn_name = "isReloadRequired";
        boolean isFinerEnabled = log.isFinerEnabled();
        if (isFinerEnabled) {
            log.finer((Object)("isReloadRequired" + (Object)((Object)operation) + " oldObj=[" + oldObj + "], newObj=[" + newObj + "]"));
        }
        boolean isReloadRequired = false;
        switch (operation) {
            case INSERT: {
                isReloadRequired = newObj != null;
                break;
            }
            case UPDATE: {
                isReloadRequired = newObj != null && oldObj == null || newObj == null && oldObj != null;
                break;
            }
            case DELETE: {
                boolean bl = isReloadRequired = oldObj != null;
            }
        }
        if (isFinerEnabled) {
            log.finer((Object)("isReloadRequired: exit, isReloadRequired=" + isReloadRequired));
        }
        return isReloadRequired;
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("digitmap");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LocationPatternStructure> getDigitMaps() {
        ArrayList<LocationPatternStructure> dmList = new ArrayList<LocationPatternStructure>();
        try {
            ArrayList<LocationPatternStructure> dmListCopy;
            this.lock.acquireReadLock();
            for (Long id : this.emergencyDMMap.keySet()) {
                dmList.add(this.emergencyDMMap.get(id));
            }
            ArrayList<LocationPatternStructure> arrayList = dmListCopy = this.makeCopyOfList(dmList);
            return arrayList;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the list of emergency numbers associated with the given location (routingOriginationId).")
    public ArrayList<LocationPatternStructure> getDigitMaps(Long routingOriginationId) {
        if (routingOriginationId != null) {
            ArrayList<LocationPatternStructure> dmLocationList = new ArrayList<LocationPatternStructure>();
            try {
                this.lock.acquireReadLock();
                ArrayList<Long> idsPerLocationList = this.emergencyLocationMap.get(routingOriginationId);
                if (idsPerLocationList != null && !idsPerLocationList.isEmpty()) {
                    ArrayList<LocationPatternStructure> dmListCopy;
                    for (Long id : idsPerLocationList) {
                        LocationPatternStructure emergencyDigitPattern = this.emergencyDMMap.get(id);
                        if (emergencyDigitPattern != null) {
                            dmLocationList.add(emergencyDigitPattern);
                            continue;
                        }
                        log.error((Object)("Error getting the corresponding emergency dial pattern for id=" + id + " Routing origination ID = " + routingOriginationId));
                    }
                    ArrayList<LocationPatternStructure> arrayList = dmListCopy = this.makeCopyOfList(dmLocationList);
                    return arrayList;
                }
            }
            finally {
                this.lock.releaseReadLock();
            }
        }
        return null;
    }

    public ArrayList<LocationPatternStructure> getGeneralLocationDigitMaps() {
        ArrayList<LocationPatternStructure> lpsList = this.getDigitMaps(Location_ALL);
        ArrayList<LocationPatternStructure> lpsListCopy = this.makeCopyOfList(lpsList);
        return lpsListCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(description="Get the contents of all internal storage related to IPTDigitMap.  This method exists for debugging the IptDigitMapDAO.")
    public StringBuffer getIptDigitMapData() {
        StringBuffer retData = new StringBuffer();
        try {
            this.lock.acquireReadLock();
            retData.append("emergencyDMMap (digitMap ID to digit pattern string, " + this.emergencyDMMap.size() + " entries\n");
            for (Map.Entry<Long, LocationPatternStructure> entry : this.emergencyDMMap.entrySet()) {
                retData.append(entry + "\n");
            }
            retData.append("\nemergencyLocationMap (routingOriginationId to list of ArrayList of digit map ids, " + this.emergencyLocationMap.size() + " entries\n");
            for (Map.Entry<Long, Object> entry : this.emergencyLocationMap.entrySet()) {
                retData.append("routingOriginationId " + entry.getKey() + ":\n");
                for (Long digits : (ArrayList)entry.getValue()) {
                    retData.append(digits.toString() + "\n");
                }
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return retData;
    }

    private ArrayList<LocationPatternStructure> makeCopyOfList(ArrayList<LocationPatternStructure> origList) {
        if (origList == null || origList.isEmpty()) {
            return null;
        }
        ArrayList<LocationPatternStructure> newList = new ArrayList<LocationPatternStructure>();
        for (LocationPatternStructure lps : origList) {
            LocationPatternStructure lpsCopy = new LocationPatternStructure(lps);
            newList.add(lpsCopy);
        }
        return newList;
    }
}

