/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.OldNewDataDiffs;
import com.avaya.asm.datamgr.dao.AsmInstanceDAO;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.UserCommunityDAO;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.LocalAsmCommProfile;
import com.avaya.asm.datamgr.objectapi.LocalObject;
import com.avaya.asm.datamgr.objectapi.UserCommunityAssign;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LocalAsmCommProfileDAO
extends IsDeletedHandler {
    private final Logger log = AsmLogger.getLogger(LocalAsmCommProfileDAO.class);
    protected Collection<Long> mainCollection = new ArrayList<Long>();
    static boolean isBranch = DMUtilities.isBranch();
    private static String getLocalAsmCommProfileIDs_select = "SELECT asm.id FROM asmcommprofile asm, cscommprofile cs, cscommprofileset set, ";
    private static String getLocalAsmCommProfileIDs_SM = getLocalAsmCommProfileIDs_select + "asmusercommunityassign uca WHERE asm.id = cs.id AND cs.cscommprofilesetid = set.id AND set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ") AND uca.asmusercommunity_id = asm.usercommunity_id AND uca.asminstance_id = ?";
    private static String getLocalAsmCommProfileIDs_BSM = getLocalAsmCommProfileIDs_select + "asminstance ai WHERE asm.id = cs.id AND cs.cscommprofilesetid = set.id AND set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ") AND asm.survivability_server_id = ai.sipentity_id AND ai.id=?";
    public static final String getLocalAsmCommProfileIDs = isBranch ? getLocalAsmCommProfileIDs_BSM : getLocalAsmCommProfileIDs_SM;
    protected static String isLocal = getLocalAsmCommProfileIDs + " AND asm.id = ?";
    private static String getIdsByUserId_base = "SELECT u.isdeleted, asm.id FROM csuser u, cscommprofileset set, cscommprofile cs, asmcommprofile asm, ";
    private static String getIdsByUserId_SM = getIdsByUserId_base + "asmusercommunityassign uca WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND asm.id = cs.id AND uca.asmusercommunity_id = asm.usercommunity_id AND uca.asminstance_id = ? AND u.id = ?";
    private static String getIdsByUserId_BSM = getIdsByUserId_base + " asminstance ai WHERE set.csuserid = u.id AND cs.cscommprofilesetid = set.id AND asm.id = cs.id AND asm.survivability_server_id = ai.sipentity_id AND ai.id=? AND u.id = ?";
    protected static final String getCommunityCount = "SELECT count(*) FROM asmcommprofile WHERE usercommunity_id = ?";
    protected static final ResultSetMapper collectionMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            ArrayList<Long> list = new ArrayList<Long>();
            while (rs.next()) {
                list.add(rs.getLong("id"));
            }
            return list;
        }
    };
    protected static final ResultSetMapper booleanMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            return rs.next();
        }
    };
    protected static final ResultSetMapper communityMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return null;
        }
    };

    public LocalAsmCommProfileDAO() {
        super(true);
        this.getIdsByUserId = isBranch ? getIdsByUserId_BSM : getIdsByUserId_SM;
    }

    protected LocalObject construct(long id) {
        return new LocalAsmCommProfile(id);
    }

    protected Object[] getAllParams() {
        Long myAsmInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        if (myAsmInstanceId == null) {
            myAsmInstanceId = 0L;
        }
        return new Object[]{myAsmInstanceId};
    }

    protected Object[] getSingleParams(Long id) {
        Long myAsmInstanceId = this.getAsmInstanceDAO().getMyInstanceId();
        if (myAsmInstanceId == null) {
            myAsmInstanceId = 0L;
        }
        return new Object[]{myAsmInstanceId, id};
    }

    protected AsmInstanceDAO getAsmInstanceDAO() {
        return (AsmInstanceDAO)this.getDataMgr(AsmInstanceDAO.class);
    }

    protected UserCommunityDAO getUserCommunityDAO() {
        return (UserCommunityDAO)this.getDataMgr(UserCommunityDAO.class);
    }

    @Override
    protected Object getMainCollection() {
        return this.mainCollection;
    }

    @Override
    public void init() {
        Collection mainCollectionTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        this.getAsmInstanceDAO();
        if (!DMUtilities.isBranch()) {
            this.getUserCommunityDAO();
        }
        try {
            mainCollectionTMP = (Collection)this.dataSource.executeQuery(getLocalAsmCommProfileIDs, this.getAllParams(), collectionMapper);
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.mainCollection = mainCollectionTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    protected List<OldNewDataDiffs> compareOldNewData(Object oldData, Object newData) {
        ArrayList<OldNewDataDiffs> diffList = new ArrayList<OldNewDataDiffs>();
        Collection oldCollection = (Collection)oldData;
        Collection newCollection = (Collection)newData;
        for (Long id : oldCollection) {
            if (newCollection.contains(id)) continue;
            diffList.add(new OldNewDataDiffs(this.construct(id), null));
        }
        for (Long id : newCollection) {
            if (oldCollection.contains(id)) continue;
            diffList.add(new OldNewDataDiffs(null, this.construct(id)));
        }
        return diffList;
    }

    @Override
    public String getMainTable() {
        return "asmcommprofile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        boolean lockHeld = false;
        ArrayList<Object> oldIds = new ArrayList<Object>();
        ArrayList<Object> newIds = new ArrayList<Object>();
        try {
            if ("csuser".equals(tableName)) {
                Map userMap;
                if (operation == DAOReplicationEvent.OperationType.UPDATE && !(userMap = (Map)this.dataSource.executeQuery(this.getIdsByUserId, this.getSingleParams(id), userMapper)).isEmpty()) {
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)(this.logTag(operation, tableName, id) + "AsmCommProfile deleted state update: " + userMap));
                    }
                    boolean deleted = (Boolean)userMap.values().iterator().next();
                    this.lock.acquireWriteLock();
                    lockHeld = true;
                    if (deleted) {
                        for (Long key : userMap.keySet()) {
                            if (!this.mainCollection.remove(key)) continue;
                            oldIds.add(this.construct(key));
                            newIds.add(null);
                        }
                    } else {
                        for (Long key : userMap.keySet()) {
                            if (this.mainCollection.contains(key)) continue;
                            oldIds.add(null);
                            newIds.add(this.construct(key));
                            this.mainCollection.add(key);
                        }
                    }
                }
            } else if ("asmcommprofile".equals(tableName)) {
                boolean local = (Boolean)this.dataSource.executeQuery(isLocal, this.getSingleParams(id), booleanMapper);
                this.lock.acquireWriteLock();
                lockHeld = true;
                if (local) {
                    if (!this.mainCollection.contains(id)) {
                        oldIds.add(null);
                        newIds.add(this.construct(id));
                        this.mainCollection.add(id);
                    }
                } else if (this.mainCollection.remove(id)) {
                    oldIds.add(this.construct(id));
                    newIds.add(null);
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (!oldIds.isEmpty()) {
            this.updateListeners(oldIds, newIds);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    @Override
    public void objectChanged(Object oldObject, Object newObject) {
        if (this.log.isFinestEnabled()) {
            this.log.finest((Object)("objectChanged: " + oldObject + " became " + newObject));
        }
        if (oldObject instanceof AsmInstance || newObject instanceof AsmInstance) {
            AsmInstance curInstance = this.getAsmInstanceDAO().getMyAsmInstance();
            if (curInstance == null) {
                return;
            }
            AsmInstance newInstance = (AsmInstance)newObject;
            if (curInstance == newInstance) {
                AsmInstance oldInstance = (AsmInstance)oldObject;
                if (oldInstance != null) {
                    if (this.log.isFinestEnabled()) {
                        this.log.finest((Object)("Doing nothing as result of " + AsmInstance.class.getSimpleName() + " change."));
                    }
                    return;
                }
                this.log.fine((Object)"Reinitializing because we have a new AsmInstance identity");
                this.reinit();
            } else if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("Doing nothing as result of " + AsmInstance.class.getSimpleName() + " change."));
            }
        } else if (oldObject instanceof UserCommunityAssign || newObject instanceof UserCommunityAssign) {
            AsmInstance myInstance;
            Integer count = null;
            Object[] params = null;
            try {
                params = oldObject != null ? new Object[]{((UserCommunityAssign)oldObject).getAsmusercommunity_id()} : new Object[]{((UserCommunityAssign)newObject).getAsmusercommunity_id()};
                count = (Integer)this.dataSource.executeQuery(getCommunityCount, params, communityMapper);
            }
            catch (Exception e) {
                this.log.warn((Object)(e + " - while querying for number of AsmCommProfiles in community " + Arrays.toString(params)));
            }
            if (count != null && count > 0 && (myInstance = this.getAsmInstanceDAO().getMyAsmInstance()) != null) {
                UserCommunityAssign oldAssign = (UserCommunityAssign)oldObject;
                UserCommunityAssign newAssign = (UserCommunityAssign)newObject;
                if (oldAssign != null && myInstance.getId() == oldAssign.getAsmInstance_id() || newAssign != null && myInstance.getId() == newAssign.getAsmInstance_id()) {
                    this.log.error((Object)"A User Community that we are a member of was modified even though there are AsmCommProfiles assigned to it. This should never happen! Reinitializing, since we can't handle this in-line.");
                    this.reinit();
                    return;
                }
            }
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("Doing nothing as result of " + UserCommunityAssign.class.getSimpleName() + " change."));
            }
        } else {
            this.log.warn((Object)("Received unexpected change alert for " + oldObject + " changing to " + newObject + "; re-initializing"));
            this.reinit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(long id) {
        this.lock.acquireReadLock();
        try {
            boolean bl = this.mainCollection.contains(id);
            return bl;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Print a list of all local AsmCommProfile IDs.")
    public Collection<Long> getLocalAsmCommProfileIDs() {
        this.lock.acquireReadLock();
        try {
            Collection<Long> collection = Collections.unmodifiableCollection(this.mainCollection);
            return collection;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public static void main(String[] args) {
        LocalAsmCommProfileDAO dao = new LocalAsmCommProfileDAO();
        System.out.println("getLocalAsmCommProfileIDs=" + getLocalAsmCommProfileIDs);
        System.out.println("isLocal=" + isLocal);
        System.out.println("getIdsByUserId=" + dao.getIdsByUserId);
    }
}

