/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.objectapi.IPAddress;
import com.avaya.asm.datamgr.objectapi.LocationPattern;
import com.avaya.asm.datamgr.objectapi.LocationPatternTree;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LocationPatternDAO
extends DataAccessObject {
    protected final Logger log = AsmLogger.getLogger(LocationPatternDAO.class);
    protected Map<Long, LocationPattern> patternMap = new HashMap<Long, LocationPattern>();
    protected LocationPatternTree ipv4PatternTree = new LocationPatternTree();
    protected LocationPatternTree ipv6PatternTree = new LocationPatternTree();
    protected Set<LocationPattern> ipv4RangeSet = new HashSet<LocationPattern>();
    protected Set<LocationPattern> ipv6RangeSet = new HashSet<LocationPattern>();
    protected List<LocationPattern> ipv4MatchList = new ArrayList<LocationPattern>();
    protected List<LocationPattern> ipv6MatchList = new ArrayList<LocationPattern>();
    protected static final String getLocationPatterns = "SELECT id, ipaddresspattern, routingorigination_id FROM routingoriginationpattern";
    protected static final String getLocationPattern = "SELECT id, ipaddresspattern, routingorigination_id FROM routingoriginationpattern WHERE id = ?";
    protected static final ResultSetMapper patternMapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, LocationPattern> patternMap = new HashMap<Long, LocationPattern>();
            while (rs.next()) {
                patternMap.put(rs.getLong("id"), new LocationPattern(rs.getString("ipaddresspattern"), rs.getLong("routingorigination_id")));
            }
            return patternMap;
        }
    };

    public LocationPatternDAO() {
        super(true);
    }

    @Override
    protected Object getMainCollection() {
        this.lock.acquireReadLock();
        try {
            Map<Long, LocationPattern> map = this.patternMap;
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        Map patternMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + LocationPatternDAO.class.getSimpleName()));
        }
        HashSet<LocationPattern> ipv4RangeSetTMP = new HashSet<LocationPattern>();
        HashSet<LocationPattern> ipv6RangeSetTMP = new HashSet<LocationPattern>();
        ArrayList<LocationPattern> ipv4MaskListTMP = new ArrayList<LocationPattern>();
        ArrayList<LocationPattern> ipv6MaskListTMP = new ArrayList<LocationPattern>();
        LocationPatternTree ipv4PatternTreeTMP = new LocationPatternTree();
        LocationPatternTree ipv6PatternTreeTMP = new LocationPatternTree();
        try {
            Object[] params = new Object[]{};
            patternMapTMP = (Map)this.dataSource.executeQuery(getLocationPatterns, params, patternMapper);
            for (LocationPattern pattern : patternMapTMP.values()) {
                if (IPAddress.getAddressFamily(pattern.getIpAddressPattern()) == IPAddress.IPAddressFamily.IPV6) {
                    this.insertPattern(pattern, ipv6RangeSetTMP, ipv6MaskListTMP, ipv6PatternTreeTMP);
                    continue;
                }
                this.insertPattern(pattern, ipv4RangeSetTMP, ipv4MaskListTMP, ipv4PatternTreeTMP);
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.patternMap = patternMapTMP;
                this.ipv4RangeSet = ipv4RangeSetTMP;
                this.ipv4MatchList = ipv4MaskListTMP;
                this.ipv4PatternTree = ipv4PatternTreeTMP;
                this.ipv6RangeSet = ipv6RangeSetTMP;
                this.ipv6MatchList = ipv6MaskListTMP;
                this.ipv6PatternTree = ipv6PatternTreeTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("routingoriginationpattern");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        Long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        LocationPattern oldPattern = null;
        LocationPattern newPattern = null;
        boolean lockHeld = false;
        try {
            Map map = null;
            if (operation != DAOReplicationEvent.OperationType.DELETE) {
                Object[] params = new Object[]{id};
                map = (Map)this.dataSource.executeQuery(getLocationPattern, params, patternMapper);
            }
            this.lock.acquireWriteLock();
            lockHeld = true;
            oldPattern = this.patternMap.remove(id);
            if (oldPattern != null) {
                if (IPAddress.getAddressFamily(oldPattern.getIpAddressPattern()) == IPAddress.IPAddressFamily.IPV6) {
                    this.deletePattern(oldPattern, this.ipv6RangeSet, this.ipv6MatchList, this.ipv6PatternTree);
                } else {
                    this.deletePattern(oldPattern, this.ipv4RangeSet, this.ipv4MatchList, this.ipv4PatternTree);
                }
            }
            if (map != null && (newPattern = (LocationPattern)map.get(id)) != null) {
                if (this.log.isFinerEnabled()) {
                    this.log.finer((Object)(this.logTag(operation, tableName, id) + "Retrieved new LocationPattern " + newPattern));
                }
                if (IPAddress.getAddressFamily(newPattern.getIpAddressPattern()) == IPAddress.IPAddressFamily.IPV6) {
                    this.insertPattern(newPattern, this.ipv6RangeSet, this.ipv6MatchList, this.ipv6PatternTree);
                } else {
                    this.insertPattern(newPattern, this.ipv4RangeSet, this.ipv4MatchList, this.ipv4PatternTree);
                }
                this.patternMap.put(id, newPattern);
            }
        }
        catch (DMException e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + LocationPatternDAO.class.getSimpleName() + " object; re-initializing"), (Throwable)e);
            newPattern = null;
            oldPattern = null;
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Update NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
        }
        if (oldPattern != null || newPattern != null) {
            this.updateListeners(oldPattern, newPattern);
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "Update successful"));
        }
    }

    protected void insertPattern(LocationPattern pattern, Set<LocationPattern> rangeSet, List<LocationPattern> maskList, LocationPatternTree tree) {
        if (pattern.isRange()) {
            rangeSet.add(pattern);
        } else if (pattern.isMask()) {
            int index = 0;
            for (LocationPattern rop : maskList) {
                if (rop.getMaskLength() <= pattern.getMaskLength()) break;
                ++index;
            }
            maskList.add(index, pattern);
        } else {
            tree.insert(this.expandAddressPattern(pattern.getIpAddressPattern()), pattern.getLocationId());
        }
    }

    protected void deletePattern(LocationPattern pattern, Set<LocationPattern> rangeSet, List<LocationPattern> maskList, LocationPatternTree tree) {
        if (pattern.isRange()) {
            rangeSet.remove(pattern);
        } else if (pattern.isMask()) {
            maskList.remove(pattern);
        } else {
            tree.delete(this.expandAddressPattern(pattern.getIpAddressPattern()));
        }
    }

    protected String expandAddressPattern(String address) {
        IPAddress.IPAddressFamily type = IPAddress.getAddressFamily(address);
        if (type != IPAddress.IPAddressFamily.IPV6) {
            return address;
        }
        StringBuilder buf = new StringBuilder();
        String[] groups = address.split(":", -1);
        int nGroups = 0;
        int emptyGroups = 0;
        int emptyCount = 0;
        for (String group : groups) {
            if (!group.isEmpty()) continue;
            ++emptyCount;
        }
        for (String group : groups) {
            if (group.isEmpty()) {
                if (emptyGroups++ != 0) continue;
                for (int i = 0; i < 8 - groups.length + emptyCount; ++i) {
                    if (nGroups++ != 0) {
                        buf.append(":");
                    }
                    buf.append("0");
                }
                continue;
            }
            if (nGroups++ != 0) {
                buf.append(":");
            }
            buf.append(this.formatGroup(group));
        }
        return buf.toString();
    }

    protected String formatGroup(String group) {
        int i;
        int len = group.length();
        for (i = 0; i < len && group.charAt(i) == '0'; ++i) {
        }
        if (i >= len) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        for (int j = i; j < len; ++j) {
            char c = group.charAt(j);
            if (c >= 'A' && c <= 'F') {
                c = (char)(c + 32);
            }
            buf.append(c);
        }
        return buf.toString();
    }

    public Long getMatchingLocation(String address) {
        try {
            return this.getMatchingLocation(IPAddress.parseIPAddr(address));
        }
        catch (ParseException e) {
            this.log.warn((Object)("getMatchingLocation: bad address " + address));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getMatchingLocation(IPAddress address) {
        this.lock.acquireReadLock();
        try {
            List<LocationPattern> matchList;
            Set<LocationPattern> rangeSet;
            LocationPatternTree patternTree;
            if (address.getAddressFamily() == IPAddress.IPAddressFamily.IPV6) {
                patternTree = this.ipv6PatternTree;
                rangeSet = this.ipv6RangeSet;
                matchList = this.ipv6MatchList;
            } else {
                patternTree = this.ipv4PatternTree;
                rangeSet = this.ipv4RangeSet;
                matchList = this.ipv4MatchList;
            }
            LocationPatternTree tree = patternTree.matchPattern(address);
            if (tree != null) {
                Long l = tree.getLocationId();
                return l;
            }
            for (LocationPattern pattern : rangeSet) {
                if (!pattern.matchesRange(address)) continue;
                Long l = pattern.getLocationId();
                return l;
            }
            for (LocationPattern pattern : matchList) {
                if (!pattern.matchesMask(address)) continue;
                Long l = pattern.getLocationId();
                return l;
            }
            Iterator<LocationPattern> iterator = null;
            return iterator;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SMConsole(parameterNames={"id"}, description="Get a pattern array for this Location ID.")
    public String[] getLocationPatterns(Long id) {
        this.lock.acquireReadLock();
        try {
            ArrayList<String> locationPatterns = new ArrayList<String>();
            for (LocationPattern pattern : this.patternMap.values()) {
                if (pattern.getLocationId() != id.longValue()) continue;
                locationPatterns.add(pattern.getIpAddressPattern());
            }
            String[] stringArray = locationPatterns.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    @SMConsole(description="Get all provisioned LocationPatterns.")
    public String getLocationPatterns() {
        this.lock.acquireReadLock();
        try {
            String string = "patterns: " + this.patternMap + "\nIPV4 ranges: " + this.ipv4RangeSet + "\nIPV4 masks: " + this.ipv4MatchList + "\nIPV4 tree: " + this.ipv4PatternTree.print() + "\nIPV6 ranges: " + this.ipv6RangeSet + "\nIPV6 masks: " + this.ipv6MatchList + "\nIPV6 tree: " + this.ipv6PatternTree.print();
            return string;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }
}

