/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao;

import com.avaya.asm.alarming.GenericAlarmHandler;
import com.avaya.asm.core.AsmCommon;
import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.ConsumesLoadRules;
import com.avaya.asm.core.SMConsole;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.asm.datamgr.DataMgr;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.IsDeletedHandler;
import com.avaya.asm.datamgr.dao.jdbc.ResultSetMapper;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOTableEvent;
import com.avaya.asm.datamgr.helpers.FlexCache;
import com.avaya.asm.datamgr.loadrulekeys.CacheSize;
import com.avaya.asm.datamgr.loadrules.LoadRule;
import com.avaya.common.logging.client.Logger;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ConsumesLoadRules(key={CacheSize.class})
public class UserSetDAO
extends DataAccessObject {
    private final Logger log = AsmLogger.getLogger(UserSetDAO.class);
    protected final int queryFetchSize = 10000;
    private int capacity = 1;
    private Map<Long, Long> setUserMap = new HashMap<Long, Long>();
    private FlexCache<Long, Collection<Long>> userSetMap = new FlexCache();
    public static final String getUserSets = "SELECT set.id AS setid, set.csuserid AS id FROM cscommprofileset set WHERE set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ")";
    public static final String getSingleUserSetsBase = "SELECT set.id AS setid, u.id FROM cscommprofileset set JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false";
    public static final String getUserSetBySetId = "SELECT set.id AS setid, u.id FROM cscommprofileset set JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND set.id = ?";
    public static final String getUserSetByUserId = "SELECT set.id AS setid, u.id FROM cscommprofileset set JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND set.csuserid = ?";
    public static final String getUserSetsBySurvivableId = "SELECT set.id AS setid, set.csuserid AS id FROM cscommprofileset set JOIN cscommprofile cs ON set.id=cs.cscommprofilesetid JOIN asmcommprofile asm ON cs.id=asm.id JOIN asminstance ai ON ai.sipentity_id = asm.survivability_server_id WHERE set.csuserid NOT IN (" + IsDeletedHandler.isDeletedCsUserId + ") AND ai.id = ?";
    protected static final ResultSetMapper mapper = new ResultSetMapper(){

        @Override
        public Object mapResults(ResultSet rs) throws SQLException {
            HashMap<Long, ArrayList<Long>> map = new HashMap<Long, ArrayList<Long>>();
            while (rs.next()) {
                long userId = rs.getLong("id");
                ArrayList<Long> collection = (ArrayList<Long>)map.get(userId);
                if (collection == null) {
                    collection = new ArrayList<Long>();
                    map.put(userId, collection);
                }
                collection.add(rs.getLong("setid"));
            }
            return map;
        }
    };

    public UserSetDAO() {
        super(false);
    }

    protected void setCapacity(int capacity) {
        if (!AsmCommon.jUnitEnvironment) {
            throw new IllegalStateException("Attempt to directly set Load Rule!");
        }
        this.capacity = capacity;
    }

    protected int getCapacity() {
        return this.capacity;
    }

    @Override
    protected void setLoadRules(Collection<LoadRule> appLoadRules) {
        super.setLoadRules(appLoadRules);
        boolean reinit = false;
        int bestCacheValue = 1;
        block0: for (Map.Entry entry : this.loadRules.entrySet()) {
            if ("cachesize".equals(((String)entry.getKey()).toLowerCase())) {
                for (String value : (Set)entry.getValue()) {
                    int cap = Integer.parseInt(value);
                    if (cap <= 0) {
                        bestCacheValue = -1;
                        continue block0;
                    }
                    if (bestCacheValue == -1 || cap <= bestCacheValue) continue;
                    bestCacheValue = cap;
                }
                continue;
            }
            this.log.warn((Object)("Unrecognized Load Rule detected; ignoring: " + (String)entry.getKey()));
        }
        if (bestCacheValue != this.capacity) {
            if (this.log.isFineEnabled()) {
                this.log.fine((Object)("Setting FlexCache capacity to " + bestCacheValue));
            }
            this.capacity = bestCacheValue;
            reinit = true;
        }
        if (reinit && !this.uninitialized()) {
            this.reinit();
        }
    }

    @Override
    protected Object getMainCollection() {
        return this.userSetMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        FlexCache userSetMapTMP;
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)("Initializing " + this.getClass().getSimpleName()));
        }
        HashMap<Long, Long> setUserMapTMP = new HashMap<Long, Long>();
        try {
            Object[] params;
            HashMap queryResults = null;
            if (this.getCapacity() >= 0) {
                params = DMUtilities.getLocalAsmInstanceParams();
                if ((Long)params[0] != 0L) {
                    queryResults = (HashMap)this.dataSource.executeChunkedQuery(getUserSetsBySurvivableId, params, mapper, 10000);
                }
            } else {
                params = new Object[]{};
                queryResults = (HashMap)this.dataSource.executeChunkedQuery(getUserSets, params, mapper, 10000);
            }
            userSetMapTMP = new FlexCache(this.getCapacity(), queryResults, true);
            for (Map.Entry entry : userSetMapTMP.entrySet()) {
                for (Long setId : (Collection)entry.getValue()) {
                    setUserMapTMP.put(setId, (Long)entry.getKey());
                }
            }
            this.setStatus(DataMgr.Status.OKAY);
        }
        catch (DMException e) {
            this.setStatus(DataMgr.Status.FAIL);
            this.log.error((Object)("Error initializing " + this.getClass().getSimpleName()), (Throwable)e);
            GenericAlarmHandler.handleFailureEvent(this, e);
            return;
        }
        if (this.okay()) {
            try {
                this.lock.acquireWriteLock();
                this.setUserMap = setUserMapTMP;
                this.userSetMap = userSetMapTMP;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
    }

    @Override
    public List<String> getDependentTables() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("csuser");
        list.add("cscommprofileset");
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateDAO(DAOTableEvent event) {
        DAOReplicationEvent.OperationType operation = event.getOperation();
        String tableName = event.getTableName();
        long id = event.getKey();
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)this.logTag(operation, tableName, id));
        }
        Object[] params = new Object[]{id};
        boolean lockHeld = false;
        try {
            if ("csuser".equals(tableName)) {
                Map map = null;
                if (this.getCapacity() <= 0) {
                    map = (Map)this.dataSource.executeQuery(getUserSetByUserId, params, mapper);
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                Collection<Long> setIds = this.userSetMap.remove(id);
                if (setIds != null) {
                    for (Long l : setIds) {
                        this.setUserMap.remove(l);
                    }
                }
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        this.userSetMap.put((Long)entry.getKey(), (Collection<Long>)entry.getValue());
                        for (Long setId : (Collection)entry.getValue()) {
                            this.setUserMap.put(setId, id);
                        }
                    }
                }
            } else if ("cscommprofileset".equals(tableName)) {
                Map map = null;
                if (this.getCapacity() <= 0) {
                    map = (Map)this.dataSource.executeQuery(getUserSetBySetId, params, mapper);
                }
                this.lock.acquireWriteLock();
                lockHeld = true;
                Long userId = this.setUserMap.remove(id);
                if (userId != null) {
                    this.userSetMap.get(userId).remove(id);
                    if (this.userSetMap.get(userId).isEmpty()) {
                        this.userSetMap.remove(userId);
                    }
                }
                if (map != null) {
                    for (Map.Entry entry : map.entrySet()) {
                        if (!this.userSetMap.containsKey(entry.getKey())) {
                            this.userSetMap.put((Long)entry.getKey(), new ArrayList());
                        }
                        for (Long setId : (Collection)entry.getValue()) {
                            this.setUserMap.put(setId, (Long)entry.getKey());
                            if (this.userSetMap.get(entry.getKey()).contains(setId)) continue;
                            this.userSetMap.get(entry.getKey()).add(setId);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            if (lockHeld) {
                this.lock.releaseWriteLock();
                lockHeld = false;
            }
            this.log.error((Object)(this.logTag(operation, tableName, id) + "Error updating " + this.getClass().getSimpleName() + " object; re-initializing"), (Throwable)e);
            this.reinit();
            if (!this.okay()) {
                this.log.error((Object)(this.logTag(operation, tableName, id) + "Reinit NOT successful!"));
                return;
            }
        }
        finally {
            if (lockHeld) {
                this.lock.releaseWriteLock();
            }
        }
        if (this.log.isFineEnabled()) {
            this.log.fine((Object)(this.logTag(operation, tableName, id) + "update successful"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getUserId(Long setId) {
        if (setId == null) {
            return null;
        }
        Long retval = null;
        this.lock.acquireReadLock();
        try {
            retval = this.setUserMap.get(setId);
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (retval != null || this.getCapacity() < 0) {
            return retval;
        }
        Map map = null;
        try {
            map = (Map)this.dataSource.executeQuery(getUserSetBySetId, new Object[]{setId}, mapper);
        }
        catch (DMException e) {
            this.log.error((Object)("Error reading Database for " + setId), (Throwable)e);
        }
        if (map != null && !map.isEmpty()) {
            try {
                this.lock.acquireWriteLock();
                Set evictedEntries = null;
                for (Map.Entry entry : map.entrySet()) {
                    if (!this.userSetMap.containsKey(entry.getKey())) {
                        evictedEntries = this.userSetMap.putReportEviction((Long)entry.getKey(), new ArrayList());
                    }
                    this.setUserMap.put(setId, (Long)entry.getKey());
                    this.userSetMap.get(entry.getKey()).add(setId);
                }
                if (evictedEntries != null) {
                    for (FlexCache.EvictEntry evictEntry : evictedEntries) {
                        for (Long setId2 : (Collection)evictEntry.getValue()) {
                            this.setUserMap.remove(setId2);
                        }
                    }
                }
                retval = this.setUserMap.get(setId);
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Long> getSetIds(Long userId) {
        if (userId == null) {
            return null;
        }
        Collection<Long> retval = null;
        this.lock.acquireReadLock();
        try {
            retval = this.userSetMap.get(userId);
        }
        finally {
            this.lock.releaseReadLock();
        }
        if (retval != null || this.getCapacity() < 0) {
            return retval;
        }
        Map map = null;
        try {
            map = (Map)this.dataSource.executeQuery(getUserSetByUserId, new Object[]{userId}, mapper);
        }
        catch (DMException e) {
            this.log.error((Object)("Error reading Database for " + userId), (Throwable)e);
        }
        if (map != null && !map.isEmpty()) {
            try {
                this.lock.acquireWriteLock();
                Collection setIds = (Collection)map.values().iterator().next();
                for (Long setId : setIds) {
                    this.setUserMap.put(setId, userId);
                }
                Set<FlexCache.EvictEntry<Long, Collection<Long>>> evictedEntries = this.userSetMap.putReportEviction(userId, setIds);
                for (FlexCache.EvictEntry<Long, Collection<Long>> entry : evictedEntries) {
                    for (Long setId : entry.getValue()) {
                        this.setUserMap.remove(setId);
                    }
                }
                Collection collection = setIds;
                return collection;
            }
            finally {
                this.lock.releaseWriteLock();
            }
        }
        return retval;
    }

    @SMConsole(description="Print a map of CommProfileSet IDs to User IDs.")
    public Map<Long, Long> getSetUserMappings() {
        this.lock.acquireReadLock();
        try {
            Map<Long, Long> map = Collections.unmodifiableMap(this.setUserMap);
            return map;
        }
        finally {
            this.lock.releaseReadLock();
        }
    }

    public static void main(String[] args) {
        System.out.println("getUserSets=" + getUserSets);
        System.out.println("getUserSetBySetId=SELECT set.id AS setid, u.id FROM cscommprofileset set JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND set.id = ?");
        System.out.println("getUserSetByUserId=SELECT set.id AS setid, u.id FROM cscommprofileset set JOIN csuser u ON set.csuserid=u.id WHERE u.isdeleted=false AND set.csuserid = ?");
        System.out.println("getUserSetsBySurvivableId=" + getUserSetsBySurvivableId);
    }
}

