/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.branch;

import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.ConfFactoryDAO;
import com.avaya.asm.datamgr.dao.SIPEntityDAO;
import com.avaya.asm.datamgr.dao.branch.BranchFeatureServerDAO;
import com.avaya.asm.datamgr.dao.branch.BranchSIPEntityDAO;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.objectapi.ConfFactory;
import com.avaya.asm.datamgr.objectapi.SIPEntity;
import com.avaya.asm.datamgr.objectapi.TransportAddress;
import java.util.HashMap;
import java.util.Map;

public class BranchConfFactoryDAO
extends ConfFactoryDAO {
    protected static final String getBranchConfFactories = "SELECT id, uri, sip_entity_id, accepts_audio, accepts_video, accepts_text, match_type, if_no_sdp, asm_conf_factory_set_id,priority_order FROM asm_conf_factory WHERE (sip_entity_id=? OR sip_entity_id=?)";
    protected static final String getBranchConfFactory = "SELECT id, uri, sip_entity_id, accepts_audio, accepts_video, accepts_text, match_type, if_no_sdp, asm_conf_factory_set_id,priority_order FROM asm_conf_factory WHERE (sip_entity_id=? OR sip_entity_id=?) AND id=?";

    @Override
    protected Map<Long, ConfFactory> queryConfFactories() throws DMException {
        Long featureServerId = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getFeatureServerId();
        if (featureServerId == null) {
            return new HashMap<Long, ConfFactory>();
        }
        Long trunkGatewayId = ((BranchSIPEntityDAO)this.getDataMgr(SIPEntityDAO.class)).getTrunkGatewayId();
        if (trunkGatewayId == null) {
            trunkGatewayId = featureServerId;
        }
        Object[] params = new Object[]{featureServerId, trunkGatewayId};
        Map confFactoryMapTMP = (Map)this.dataSource.executeQuery(getBranchConfFactories, params, this.getConfFactoriesMapper());
        for (ConfFactory cf : confFactoryMapTMP.values()) {
            this.replaceHostUriWithLsp(cf, featureServerId);
        }
        return confFactoryMapTMP;
    }

    @Override
    protected ConfFactory queryConfFactory(Long id) throws DMException {
        Long featureServerId = ((BranchFeatureServerDAO)this.getDataMgr(BranchFeatureServerDAO.class)).getFeatureServerId();
        if (featureServerId == null) {
            return null;
        }
        Long trunkGatewayId = ((BranchSIPEntityDAO)this.getDataMgr(SIPEntityDAO.class)).getTrunkGatewayId();
        if (trunkGatewayId == null) {
            trunkGatewayId = featureServerId;
        }
        Object[] params = new Object[]{featureServerId, trunkGatewayId, id};
        ConfFactory new_cf = (ConfFactory)this.dataSource.executeQuery(getBranchConfFactory, params, this.getConfFactoryMapper());
        this.replaceHostUriWithLsp(new_cf, featureServerId);
        return new_cf;
    }

    protected void replaceHostUriWithLsp(ConfFactory new_cf, Long featureServerId) {
        if (new_cf == null) {
            return;
        }
        SIPEntity sipEntity = ((BranchSIPEntityDAO)this.getDataMgr(SIPEntityDAO.class)).getSIPEntity(featureServerId);
        String lspIpAddress = sipEntity.getFqdnoripaddr();
        String uri = new_cf.getUri();
        int beginIndex = uri.indexOf(64) + 1;
        int endIndex = uri.length();
        for (int idx = beginIndex; idx < endIndex; ++idx) {
            char c = uri.charAt(idx);
            if (c == '[') {
                if ((idx = uri.indexOf(93, idx)) >= 0) continue;
                return;
            }
            if (c != ':' && c != ';' && c != ',' && c != '?') continue;
            endIndex = idx;
            break;
        }
        StringBuffer uriBuf = new StringBuffer();
        uriBuf.append(uri.subSequence(0, beginIndex));
        uriBuf.append(new TransportAddress(lspIpAddress, -1));
        uriBuf.append(uri.substring(endIndex));
        new_cf.setUri(uriBuf.toString());
    }

    @Override
    protected void handleNullQuery(DAOReplicationEvent.OperationType operation) throws DMException {
    }

    @Override
    protected void handleNullOldCf(DAOReplicationEvent.OperationType operation) {
    }
}

