/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BasePreparedStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import java.util.ArrayList;
import java.util.List;

public class BatchStatementBuilder<E extends Enum<E>>
extends BasePreparedStatementBuilder<E> {
    private List<BasePreparedStatementBuilder.StatementArguments> argList = new ArrayList<BasePreparedStatementBuilder.StatementArguments>();
    private BatchStatement.Type batchStatementType = null;

    public BatchStatementBuilder(PreparedStatements<E> statements, UserStoreKeyspaceBuilder builder) {
        super(statements, builder);
    }

    public BatchStatementBuilder(PreparedStatements<E> statements, UserStoreKeyspaceBuilder builder, BatchStatement.Type bsType) {
        super(statements, builder);
        this.batchStatementType = bsType;
    }

    public void addToBatch(E type, Object ... args) {
        BasePreparedStatementBuilder.StatementArguments stArgs = new BasePreparedStatementBuilder.StatementArguments();
        stArgs.psType = type;
        stArgs.psArgs = args;
        this.argList.add(stArgs);
    }

    public E getType(int index) {
        this.checkIndex(index);
        return this.argList.get((int)index).psType;
    }

    public Object[] getArgs(int index) {
        this.checkIndex(index);
        return this.argList.get((int)index).psArgs;
    }

    public int numStatements() {
        return this.argList.size();
    }

    @Override
    public Statement getStatement() throws DMException {
        BatchStatement batch = null;
        batch = this.batchStatementType == null ? new BatchStatement() : new BatchStatement(this.batchStatementType);
        for (BasePreparedStatementBuilder.StatementArguments stArgs : this.argList) {
            PreparedStatement ps = this.statements.getPreparedStatement(stArgs.psType, this.builder);
            batch.add((Statement)ps.bind(stArgs.psArgs));
        }
        return batch;
    }

    private void checkIndex(int index) {
        if (index > this.argList.size()) {
            throw new IllegalArgumentException("index value " + index + " exceeds number of statements " + this.argList.size());
        }
    }
}

