/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.common.logging.client.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CQLFileHandler {
    private static final String SLASH_SLASH = "//";
    private static final String SEMICOLON = ";";
    private static final String SPACE = " ";
    private final Logger log = AsmLogger.getLogger(CQLFileHandler.class);
    private static String junitPath = null;

    public static void setjunitPath(String path) {
        junitPath = path;
    }

    public static CQLFileHandler getInstance() {
        return new CQLFileHandler();
    }

    private String removeComments(String line) {
        if (line.contains(SLASH_SLASH)) {
            return line.split(SLASH_SLASH)[0];
        }
        return line;
    }

    private BufferedReader createBufferedReader(String filePath) {
        FileReader fileReader;
        String fcn_name = "createBufferedReader";
        String fullPath = "/opt/Avaya/ustore/schema/" + filePath;
        if (junitPath != null) {
            fullPath = junitPath + fullPath;
        }
        try {
            File file = new File(fullPath);
            fileReader = new FileReader(file);
        }
        catch (FileNotFoundException e) {
            this.log.warn((Object)("createBufferedReader: could not open file '" + fullPath + "'"), (Throwable)e);
            return null;
        }
        return new BufferedReader(fileReader);
    }

    private String getCommandFromReader(BufferedReader in) {
        String fcn_name = "getCommandFromReader";
        StringBuilder command = new StringBuilder("");
        try {
            String line;
            while ((line = in.readLine()) != null) {
                String normalizedLine = this.removeComments(line).trim().replaceAll("\\s+", SPACE);
                command.append(normalizedLine);
                if (!line.endsWith(SEMICOLON)) continue;
                break;
            }
        }
        catch (IOException e) {
            this.log.warn((Object)"getCommandFromReader: could not read line", (Throwable)e);
            e.printStackTrace();
        }
        if (command.length() == 0) {
            return null;
        }
        return command.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readSchema(String filePath) {
        String fcn_name = "readSchema";
        ArrayList<String> allCommands = new ArrayList<String>();
        BufferedReader in = null;
        try {
            String command;
            in = this.createBufferedReader(filePath);
            if (in == null) {
                List<String> list = null;
                return list;
            }
            int queries = 0;
            while ((command = this.getCommandFromReader(in)) != null) {
                ++queries;
                allCommands.add(command);
                if (!this.log.isFinestEnabled()) continue;
                this.log.finest((Object)("readSchema: " + command));
            }
            if (this.log.isFinestEnabled()) {
                this.log.finest((Object)("readSchema: " + queries + " queries in " + filePath));
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                this.log.warn((Object)"readSchema: trouble closing buffered reader", (Throwable)e);
                return null;
            }
        }
        return allCommands;
    }
}

