/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.cassandra;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.CQLFileHandler;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.common.logging.client.Logger;
import java.util.Iterator;
import java.util.List;

public class ContactKeyspaceBuilder
extends UserStoreKeyspaceBuilder {
    private static List<String> contactCommands = null;
    private static List<String> smgrContactRefCommands = null;
    private final Logger log = AsmLogger.getLogger(ContactKeyspaceBuilder.class);

    public ContactKeyspaceBuilder(UserStoreKeyspace keyspace) {
        super(keyspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean createColumnFamilies(SessionDAO dao) throws DMException {
        if (contactCommands == null || smgrContactRefCommands == null) {
            Class<ContactKeyspaceBuilder> clazz = ContactKeyspaceBuilder.class;
            // MONITORENTER : com.avaya.asm.datamgr.dao.cassandra.ContactKeyspaceBuilder.class
            CQLFileHandler cqlFileHandler = CQLFileHandler.getInstance();
            if (contactCommands == null) {
                contactCommands = cqlFileHandler.readSchema("Contact.cql3");
                this.log.info((Object)"ContactKeyspaceBuilder: Read CONTACT CF schema file.");
            }
            if (smgrContactRefCommands == null) {
                smgrContactRefCommands = cqlFileHandler.readSchema("smgr_contact_ref.cql3");
                this.log.info((Object)"ContactKeyspaceBuilder: Read SMGR_CONTACT_REF CF schema file.");
            }
            // MONITOREXIT : clazz
        }
        if (contactCommands == null) {
            this.log.error((Object)"ContactKeyspaceBuilder: cached contact commands unexpectedly null");
            throw new DMException("ContactKeyspaceBuilder: cached contact commands unexpectedly null");
        }
        if (smgrContactRefCommands == null) {
            this.log.error((Object)"ContactKeyspaceBuilder: cached smgr contact commands unexpectedly null");
            throw new DMException("ContactKeyspaceBuilder: cached smgr contact commands unexpectedly null");
        }
        List<String> ksContactCommands = this.getContactCommands();
        for (String command : ksContactCommands) {
            dao.executeQuery(command);
        }
        List<String> ksSmgrContactRefCommands = this.getSmgrContactRefCommands();
        Iterator<String> iterator = ksSmgrContactRefCommands.iterator();
        while (iterator.hasNext()) {
            String command = iterator.next();
            dao.executeQuery(command);
        }
        return true;
    }

    public List<String> getContactCommands() throws DMException {
        return this.insertKeyspaceIntoCommand(contactCommands);
    }

    public List<String> getSmgrContactRefCommands() throws DMException {
        return this.insertKeyspaceIntoCommand(smgrContactRefCommands);
    }
}

