/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.replication;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.dao.DataAccessObject;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEvent;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationEventBucket;
import com.avaya.asm.datamgr.dao.replication.DAOReplicationQueue;
import com.avaya.common.logging.client.Logger;
import java.util.HashMap;

public class DAOReplicationQueueServicer
extends Thread {
    private static final Logger log = AsmLogger.getLogger(DAOReplicationQueueServicer.class);
    private boolean canRun;
    private DAOReplicationQueue eventQueue;
    private DAOReplicationEventBucket bucket;
    private HashMap<String, Integer> eventCount;
    public int count = 0;

    public DAOReplicationQueueServicer(DAOReplicationQueue queue) {
        super.setDaemon(true);
        super.setName("DAOReplicationQueueServicer");
        this.eventQueue = queue;
        this.canRun = true;
        this.bucket = new DAOReplicationEventBucket();
        this.eventCount = new HashMap();
    }

    public DAOReplicationQueueServicer() {
        this.canRun = true;
        this.eventCount = new HashMap();
    }

    public void destroy() {
        this.canRun = false;
        this.interrupt();
    }

    @Override
    public void run() {
        while (this.canRun) {
            try {
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Event queue is " + this.eventQueue));
                }
                DAOReplicationEvent event = this.eventQueue.getEvent();
                if (log.isFinestEnabled()) {
                    log.finest((Object)("Servicing event: " + event));
                }
                this.serviceEvent(event);
            }
            catch (InterruptedException event) {
            }
            catch (Exception genEx) {
                log.error((Object)genEx.toString(), (Throwable)genEx);
            }
        }
        if (log.isInfoEnabled()) {
            log.info((Object)"DAOReplicationQueueServicer stopped.");
        }
    }

    private synchronized void serviceEvent(DAOReplicationEvent event) {
        String primaryTable = event.getPrimaryTable();
        ++this.count;
        if (log.isFinestEnabled()) {
            log.finest((Object)("serviceEvent(): count = " + this.count));
        }
        if ("stats".equals(primaryTable)) {
            this.dumpCounts();
            return;
        }
        if (!this.eventCount.containsKey(primaryTable)) {
            this.eventCount.put(primaryTable, 1);
        } else {
            int count = this.eventCount.get(primaryTable) + 1;
            this.eventCount.put(primaryTable, count);
        }
        this.bucket.executeEventUpdates(event);
    }

    public DAOReplicationQueue getEventQueue() {
        return this.eventQueue;
    }

    public void setEventQueue(DAOReplicationQueue eventQueue) {
        this.eventQueue = eventQueue;
    }

    public DAOReplicationEventBucket getBucket() {
        return this.bucket;
    }

    public void setBucket(DAOReplicationEventBucket bucket) {
        this.bucket = bucket;
    }

    public void dumpCounts() {
        if (log.isFinestEnabled()) {
            log.finest((Object)"Replication event statistics:");
            for (String primaryTable : this.eventCount.keySet()) {
                int count = this.eventCount.get(primaryTable);
                log.finest((Object)("received " + count + " " + primaryTable + " events"));
            }
        }
    }

    public void updateEventTables(Class<? extends DataAccessObject> daoClazz) {
        this.eventQueue.pauseExecution();
        this.bucket.init(daoClazz);
        this.eventQueue.resumeExecution();
    }
}

