/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BatchStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.BoundStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.DeviceDataKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.DeviceDataPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.DeviceDataPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.helpers.UriUtils;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.DeviceDataKey;
import com.avaya.ustore.objectapi.DeviceDataRecord;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;

public class DeviceDataDAO
extends SessionBasedDAO {
    private final Logger log = AsmLogger.getLogger(DeviceDataDAO.class);
    private static final String CASSANDRA_TIMEOUT_DURING_WRITE = "Cassandra timeout during write query at consistency SERIAL";
    private static final String NOT_ENOUGH_REPLICAS_AVAILABLE = "Not enough replicas available for query at consistency SERIAL";
    private static boolean BatchStatementsArePreferred = true;
    protected DeviceDataPreparedStatements preparedStatements;

    public DeviceDataDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new DeviceDataPreparedStatements(sessionDAO);
    }

    public List<DeviceDataRecord> getDeviceData(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle, String dataName) throws DMException {
        String fcn_name = "getDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceData enter: keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle + ", dataName = " + dataName));
        }
        ArrayList<DeviceDataRecord> ddrList = new ArrayList<DeviceDataRecord>();
        DeviceDataRecord device = null;
        ResultSet rs = null;
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        DeviceDataPreparedStatementBuilder stBuilder = null;
        stBuilder = dataCategory == null || dataCategory.length() == 0 ? new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_ALL_DEVICES, builder, acpId) : (deviceHandle == null ? new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_DEVICE_DATA_CATEGORY, builder, acpId, dataCategory) : (dataName == null ? new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_DEVICE_HANDLE, builder, acpId, dataCategory, deviceHandle) : new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_DEVICE_DATA_NAME, builder, acpId, dataCategory, deviceHandle, dataName)));
        rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            device = this.createDeviceDataRecord(row, keyspace);
            ddrList.add(device);
        }
        if (isFiner) {
            this.log.finer((Object)("getDeviceData exit: returned ddrList = " + ddrList));
        }
        return ddrList;
    }

    public List<DeviceDataRecord> getDeviceDataRecordsForSmEm(UserStoreKeyspace keyspace, Long acpId, String dataCategory, Integer limit) throws DMException {
        String fcn_name = "getDeviceDataRecordsForSmEm";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSmEm enter: keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", limit = " + limit));
        }
        ArrayList<DeviceDataRecord> ddrList = new ArrayList<DeviceDataRecord>();
        DeviceDataRecord device = null;
        ResultSet rs = null;
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        DeviceDataPreparedStatementBuilder stBuilder = null;
        if (acpId != null && dataCategory != null && limit != null) {
            stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_ALL_PUBLIC_FOR_SMEM_BY_ACPID_AND_DATACATEGORY_AND_LIMIT, builder, acpId, dataCategory, limit);
        } else if (dataCategory != null && limit != null) {
            stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_ALL_PUBLIC_FOR_SMEM_BY_DATACATEGORY_AND_LIMIT, builder, dataCategory, limit);
        }
        rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            device = this.createDeviceDataRecord(row, keyspace);
            ddrList.add(device);
        }
        if (limit != null && ddrList.size() == limit.intValue()) {
            DeviceDataRecord prevDDR;
            DeviceDataKey prevDDK;
            ListIterator<DeviceDataRecord> lIter = ddrList.listIterator(ddrList.size());
            DeviceDataRecord lastDDR = lIter.previous();
            DeviceDataKey lastDDK = lastDDR.getKey();
            long lastAcpId = lastDDK.getAsmCommProfileId();
            String lastHandle = lastDDK.getDeviceHandle();
            lIter.remove();
            while (lIter.hasPrevious() && (prevDDK = (prevDDR = lIter.previous()).getKey()).getAsmCommProfileId() == lastAcpId && lastHandle.equals(prevDDK.getDeviceHandle())) {
                lIter.remove();
            }
            stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_ALL_PUBLIC_FOR_SMEM_BY_ACPID_AND_DATACATEGORY_AND_HANDLE_RANGE, builder, lastAcpId, dataCategory, lastHandle);
            rs = this.sessionDAO.executeStatement(stBuilder, builder);
            for (Row row : rs) {
                device = this.createDeviceDataRecord(row, keyspace);
                ddrList.add(device);
            }
        }
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataRecordsForSmEm exit: returning ddrList = " + ddrList));
        }
        return ddrList;
    }

    public List<DeviceDataRecord> getDeviceDataForSpecificEndpointFamily(UserStoreKeyspace keyspace, long acpId, String dataCategory, String deviceHandle) throws DMException {
        String fcn_name = "getDeviceDataForSpecificEndpointFamily";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataForSpecificEndpointFamily enter: keyspace = " + keyspace + ", acpId = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle));
        }
        ArrayList<DeviceDataRecord> ddrList = new ArrayList<DeviceDataRecord>();
        DeviceDataRecord device = null;
        ResultSet rs = null;
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        DeviceDataPreparedStatementBuilder stBuilder = null;
        if (dataCategory != null && deviceHandle != null) {
            String rangeQueryStart = "";
            String rangeQueryEnd = "";
            if (deviceHandle.equals("@@Avaya@@J100")) {
                rangeQueryStart = "@@Avaya@@J1";
                rangeQueryEnd = "@@Avaya@@K1";
            }
            stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_ALL_CONFIG_FOR_SMGR_BY_ACPID_AND_DATACATEGORY_AND_HANDLE_RANGE, builder, acpId, dataCategory, rangeQueryStart, rangeQueryEnd);
            rs = this.sessionDAO.executeStatement(stBuilder, builder);
            for (Row row : rs) {
                device = this.createDeviceDataRecord(row, keyspace);
                ddrList.add(device);
            }
        }
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataForSpecificEndpointFamily exit: returned ddrList = " + ddrList));
        }
        return ddrList;
    }

    public List<DeviceDataRecord> getDeviceDataWithNoValues(UserStoreKeyspace keyspace, long acpId) throws DMException {
        String fcn_name = "getDeviceDataWithNoValues";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataWithNoValues enter: keyspace = " + keyspace + ", acpId = " + acpId));
        }
        ArrayList<DeviceDataRecord> ddrList = new ArrayList<DeviceDataRecord>();
        DeviceDataRecord device = null;
        ResultSet rs = null;
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        DeviceDataPreparedStatementBuilder stBuilder = null;
        stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_ALL_DEVICES_NO_VALUES, builder, acpId);
        rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            device = this.createDeviceDataRecord(row, keyspace);
            ddrList.add(device);
        }
        if (isFiner) {
            this.log.finer((Object)("getDeviceDataWithNoValues exit: returned ddrList = " + ddrList));
        }
        return ddrList;
    }

    private DeviceDataRecord createDeviceDataRecord(Row row, UserStoreKeyspace keyspace) throws DMException {
        Date updateDateTime;
        Date createdDateTime;
        String fcn_name = "createDeviceDataRecord";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("createDeviceDataRecord enter: keyspace = " + keyspace));
        }
        if (row == null) {
            this.log.info((Object)"createDeviceDataRecord exit: row == null ");
            return null;
        }
        Long cdTimestamp = null;
        if (row.getColumnDefinitions().contains("createddatetime") && (createdDateTime = row.getTimestamp("createddatetime")) != null) {
            cdTimestamp = createdDateTime.getTime();
        }
        Long udTimestamp = (updateDateTime = row.getTimestamp("updatedatetime")) != null ? Long.valueOf(updateDateTime.getTime()) : null;
        String dataCategory = "null";
        if (row.getColumnDefinitions().contains("datacategory")) {
            dataCategory = row.getString("datacategory");
        }
        DeviceDataKey dDKey = new DeviceDataKey(row.getLong("acpid"), dataCategory, row.getString("devicehandle"), row.getString("dataname"), keyspace);
        Long ownerCsUserId = null;
        if (row.getColumnDefinitions().contains("ownercsuserid")) {
            ownerCsUserId = row.getLong("ownercsuserid");
        }
        DeviceDataRecord ddr = new DeviceDataRecord(dDKey, ownerCsUserId, cdTimestamp, udTimestamp, row.getString("datavalue"));
        if (isFiner) {
            this.log.finer((Object)("createDeviceDataRecord exit: returned ddr = " + ddr));
        }
        return ddr;
    }

    protected UserStoreKeyspaceBuilder getKeyspaceBuilder(UserStoreKeyspace keyspace) {
        return new DeviceDataKeyspaceBuilder(keyspace);
    }

    public void deleteDeviceData(UserStoreKeyspace keyspace, Collection<DeviceDataKey> ddkCollection, boolean isAtomic) throws DMException {
        boolean useBatchStatement;
        String fcn_name = "deleteDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        boolean bl = useBatchStatement = BatchStatementsArePreferred || isAtomic;
        if (ddkCollection == null) {
            this.log.error((Object)("deleteDeviceData No action taken. ddkCollection = null, keyspace = " + keyspace + ", useBatchStatement= " + useBatchStatement + ", isAtomic = " + isAtomic));
            return;
        }
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceData enter: keyspace = " + keyspace + ", ddkCollection.size() = " + ddkCollection.size() + ", useBatchStatement= " + useBatchStatement + ", isAtomic = " + isAtomic));
        }
        UserStoreKeyspaceBuilder builder = null;
        DeviceDataBatchStatementBuilder ddbsBuilder = null;
        for (DeviceDataKey ddk : ddkCollection) {
            long acpId = ddk.getAsmCommProfileId();
            String dataCategory = ddk.getDataCategory();
            String deviceHandle = ddk.getDeviceHandle();
            String dataName = ddk.getDataName();
            try {
                if (isFinest) {
                    this.log.finest((Object)("deleteDeviceData: Deleting - ddk = " + ddk + ", useBatchStatement = " + useBatchStatement + ", isAtomic = " + isAtomic));
                }
                if (builder == null) {
                    builder = this.getKeyspaceBuilder(ddk.getKeyspace());
                }
                if (useBatchStatement) {
                    if (ddbsBuilder == null) {
                        ddbsBuilder = new DeviceDataBatchStatementBuilder(builder, isAtomic);
                    }
                    if (!UriUtils.isValidData(dataCategory)) {
                        ddbsBuilder.addToBatch(DeviceDataPreparedStatementType.DELETE_ALL_DEVICES, acpId);
                        continue;
                    }
                    if (deviceHandle == null) {
                        ddbsBuilder.addToBatch(DeviceDataPreparedStatementType.DELETE_DEVICE_DATA_CATEGORY, acpId, dataCategory);
                        continue;
                    }
                    if (dataName == null) {
                        ddbsBuilder.addToBatch(DeviceDataPreparedStatementType.DELETE_DEVICE_HANDLE, acpId, dataCategory, deviceHandle);
                        continue;
                    }
                    ddbsBuilder.addToBatch(DeviceDataPreparedStatementType.DELETE_DEVICE_DATA_NAME, acpId, dataCategory, deviceHandle, dataName);
                    continue;
                }
                DeviceDataPreparedStatementBuilder stBuilder = null;
                stBuilder = !UriUtils.isValidData(dataCategory) ? new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.DELETE_ALL_DEVICES, builder, acpId) : (deviceHandle == null ? new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.DELETE_DEVICE_DATA_CATEGORY, builder, acpId, dataCategory) : (dataName == null ? new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.DELETE_DEVICE_HANDLE, builder, acpId, dataCategory, deviceHandle) : new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.DELETE_DEVICE_DATA_NAME, builder, acpId, dataCategory, deviceHandle, dataName)));
                this.sessionDAO.executeStatement(stBuilder, builder);
            }
            catch (DMException dme) {
                this.log.error((Object)("deleteDeviceData: acpid = " + acpId + ", dataCategory = " + dataCategory + ", deviceHandle = " + deviceHandle + ", dataName = " + dataName + ", useBatchStatement = " + useBatchStatement + ", isAtomic = " + isAtomic + ", Exception = " + dme), (Throwable)dme);
                throw dme;
            }
        }
        if (useBatchStatement) {
            this.sessionDAO.executeStatement(ddbsBuilder, builder);
        }
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceData exit: " + ddkCollection.size() + " device data records deleted, useBatchStatement = " + useBatchStatement + ", isAtomic = " + isAtomic));
        }
    }

    public void setDeviceData(Collection<DeviceDataRecord> ddrCollection, boolean isAtomic) throws DMException {
        boolean useBatchStatement;
        String fcn_name = "setDeviceData";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        boolean bl = useBatchStatement = BatchStatementsArePreferred || isAtomic;
        if (ddrCollection == null || ddrCollection.isEmpty()) {
            this.log.error((Object)("setDeviceData: No action taken. ddrCollection = null, useBatchStatement= " + useBatchStatement + ", isAtomic = " + isAtomic));
            return;
        }
        if (isFiner) {
            this.log.finer((Object)("setDeviceData enter: ddrCollection.size() = " + ddrCollection.size() + ", useBatchStatement= " + useBatchStatement + ", isAtomic = " + isAtomic));
        }
        UserStoreKeyspaceBuilder builder = null;
        DeviceDataBatchStatementBuilder ddbsBuilder = null;
        for (DeviceDataRecord ddr : ddrCollection) {
            DeviceDataKey ddk = ddr.getKey();
            Date updateDateTime = new Date(ddr.getUpdateDateTime());
            Long dateCreated = ddr.getCreatedDateTime();
            try {
                if (builder == null) {
                    builder = this.getKeyspaceBuilder(ddr.getKey().getKeyspace());
                }
                if (useBatchStatement) {
                    if (ddbsBuilder == null) {
                        ddbsBuilder = new DeviceDataBatchStatementBuilder(builder, isAtomic);
                    }
                    if (dateCreated == null) {
                        if (isFinest) {
                            this.log.finest((Object)("setDeviceData: Batch Update - ddr = " + ddr + ", isAtomic = " + isAtomic));
                        }
                        ddbsBuilder.addToBatch(DeviceDataPreparedStatementType.UPDATE_DEVICE, ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName(), ddr.getDataValue(), ddr.getOwnerCsUserId(), updateDateTime);
                        continue;
                    }
                    if (isFinest) {
                        this.log.finest((Object)("setDeviceData: Batch Add - ddr = " + ddr + ", isAtomic = " + isAtomic));
                    }
                    ddbsBuilder.addToBatch(DeviceDataPreparedStatementType.ADD_DEVICE, ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName(), ddr.getDataValue(), ddr.getOwnerCsUserId(), new Date(dateCreated), updateDateTime);
                    continue;
                }
                DeviceDataPreparedStatementBuilder stBuilder = null;
                if (dateCreated == null) {
                    if (isFinest) {
                        this.log.finest((Object)("setDeviceData: Update - ddr = " + ddr + ", isAtomic = " + isAtomic));
                    }
                    stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.UPDATE_DEVICE, builder, ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName(), ddr.getDataValue(), ddr.getOwnerCsUserId(), updateDateTime);
                } else {
                    if (isFinest) {
                        this.log.finest((Object)("setDeviceData: Add - ddr = " + ddr + ", isAtomic = " + isAtomic));
                    }
                    stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.ADD_DEVICE, builder, ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName(), ddr.getDataValue(), ddr.getOwnerCsUserId(), new Date(dateCreated), updateDateTime);
                }
                this.sessionDAO.executeStatement(stBuilder, builder);
            }
            catch (DMException dme) {
                this.log.error((Object)("setDeviceData: acpId = " + ddk.getAsmCommProfileId() + ", dataCategory = " + ddk.getDataCategory() + ", deviceHandle = " + ddk.getDeviceHandle() + ", dataName = " + ddk.getDataName() + ", dataValue = " + ddr.getDataValue() + ", csUserId = " + ddr.getOwnerCsUserId() + ", updateDateTime = " + updateDateTime + ", useBatchStatement = " + useBatchStatement + ", isAtomic = " + isAtomic + ", Exception = " + dme), (Throwable)dme);
                throw dme;
            }
        }
        if (useBatchStatement) {
            this.sessionDAO.executeStatement(ddbsBuilder, builder);
        }
        if (isFiner) {
            this.log.finer((Object)("setDeviceData exit: " + ddrCollection.size() + " device data records written, useBatchStatement = " + useBatchStatement + ", isAtomic = " + isAtomic));
        }
    }

    public void setDeviceDataTimestamp(DeviceDataKey ddk, long timestamp) throws DMException {
        String fcn_name = "setDeviceDataTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        boolean useBatchStatement = BatchStatementsArePreferred;
        if (ddk == null) {
            this.log.error((Object)("setDeviceDataTimestamp No action taken. deviceDataKey = null, timestamp = " + timestamp + ", useBatchStatement= " + useBatchStatement));
            return;
        }
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp enter: deviceDataKey = " + ddk + ", timestamp = " + timestamp + ", useBatchStatement= " + useBatchStatement));
        }
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(ddk.getKeyspace());
        Date updateDateTime = new Date(timestamp);
        if (useBatchStatement) {
            boolean isAtomic = false;
            DeviceDataBatchStatementBuilder ddbsBuilder = new DeviceDataBatchStatementBuilder(builder, false);
            ddbsBuilder.addToBatch(DeviceDataPreparedStatementType.UPDATE_DEVICE_TIMESTAMP, updateDateTime, ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName());
            this.sessionDAO.executeStatement(ddbsBuilder, builder);
        } else {
            DeviceDataPreparedStatementBuilder stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.UPDATE_DEVICE_TIMESTAMP, builder, updateDateTime, ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName());
            this.sessionDAO.executeStatement(stBuilder, builder);
        }
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp exit: deviceDataKey = " + ddk + ", timestamp = " + timestamp + ", useBatchStatement= " + useBatchStatement));
        }
    }

    public void setDeviceDataTimestamp(Collection<DeviceDataRecord> ddrCollection, long timestamp, boolean isAtomic) throws DMException {
        boolean useBatchStatement;
        String fcn_name = "setDeviceDataTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        boolean bl = useBatchStatement = BatchStatementsArePreferred || isAtomic;
        if (ddrCollection == null) {
            this.log.error((Object)("setDeviceDataTimestamp: No action taken. ddrCollection = null, timestamp = " + timestamp + ", useBatchStatement= " + useBatchStatement + ", isAtomic = " + isAtomic));
            return;
        }
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp enter: ddrCollection.size() = " + ddrCollection.size() + ", timestamp = " + timestamp + ", useBatchStatement= " + useBatchStatement + ", isAtomic = " + isAtomic));
        }
        UserStoreKeyspaceBuilder builder = null;
        DeviceDataBatchStatementBuilder ddbsBuilder = null;
        for (DeviceDataRecord ddr : ddrCollection) {
            DeviceDataKey ddk = ddr.getKey();
            Date updateDateTime = new Date(ddr.getUpdateDateTime());
            try {
                if (builder == null) {
                    builder = this.getKeyspaceBuilder(ddr.getKey().getKeyspace());
                }
                if (useBatchStatement) {
                    if (ddbsBuilder == null) {
                        ddbsBuilder = new DeviceDataBatchStatementBuilder(builder, isAtomic);
                    }
                    ddbsBuilder.addToBatch(DeviceDataPreparedStatementType.UPDATE_DEVICE_TIMESTAMP, updateDateTime, ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName());
                    continue;
                }
                DeviceDataPreparedStatementBuilder stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.UPDATE_DEVICE_TIMESTAMP, builder, updateDateTime, ddk.getAsmCommProfileId(), ddk.getDataCategory(), ddk.getDeviceHandle(), ddk.getDataName());
                this.sessionDAO.executeStatement(stBuilder, builder);
            }
            catch (DMException dme) {
                this.log.error((Object)("setDeviceDataTimestamp: acpId = " + ddk.getAsmCommProfileId() + ", dataCategory = " + ddk.getDataCategory() + ", deviceHandle = " + ddk.getDeviceHandle() + ", dataName = " + ddk.getDataName() + ", dataValue = " + ddr.getDataValue() + ", csUserId = " + ddr.getOwnerCsUserId() + ", updateDateTime = " + updateDateTime + ", useBatchStatement = " + useBatchStatement + ", isAtomic = " + isAtomic + ", Exception = " + dme), (Throwable)dme);
                throw dme;
            }
        }
        if (useBatchStatement) {
            this.sessionDAO.executeStatement(ddbsBuilder, builder);
        }
        if (isFiner) {
            this.log.finer((Object)("setDeviceDataTimestamp exit: " + ddrCollection.size() + " device data records written, timestamp = " + timestamp + ", useBatchStatement= " + useBatchStatement + ", isAtomic = " + isAtomic));
        }
    }

    public boolean getBatchStatementsArePreferred() {
        return BatchStatementsArePreferred;
    }

    public void setBatchStatementsArePreferred(boolean batchStatementsArePreferred) {
        BatchStatementsArePreferred = batchStatementsArePreferred;
    }

    public void getDistinctAcpIdsFromKeyspace(UserStoreKeyspace keyspace, Collection<Long> acpIdList) throws DMException {
        String fcn_name = "getDistinctAcpIdsFromKeyspace";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("getDistinctAcpIdsFromKeyspace enter: keyspace = " + keyspace));
        }
        ResultSet rs = null;
        UserStoreKeyspaceBuilder builder = this.getKeyspaceBuilder(keyspace);
        DeviceDataPreparedStatementBuilder stBuilder = null;
        stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.GET_ALL_ACP_IDS_FROM_KEYSPACE, builder, new Object[0]);
        rs = this.sessionDAO.executeStatement(stBuilder, builder);
        for (Row row : rs) {
            Long acpId = null;
            if (row.isNull(0)) {
                this.log.warn((Object)"getDistinctAcpIdsFromKeyspace: retrieved a null acpId");
                continue;
            }
            acpId = row.getLong(0);
            acpIdList.add(acpId);
        }
        if (isFiner) {
            this.log.finer((Object)("getDistinctAcpIdsFromKeyspace exit: returned acpIdList = " + acpIdList + ", size=" + acpIdList.size()));
        }
    }

    public void deleteDeviceDataForAcpId(UserStoreKeyspace keyspace, long acpId, boolean isAtomic) throws DMException {
        String fcn_name = "deleteDeviceDataForAcpId";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceDataForAcpId enter: keyspace = " + keyspace + ", acpId = " + acpId + ", isAtomic = " + isAtomic));
        }
        UserStoreKeyspaceBuilder builder = null;
        try {
            if (isFinest) {
                this.log.finest((Object)("deleteDeviceDataForAcpId: Deleting - acpId = " + acpId + ", isAtomic = " + isAtomic));
            }
            if (builder == null) {
                builder = this.getKeyspaceBuilder(keyspace);
            }
            DeviceDataPreparedStatementBuilder stBuilder = null;
            stBuilder = new DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType.DELETE_ALL_DEVICES, builder, acpId);
            this.sessionDAO.executeStatement(stBuilder, builder);
        }
        catch (DMException dme) {
            this.log.error((Object)("deleteDeviceDataForAcpId: acpid = " + acpId + ", isAtomic = " + isAtomic + ", Exception = " + dme), (Throwable)dme);
            throw dme;
        }
        if (isFiner) {
            this.log.finer((Object)("deleteDeviceDataForAcpId exit:  acpId = " + acpId + ", isAtomic = " + isAtomic));
        }
    }

    private class SetDeviceBoundStatementBuilder
    extends BoundStatementBuilder<DeviceDataPreparedStatementType> {
        private DeviceDataRecord ddr;

        public SetDeviceBoundStatementBuilder(UserStoreKeyspaceBuilder builder, DeviceDataPreparedStatementType psType, DeviceDataRecord ddr) {
            super(DeviceDataDAO.this.preparedStatements, psType, builder);
            this.ddr = ddr;
        }

        @Override
        public void bindStatement(BoundStatement bs) {
            bs.setLong("acpid", this.ddr.getKey().getAsmCommProfileId());
            bs.setString("datacategory", this.ddr.getKey().getDataCategory());
            bs.setString("devicehandle", this.ddr.getKey().getDeviceHandle());
            bs.setString("dataname", this.ddr.getKey().getDataName());
            bs.setLong("ownercsuserid", this.ddr.getOwnerCsUserId().longValue());
            bs.setString("datavalue", this.ddr.getDataValue());
            if (((DeviceDataPreparedStatementType)this.psType).equals((Object)DeviceDataPreparedStatementType.ADD_DEVICE)) {
                bs.setTimestamp("createddatetime", new Date(this.ddr.getCreatedDateTime()));
            }
            bs.setTimestamp("updatedatetime", new Date(this.ddr.getUpdateDateTime()));
        }
    }

    private class DeviceDataBatchStatementBuilder
    extends BatchStatementBuilder<DeviceDataPreparedStatementType> {
        public DeviceDataBatchStatementBuilder(UserStoreKeyspaceBuilder builder) {
            super(DeviceDataDAO.this.preparedStatements, builder, BatchStatement.Type.LOGGED);
        }

        public DeviceDataBatchStatementBuilder(UserStoreKeyspaceBuilder builder, boolean isAtomic) {
            super(DeviceDataDAO.this.preparedStatements, builder, isAtomic ? BatchStatement.Type.LOGGED : BatchStatement.Type.UNLOGGED);
        }
    }

    private class DeviceDataPreparedStatementBuilder
    extends PreparedStatementBuilder<DeviceDataPreparedStatementType> {
        public DeviceDataPreparedStatementBuilder(DeviceDataPreparedStatementType type, UserStoreKeyspaceBuilder builder, Object ... args) {
            super(DeviceDataDAO.this.preparedStatements, type, builder, args);
        }
    }
}

