/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.dao.ustore;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.dao.cassandra.BatchStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.NullUserStoreKeyspaceBuilder;
import com.avaya.asm.datamgr.dao.cassandra.PreparedStatementBuilder;
import com.avaya.asm.datamgr.dao.cassandra.SessionBasedDAO;
import com.avaya.asm.datamgr.dao.cassandra.SessionDAO;
import com.avaya.asm.datamgr.dao.cassandra.UpdatedContactsPreparedStatementType;
import com.avaya.asm.datamgr.dao.cassandra.UpdatedContactsPreparedStatements;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspaceBuilder;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.objectapi.UpdatedUser;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class UpdatedContactsHistoryDAO
extends SessionBasedDAO {
    private final Logger log = AsmLogger.getLogger(UpdatedContactsHistoryDAO.class);
    protected UpdatedContactsPreparedStatements preparedStatements;

    public UpdatedContactsHistoryDAO(SessionDAO sessionDAO) {
        super(sessionDAO);
        this.preparedStatements = new UpdatedContactsPreparedStatements(sessionDAO);
    }

    public void addUser(int day, long csuserId, long updateTimeMillis) throws DMException {
        String fcn_name = "addUser";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"addUser: enter");
        }
        Date updateDateTime = new Date(updateTimeMillis);
        UpdatedContactsBatchStatementBuilder batchBuilder = new UpdatedContactsBatchStatementBuilder();
        batchBuilder.addToBatch(UpdatedContactsPreparedStatementType.ADD_UPDATEDCONTACTS, day, csuserId, updateDateTime);
        batchBuilder.addToBatch(UpdatedContactsPreparedStatementType.UPD_USERINFO_TIMESTAMP, updateDateTime, csuserId);
        this.sessionDAO.executeStatement(batchBuilder);
        if (isFiner) {
            this.log.finer((Object)"addUser: leave");
        }
    }

    public List<UpdatedUser> getUsers(int day) throws DMException {
        String fcn_name = "getUsers";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"getUsers: enter");
        }
        UpdatedContactsPreparedStatementBuilder stBuilder = new UpdatedContactsPreparedStatementBuilder(UpdatedContactsPreparedStatementType.GET_ALL_UPDATEDCONTACTS, day);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder);
        ArrayList<UpdatedUser> updatedUsers = new ArrayList<UpdatedUser>();
        for (Row row : rs) {
            UpdatedUser updatedUser = this.createUpdatedUser(row);
            updatedUsers.add(updatedUser);
        }
        if (isFiner) {
            this.log.finer((Object)"getUsers: leave , ");
        }
        return updatedUsers;
    }

    public void deleteUsers(int day) throws DMException {
        String fcn_name = "deleteUsers";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"deleteUsers: enter");
        }
        UpdatedContactsPreparedStatementBuilder stBuilder = new UpdatedContactsPreparedStatementBuilder(UpdatedContactsPreparedStatementType.DELETE_ALL_UPDATEDCONTACTS, day);
        this.sessionDAO.executeStatement(stBuilder);
        if (isFiner) {
            this.log.finer((Object)"deleteUsers: leave , ");
        }
    }

    public boolean isEmptyUpdatedContacts() throws DMException {
        String fcn_name = "isEmptyUserInfo";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"isEmptyUserInfo: enter");
        }
        boolean rc = this.isEmptyColumnFamily(UpdatedContactsPreparedStatementType.IS_EMPTY_USERINFO);
        if (isFiner) {
            this.log.finer((Object)("isEmptyUserInfo: leave , noRows = " + rc));
        }
        return rc;
    }

    public void truncateUpdatedContacts() throws DMException {
        String fcn_name = "truncateUpdatedContacts";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"truncateUpdatedContacts: enter");
        }
        this.truncateColumnFamily(UpdatedContactsPreparedStatementType.TRUNCATE_UPDATEDCONTACTS);
        if (isFiner) {
            this.log.finer((Object)"truncateUpdatedContacts: leave ");
        }
    }

    public void setUserInfoDataOkFlag(long csuserId, boolean dataok) throws DMException {
        String fcn_name = "setUserInfoDataOkFlag";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)("setUserInfoDataOkFlag: enter csuserid=" + csuserId + ", dataok=" + dataok));
        }
        UpdatedContactsPreparedStatementBuilder stBuilder = new UpdatedContactsPreparedStatementBuilder(UpdatedContactsPreparedStatementType.UPD_USERINFO_DATAOK_FLAG, dataok, csuserId);
        this.sessionDAO.executeStatement(stBuilder);
        if (isFiner) {
            this.log.finer((Object)"setUserInfoDataOkFlag: leave  ");
        }
    }

    public boolean getUserInfoDataOkFlag(long csuserId) throws DMException {
        String fcn_name = "getUserInfoDataOkFlag";
        boolean isFiner = this.log.isFinerEnabled();
        boolean dataok = true;
        if (isFiner) {
            this.log.finer((Object)"getUserInfoDataOkFlag: enter");
        }
        UpdatedContactsPreparedStatementBuilder stBuilder = new UpdatedContactsPreparedStatementBuilder(UpdatedContactsPreparedStatementType.GET_USERINFO_DATASOK_FLAG, csuserId);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder);
        boolean rowFound = false;
        for (Row row : rs) {
            if (rowFound) {
                throw new DMException("getUserInfoDataOkFlag: multiple UserInfo CF rows were returned from the DB for userid=" + csuserId);
            }
            if (row.isNull("dataok")) continue;
            dataok = row.getBool("dataok");
            rowFound = true;
        }
        if (isFiner) {
            this.log.finer((Object)("getUserInfoDataOkFlag: leave , dataok = " + dataok));
        }
        return dataok;
    }

    private UpdatedUser createUpdatedUser(Row row) {
        Date dateTime;
        boolean isFiner = this.log.isFinerEnabled();
        String fcn_name = "createUpdatedUser";
        if (isFiner) {
            this.log.finer((Object)"createUpdatedUser: enter");
        }
        long timestamp = (dateTime = row.getTimestamp("lastupdatedatetime")) != null ? dateTime.getTime() : 0L;
        UpdatedUser updateUser = new UpdatedUser(row.getLong("csuserId"), timestamp);
        if (isFiner) {
            this.log.finer((Object)("createUpdatedUser: leave, updateUser=" + updateUser));
        }
        return updateUser;
    }

    public Long getUserInfoTimestamp(long csuserId) throws DMException {
        String fcn_name = "getUserInfoTimestamp";
        boolean isFiner = this.log.isFinerEnabled();
        Long luDateTime = null;
        if (isFiner) {
            this.log.finer((Object)("getUserInfoTimestamp: enter with csuserId: " + csuserId));
        }
        UpdatedContactsPreparedStatementBuilder stBuilder = new UpdatedContactsPreparedStatementBuilder(UpdatedContactsPreparedStatementType.GET_USERINFO_TIMESTAMP, csuserId);
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder);
        boolean rowFound = false;
        for (Row row : rs) {
            if (rowFound) {
                throw new DMException("getUserInfoTimestamp: multiple UserInfo CF rows were returned from the DB for userid = " + csuserId);
            }
            if (row.isNull("lastupdatedatetime")) continue;
            Date lastUpdateDateTime = row.getTimestamp("lastupdatedatetime");
            luDateTime = lastUpdateDateTime != null ? lastUpdateDateTime.getTime() : 0L;
            rowFound = true;
        }
        if (isFiner) {
            this.log.finer((Object)("getUserInfoTimestamp: leave , luDateTime = " + luDateTime));
        }
        return luDateTime;
    }

    public boolean isEmptyUserInfo() throws DMException {
        String fcn_name = "isEmptyUserInfo";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"isEmptyUserInfo: enter");
        }
        boolean rc = this.isEmptyColumnFamily(UpdatedContactsPreparedStatementType.IS_EMPTY_USERINFO);
        if (isFiner) {
            this.log.finer((Object)("isEmptyUserInfo: leave , noRows = " + rc));
        }
        return rc;
    }

    public void truncateUserInfo() throws DMException {
        String fcn_name = "truncateUserInfo";
        boolean isFiner = this.log.isFinerEnabled();
        if (isFiner) {
            this.log.finer((Object)"truncateUserInfo: enter");
        }
        this.truncateColumnFamily(UpdatedContactsPreparedStatementType.TRUNCATE_USERINFO);
        if (isFiner) {
            this.log.finer((Object)"truncateUserInfo: leave ");
        }
    }

    public void truncateColumnFamily(UpdatedContactsPreparedStatementType statementType) throws DMException {
        String fcn_name = "truncateColumnFamily";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        long prepTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("truncateColumnFamily: enter, statementType=" + (Object)((Object)statementType)));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        UpdatedContactsPreparedStatementBuilder stBuilder = new UpdatedContactsPreparedStatementBuilder(statementType, new Object[0]);
        if (isFinest) {
            prepTime = System.currentTimeMillis();
            this.log.finest((Object)("truncateColumnFamily: getPreparedStatement took " + (prepTime - startTime) + "ms"));
        }
        this.sessionDAO.executeStatement(stBuilder);
        long endTime = System.currentTimeMillis();
        if (isFinest) {
            endTime = System.currentTimeMillis();
            this.log.finest((Object)("truncateColumnFamily: executeStatement took " + (endTime - prepTime) + "ms"));
        }
        if (isFiner) {
            this.log.finer((Object)"truncateColumnFamily: leave");
        }
    }

    public boolean isEmptyColumnFamily(UpdatedContactsPreparedStatementType statementType) throws DMException {
        String fcn_name = "isEmptyColumnFamily";
        boolean isFiner = this.log.isFinerEnabled();
        boolean isFinest = this.log.isFinestEnabled();
        long startTime = 0L;
        long prepTime = 0L;
        if (isFiner) {
            this.log.finer((Object)("isEmptyColumnFamily: enter, statementType=" + (Object)((Object)statementType)));
        }
        if (isFinest) {
            startTime = System.currentTimeMillis();
        }
        UpdatedContactsPreparedStatementBuilder stBuilder = new UpdatedContactsPreparedStatementBuilder(statementType, new Object[0]);
        if (isFinest) {
            prepTime = System.currentTimeMillis();
            this.log.finest((Object)("isEmptyColumnFamily: getPreparedStatement took " + (prepTime - startTime) + "ms"));
        }
        ResultSet rs = this.sessionDAO.executeStatement(stBuilder);
        long endTime = System.currentTimeMillis();
        if (isFinest) {
            endTime = System.currentTimeMillis();
            this.log.finest((Object)("isEmptyColumnFamily: executeStatement took " + (endTime - prepTime) + "ms"));
        }
        boolean noRows = rs.isExhausted();
        if (isFiner) {
            this.log.finer((Object)("isEmptyColumnFamily: leave , noRows = " + noRows));
        }
        return noRows;
    }

    private static UserStoreKeyspaceBuilder createKeyspaceBuilder() {
        return new NullUserStoreKeyspaceBuilder(new UserStoreKeyspace("global_dc"));
    }

    private class UpdatedContactsBatchStatementBuilder
    extends BatchStatementBuilder<UpdatedContactsPreparedStatementType> {
        public UpdatedContactsBatchStatementBuilder() {
            super(UpdatedContactsHistoryDAO.this.preparedStatements, UpdatedContactsHistoryDAO.createKeyspaceBuilder(), BatchStatement.Type.UNLOGGED);
        }
    }

    private class UpdatedContactsPreparedStatementBuilder
    extends PreparedStatementBuilder<UpdatedContactsPreparedStatementType> {
        public UpdatedContactsPreparedStatementBuilder(UpdatedContactsPreparedStatementType type, Object ... args) {
            super(UpdatedContactsHistoryDAO.this.preparedStatements, type, UpdatedContactsHistoryDAO.createKeyspaceBuilder(), args);
        }
    }
}

