/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Set;

public class CustomObjectInputStream
extends ObjectInputStream {
    protected Set<ClassLoader> loaderList = null;

    public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        if (desc == null) {
            throw new IOException("ObjectStreamClass cannot be null.");
        }
        if (this.loaderList != null && this.loaderList.size() > 0) {
            for (ClassLoader cl : this.loaderList) {
                try {
                    return cl.loadClass(desc.getName());
                }
                catch (Exception exception) {
                }
            }
        }
        try {
            ClassLoader currentTccl = Thread.currentThread().getContextClassLoader();
            return currentTccl.loadClass(desc.getName());
        }
        catch (Exception exception) {
            return super.resolveClass(desc);
        }
    }

    public CustomObjectInputStream(InputStream in, Set<ClassLoader> clList) throws IOException {
        super(in);
        this.loaderList = clList;
    }
}

