/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.datadistributionlayer;

import com.avaya.asm.datamgr.datadistributionlayer.DataDistLayerMemberAddr;
import java.io.Serializable;

public class DataDistLayerMessage
implements Serializable {
    private static final long serialVersionUID = 5602671847248981508L;
    private boolean isHighPriority = false;
    private DataDistLayerMemberAddr host = null;
    private TargetAppId appId = TargetAppId.INTERNAL;
    private int messageType;
    private Serializable payload;

    public DataDistLayerMessage() {
        this.host = null;
        this.appId = null;
        this.messageType = 0;
        this.payload = null;
    }

    public DataDistLayerMessage(TargetAppId appId, int messageType, Serializable payload) {
        this.host = null;
        this.appId = appId;
        this.messageType = messageType;
        this.payload = payload;
    }

    public DataDistLayerMessage(TargetAppId appId, int messageType, Serializable payload, boolean isHighPriority) {
        this.host = null;
        this.appId = appId;
        this.messageType = messageType;
        this.payload = payload;
        this.isHighPriority = isHighPriority;
    }

    public DataDistLayerMessage(DataDistLayerMemberAddr host, TargetAppId appId, int messageType, Serializable payload) {
        this.host = host;
        this.appId = appId;
        this.messageType = messageType;
        this.payload = payload;
    }

    public DataDistLayerMessage(DataDistLayerMessage message) {
        this.host = message.getHost();
        this.appId = message.getAppId();
        this.messageType = message.getMessageType();
        this.payload = message.getPayload();
    }

    public DataDistLayerMemberAddr getHost() {
        return this.host;
    }

    public TargetAppId getAppId() {
        return this.appId;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public Serializable getPayload() {
        return this.payload;
    }

    public void setHost(DataDistLayerMemberAddr destination) {
        this.host = destination;
    }

    public void setAppId(TargetAppId appId) {
        this.appId = appId;
    }

    public void setMessageType(int messageType) {
        this.messageType = messageType;
    }

    public void setPayload(Serializable payload) {
        this.payload = payload;
    }

    public boolean isHighPriority() {
        return this.isHighPriority;
    }

    public void setIsHighPriority(boolean isHighPriority) {
        this.isHighPriority = isHighPriority;
    }

    public String toString() {
        return "DataDistLayerMessage[host=" + this.host + ", targetApp=" + (Object)((Object)this.appId) + ", messageType=" + this.messageType + ", payload=" + this.payload + "]";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DataDistLayerMessage)) {
            return false;
        }
        DataDistLayerMessage that = (DataDistLayerMessage)obj;
        return this.toString().equals(that.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public static enum TargetAppId {
        ADAPTATION,
        ASM_CALL_PROC_SERVLET,
        BANDWIDTH,
        BW_PREEMPTION,
        CALLADMCONTROL,
        CALLCOUNT,
        CALLRECONSTRUCTION_DDM,
        CALLRECONSTRUCTION,
        DEBUGGING,
        EVENTPROXY,
        INTERNAL,
        LIMBO_HANDLER,
        MGMT_REQ,
        MTCAGENT,
        REGISTRAR,
        REPLICATION,
        SIPMONITOR,
        SMCONSOLE,
        USER_COMMUNITY,
        USTORE_DB_EVENTS;

    }
}

