/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.helpers;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.helpers.ContactType;
import com.avaya.asm.datamgr.helpers.SmgrContactEnums;
import com.avaya.common.logging.client.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContactUtils {
    private static final Logger log = AsmLogger.getLogger(ContactUtils.class);
    static final String stubPrefix = "__ppm_";
    static Pattern stubNamePat = Pattern.compile("__ppm_[^\\s,]*");

    public static ContactType getContactType(String category, String type) {
        String fcn_name = "getContactType";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        if (isFiner) {
            log.finer((Object)("getContactType: enter, category=" + category + ", type=" + type));
        }
        SmgrContactEnums smgrContactEnums = new SmgrContactEnums(category, type);
        if (isFinest) {
            log.finest((Object)("getContactType: smgrContactEnums=" + smgrContactEnums));
        }
        ContactType contactType = ContactUtils.contactEnumsToPhoneType(smgrContactEnums);
        if (isFiner) {
            log.finer((Object)("getContactType: leave, contactType=" + (Object)((Object)contactType)));
        }
        return contactType;
    }

    public static ContactType contactEnumsToPhoneType(SmgrContactEnums enums) {
        String category = enums.getCategory();
        String type = enums.getType();
        if (!"ibmsametime".equals(type)) {
            if ("sip".equals(type) || "msrtc".equals(type)) {
                return ContactType.HANDLE;
            }
            if ("smtp".equals(type)) {
                return ContactType.EMAIL;
            }
            if ("xmpp".equals(type)) {
                return ContactType.XMPP;
            }
            if ("office".equals(category)) {
                return ContactType.WORK;
            }
            if ("home".equals(category)) {
                return ContactType.HOME;
            }
            if ("mobile".equals(category)) {
                return ContactType.MOBILE;
            }
            if ("fax".equals(category)) {
                return ContactType.FAX;
            }
            if ("pager".equals(category)) {
                return ContactType.PAGER;
            }
            if (category.isEmpty()) {
                return ContactType.WORK;
            }
        }
        return null;
    }

    public static String removeStubName(String name) {
        if (name == null) {
            return null;
        }
        Matcher matcher = stubNamePat.matcher(name);
        return matcher.replaceAll("");
    }
}

