/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.AudioVideoPool;
import java.util.concurrent.atomic.AtomicLong;

public class AVBBandwidth
extends AudioVideoPool {
    private static final long serialVersionUID = -595749833654140046L;
    private AtomicLong borrowed = null;
    private boolean isInfinite = false;

    public AVBBandwidth() {
        this.borrowed = new AtomicLong(0L);
    }

    public AVBBandwidth(Long audio, Long video, Long borrowed) {
        super(audio, video);
        if (this.isInfinite(this)) {
            this.audio.set(0L);
            this.video.set(0L);
            this.isInfinite = true;
        } else {
            this.isInfinite = false;
        }
        if (borrowed == null) {
            borrowed = 0L;
        }
        this.borrowed = new AtomicLong(borrowed);
    }

    public AVBBandwidth(Long audio, Long video) {
        super(audio, video);
        if (this.isInfinite(this)) {
            this.audio.set(0L);
            this.video.set(0L);
            this.isInfinite = true;
        } else {
            this.isInfinite = false;
        }
        this.borrowed = new AtomicLong(0L);
    }

    public AVBBandwidth(long amount, int whichPool) {
        this((Long)0L, 0L);
        if (whichPool == 0) {
            this.adjust(amount, 0);
        } else if (whichPool == 1) {
            this.adjust(amount, 1);
        } else if (whichPool == 2) {
            this.adjust(amount, 2);
        }
    }

    public AVBBandwidth(AVBBandwidth locBw) {
        super(locBw);
        this.borrowed = new AtomicLong(locBw.borrowed.get());
        this.isInfinite = locBw.isInfinite;
    }

    @Override
    public synchronized void set(AudioVideoPool bw) {
        if (bw instanceof AVBBandwidth) {
            AVBBandwidth avb = (AVBBandwidth)bw;
            this.borrowed = avb.borrowed;
            boolean bl = this.isInfinite = avb.isInfinite || this.isInfinite(bw);
            if (this.isInfinite) {
                this.borrowed.set(0L);
                this.video.set(0L);
                this.audio.set(0L);
            } else {
                super.set(bw);
            }
        }
    }

    @Override
    public synchronized void set(long amount, int whichPool) {
        if (whichPool == 2) {
            this.borrowed.set(amount);
        } else {
            super.set(amount, whichPool);
        }
    }

    protected void adjust(AVBBandwidth amount, int sign) {
        boolean bl = this.isInfinite = amount.isInfinite || this.isInfinite(amount);
        if (this.isInfinite) {
            this.borrowed.set(0L);
            this.video.set(0L);
            this.audio.set(0L);
        } else {
            this.borrowed.addAndGet((long)sign * amount.getBorrowed().get());
            super.adjust(amount, sign);
        }
    }

    @Override
    public synchronized void add(AudioVideoPool amount) {
        if (amount instanceof AVBBandwidth) {
            this.adjust((AVBBandwidth)amount, 1);
        } else {
            super.adjust(amount, 1);
        }
    }

    @Override
    public synchronized void subtract(AudioVideoPool amount) {
        if (amount instanceof AVBBandwidth) {
            this.adjust((AVBBandwidth)amount, -1);
        } else {
            super.adjust(amount, -1);
        }
    }

    public synchronized void borrow(Long amt) {
        this.borrowed.addAndGet(amt);
        this.video.addAndGet(-amt.longValue());
        this.audio.addAndGet(amt);
    }

    public AtomicLong getBorrowed() {
        return this.borrowed;
    }

    @Override
    public Long getAmount(int whichPool) {
        if (whichPool == 2) {
            return this.borrowed.get();
        }
        return super.getAmount(whichPool);
    }

    @Override
    public synchronized long adjust(Long amount, int whichPool) {
        if (this.isInfinite && amount > 0L) {
            this.isInfinite = false;
        }
        if (whichPool == 2) {
            return this.borrowed.addAndGet(amount);
        }
        return super.adjust(amount, whichPool);
    }

    public Long getAVBTotal() {
        return this.getTotal() + this.borrowed.get();
    }

    @Override
    public boolean isEmpty() {
        return this.borrowed.get() == 0L && super.isEmpty();
    }

    @Override
    public String toString() {
        return this.isInfinite ? "infinite" : "A=" + this.audio + " V=" + this.video + " B=" + this.borrowed;
    }

    @Override
    public String fullToString() {
        return "Infinite: " + this.isInfinite + ", total=" + this.getTotal() + " (" + this.toString() + ")";
    }

    @Override
    public void abs() {
        super.abs();
        this.borrowed.set(Math.abs(this.borrowed.get()));
    }

    @Override
    public void invert() {
        super.invert();
        this.borrowed.set(-this.borrowed.get());
    }

    public boolean isInfinite() {
        return this.isInfinite;
    }

    public void setIsInfinite(boolean isInfinite) {
        this.isInfinite = isInfinite;
        if (isInfinite) {
            this.audio.set(0L);
            this.video.set(0L);
        }
    }

    public synchronized void normalize() {
        if (this.audio.get() < 0L) {
            this.borrow(-this.audio.get());
        } else if (this.video.get() < 0L) {
            this.borrow(this.video.get());
        }
    }

    private boolean isInfinite(AudioVideoPool bw) {
        return bw.audio.get() == -1L && bw.video.get() == -1L;
    }

    @Override
    public synchronized void clear() {
        this.audio.set(0L);
        this.video.set(0L);
        this.borrowed.set(0L);
        this.isInfinite = true;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof AVBBandwidth) {
            AVBBandwidth other = (AVBBandwidth)o;
            return (this.audio == null ? other.audio == null : this.audio.get() == other.audio.get()) && (this.video == null ? other.video == null : this.video.get() == other.video.get()) && (this.borrowed == null ? other.borrowed == null : this.borrowed.get() == other.borrowed.get() && this.isInfinite == other.isInfinite);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

