/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.DMUtilities;
import com.avaya.common.logging.client.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class CallCounter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Map<Integer, AtomicInteger> callCounts;
    protected transient Logger log = AsmLogger.getLogger(CallCounter.class);
    private Long id;
    private String idBasedType;

    public CallCounter(Long id, String idBasedType, Integer ... values) {
        this.callCounts = new ConcurrentHashMap<Integer, AtomicInteger>(6, 0.9f, 2);
        this.id = id;
        this.idBasedType = idBasedType;
        this.callCounts.put(1, new AtomicInteger(this.extractValue(values, 0)));
        this.callCounts.put(0, new AtomicInteger(this.extractValue(values, 1)));
        this.callCounts.put(3, new AtomicInteger(this.extractValue(values, 2)));
        this.callCounts.put(4, new AtomicInteger(this.extractValue(values, 3)));
        this.callCounts.put(5, new AtomicInteger(this.extractValue(values, 4)));
    }

    private int extractValue(Integer[] values, int idx) {
        return values != null && values.length >= idx + 1 ? values[idx] : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int adjust(Integer pool, int amt) {
        AtomicInteger count = this.callCounts.get(pool);
        if (count == null) {
            this.log.warn((Object)("Unknown pool " + pool));
            return 0;
        }
        AtomicInteger atomicInteger = count;
        synchronized (atomicInteger) {
            int curVal = count.addAndGet(amt);
            if (curVal < 0) {
                this.log.warn((Object)("adjust: We're negative for the call count in the " + DMUtilities.getPoolName(pool, false) + " (" + pool + ") pool.  Adjustment was " + amt + " on the " + this.idBasedType + " with id=" + this.id));
            }
        }
        return count.get();
    }

    public Long getId() {
        return this.id;
    }

    public int getCallCount(int pool) {
        AtomicInteger count = this.callCounts.get(pool);
        if (count == null) {
            this.log.warn((Object)("Unknown pool " + pool));
            return 0;
        }
        return count.get();
    }

    public void setCallCount(int pool, int amt) {
        AtomicInteger count = this.callCounts.get(pool);
        if (count == null) {
            this.log.warn((Object)("Unknown pool " + pool));
        } else {
            count.set(amt);
        }
    }

    public void setCallCount(Map<Integer, Integer> amt) {
        for (Map.Entry<Integer, Integer> e : amt.entrySet()) {
            this.callCounts.get(e.getKey()).set(e.getValue());
        }
    }

    public Map<Integer, Integer> getAllCallCounts() {
        HashMap<Integer, Integer> amt = new HashMap<Integer, Integer>();
        for (Map.Entry<Integer, AtomicInteger> e : this.callCounts.entrySet()) {
            amt.put(e.getKey(), e.getValue().get());
        }
        return amt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map<Integer, AtomicInteger> map = this.callCounts;
        synchronized (map) {
            for (AtomicInteger c : this.callCounts.values()) {
                if (c.get() == 0) continue;
                return false;
            }
        }
        return true;
    }

    public int getTotalCallCounts() {
        int ret = 0;
        if (this.callCounts != null) {
            for (AtomicInteger c : this.callCounts.values()) {
                ret += c.get();
            }
        }
        return ret;
    }

    public String toString() {
        return "id=" + this.id + " idType=" + this.idBasedType + "\n" + this.toStringCounts(false);
    }

    public String toStringCounts(boolean shortName) {
        ArrayList<Integer> counts = new ArrayList<Integer>(this.callCounts.keySet());
        Collections.sort(counts);
        String callCountsStr = new String();
        for (Integer i : counts) {
            callCountsStr = callCountsStr + DMUtilities.getPoolName(i, shortName) + "=" + this.callCounts.get(i).get() + (shortName ? " " : "\n");
        }
        return callCountsStr;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o != null && o instanceof CallCounter) {
            CallCounter cc = (CallCounter)o;
            boolean bl = (cc.id == null ? this.id == null : cc.id.equals(this.id)) && (cc.idBasedType == null ? this.idBasedType == null : cc.idBasedType.equals(this.idBasedType)) ? true : (isEqual = false);
            if (isEqual && cc.callCounts.size() == this.callCounts.size()) {
                for (Map.Entry<Integer, AtomicInteger> e : cc.callCounts.entrySet()) {
                    isEqual &= cc.callCounts.get(e.getKey()).get() == this.callCounts.get(e.getKey()).get();
                }
            } else {
                isEqual = false;
            }
        }
        return isEqual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setToZero() {
        Map<Integer, AtomicInteger> map = this.callCounts;
        synchronized (map) {
            for (AtomicInteger c : this.callCounts.values()) {
                c.set(0);
            }
        }
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 31 + (int)(this.id == null ? 0L : this.id);
        hashCode = hashCode * 31 + (this.idBasedType == null ? 0 : this.idBasedType.hashCode());
        hashCode = hashCode * 31 + this.callCounts.hashCode();
        return hashCode;
    }
}

