/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.datamgr.objectapi.DigitTreeDigitNode;
import com.avaya.asm.datamgr.objectapi.DigitTreeNodeMatcher;
import com.avaya.asm.datamgr.objectapi.DigitTreeObjectNodeMatch;
import com.avaya.common.logging.client.LogLevel;
import com.avaya.common.logging.client.Logger;
import java.util.TreeSet;

public class DigitTree<E> {
    public static final int SRE_STAR_INDEX = 10;
    public static final int SRE_POUND_INDEX = 11;
    public static final int SRE_PLUS_INDEX = 12;
    public static final int SRE_WILDCARD_INDEX = 13;
    protected static final char[] gdaChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '*', '#', '+', 'x'};
    private static final Logger log = AsmLogger.getLogger(DigitTree.class);
    protected final DigitTreeDigitNode<E> root = new DigitTreeDigitNode(this);

    public int getMaxDigits() {
        return gdaChars.length;
    }

    public char getGDAChar(int i) {
        return gdaChars[i];
    }

    public boolean isEmpty() {
        return this.root.isEmpty();
    }

    public String dumpTree() {
        return this.root.dumpNode(this, "").toString();
    }

    public int nodeIndex(String digits, int depth) {
        int index;
        try {
            index = this.gdaIndex(digits.charAt(depth));
        }
        catch (IndexOutOfBoundsException e) {
            index = -1;
        }
        if (index < 0) {
            log.error((Object)("Invalid digit at depth " + depth + " in " + digits));
            throw new UnsupportedOperationException("Invalid digit");
        }
        return index;
    }

    protected int gdaIndex(char digit) {
        if (digit >= '0' && digit <= '9') {
            return digit - 48;
        }
        if (digit == '*') {
            return 10;
        }
        if (digit == '#') {
            return 11;
        }
        if (digit == '+') {
            return 12;
        }
        if (digit == 'x' || digit == 'X') {
            return 13;
        }
        return -1;
    }

    public boolean validRouteDigits(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        char c = s.charAt(0);
        if ((c < '0' || c > '9') && c != '*' && c != '#' && c != '+') {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            c = s.charAt(i);
            if (c >= '0' && c <= '9' || c == '*' || c == '#' || c == '+' || c == ',' || c == '!' || c == '&' || c == '$' || c == '%') continue;
            return false;
        }
        return true;
    }

    public boolean validDigits(String s) {
        if (s == null) {
            return false;
        }
        int len = s.length();
        if (len == 0) {
            return false;
        }
        int i = 0;
        char c = s.charAt(0);
        if (c == '+') {
            if (len == 1) {
                return true;
            }
            i = 1;
            c = s.charAt(1);
        } else {
            while (c == '*' || c == '#') {
                if (++i == len) {
                    return true;
                }
                c = s.charAt(i);
            }
        }
        while (c >= '0' && c <= '9' || c == 'x' || c == 'X') {
            if (++i == len) {
                return true;
            }
            c = s.charAt(i);
        }
        return false;
    }

    public int nonDigitDelimiter(String digits) {
        int len = digits.length();
        if (len == 0) {
            return 0;
        }
        int i = 0;
        char c = digits.charAt(0);
        if (c == '+') {
            if (len == 1) {
                return 1;
            }
            i = 1;
            c = digits.charAt(1);
        } else {
            while (c == '*' || c == '#') {
                if (++i == len) {
                    return len;
                }
                c = digits.charAt(i);
            }
        }
        while (c >= '0' && c <= '9' && ++i != len) {
            c = digits.charAt(i);
        }
        return i;
    }

    public int getWildCardIndex() {
        return 13;
    }

    public void insert(String digits, short min, short max, E object, DigitTreeNodeMatcher<E> matcher) {
        if (digits != null) {
            digits = digits.trim();
        }
        if (!this.validDigits(digits)) {
            log.error((Object)("Insert invalid digit string " + digits));
            throw new IllegalArgumentException("Invalid digit string");
        }
        if (min < digits.length() || max < digits.length() || max < min) {
            log.error((Object)("Insert " + digits + " invalid min/max " + min + "/" + max));
            throw new IllegalArgumentException("Invalid min/max");
        }
        this.root.insert(this, 0, digits, min, max, object, matcher);
        if (log.isFineEnabled()) {
            log.fine((Object)("insert(" + digits + "/" + min + "/" + max + ") inserted " + object));
        }
    }

    public void delete(String digits, short min, short max, DigitTreeNodeMatcher<E> matcher) {
        if (digits != null) {
            digits = digits.trim();
        }
        if (!this.validDigits(digits)) {
            log.error((Object)("Delete invalid digits " + digits));
            throw new IllegalArgumentException("Invalid digit string");
        }
        this.root.delete(this, 0, digits, min, max, matcher);
        if (log.isFineEnabled()) {
            log.fine((Object)("delete(" + digits + "/" + min + "/" + max + ") succeeded"));
        }
    }

    public void update(String digits, short min, short max, E object, DigitTreeNodeMatcher<E> matcher) {
        if (digits != null) {
            digits = digits.trim();
        }
        if (!this.validDigits(digits)) {
            log.error((Object)("Update invalid digits " + digits));
            throw new IllegalArgumentException("Invalid digit string");
        }
        if (min < digits.length() || max < digits.length() || max < min) {
            log.error((Object)("Update " + digits + " invalid min/max " + min + "/" + max));
            throw new IllegalArgumentException("Invalid min/max");
        }
        this.root.update(this, 0, digits, min, max, object, matcher);
        if (log.isFineEnabled()) {
            log.fine((Object)("update(" + digits + "/" + min + "/" + max + ") updated to " + object));
        }
    }

    public E findBestMatch(String digits, DigitTreeNodeMatcher<E> matcher) {
        if (!this.validRouteDigits(digits)) {
            return null;
        }
        int i = this.nonDigitDelimiter(digits);
        DigitTreeObjectNodeMatch<E> match = this.root.findBestMatch(this, 0, digits.substring(0, i), matcher);
        return match == null ? null : (E)match.getNode().getObject();
    }

    public void getAllMatches(String digits, DigitTreeNodeMatcher<E> matcher, TreeSet<E> set) {
        if (!this.validRouteDigits(digits)) {
            return;
        }
        int i = this.nonDigitDelimiter(digits);
        this.root.getAllMatches(this, 0, digits.substring(0, i), matcher, set);
    }

    public static void setLogLevelForJUnit() {
        log.setLevel(LogLevel.INFO);
    }
}

