/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.IPAddress;

public class LocationPattern {
    public final String ipAddressPattern;
    protected final long locationId;
    public static final long INVALID_ADDRESS = -1L;
    public static final int INVALID_LENGTH = -1;
    private int maskLength = -1;
    protected IPAddress ip1 = null;
    protected IPAddress ip2 = null;

    public LocationPattern(String ipAddressPattern, long locationId) {
        this.ipAddressPattern = ipAddressPattern;
        this.locationId = locationId;
        int length = ipAddressPattern.length();
        int index = ipAddressPattern.indexOf(47);
        if (index > 0 && index + 1 < length) {
            String maskAddressStr = ipAddressPattern.substring(0, index);
            String maskStr = ipAddressPattern.substring(index + 1);
            try {
                this.ip1 = IPAddress.parseIPAddr(maskAddressStr);
                this.maskLength = Integer.parseInt(maskStr);
                this.ip2 = this.ip1.createMask(this.maskLength);
            }
            catch (Exception e) {
                this.ip2 = null;
                this.ip1 = null;
                this.maskLength = -1;
            }
            return;
        }
        index = ipAddressPattern.indexOf(45);
        if (index > 0 && index + 1 < length) {
            String startAddrStr = ipAddressPattern.substring(0, index);
            String endAddrStr = ipAddressPattern.substring(index + 1);
            try {
                this.ip1 = IPAddress.parseIPAddr(startAddrStr);
                this.ip2 = IPAddress.parseIPAddr(endAddrStr);
            }
            catch (Exception e) {
                this.ip2 = null;
                this.ip1 = null;
                return;
            }
            if (this.ip1.getAddressFamily() != this.ip2.getAddressFamily() || this.ip1.compareTo(this.ip2) > 0) {
                this.ip2 = null;
                this.ip1 = null;
            }
        }
    }

    public String getIpAddressPattern() {
        return this.ipAddressPattern;
    }

    public long getLocationId() {
        return this.locationId;
    }

    public boolean isMask() {
        return this.maskLength != -1;
    }

    public IPAddress getMaskAddress() {
        return this.ip1;
    }

    public int getMaskLength() {
        return this.maskLength;
    }

    public IPAddress getMask() {
        return this.ip2;
    }

    public boolean matchesMask(String address) {
        try {
            return this.matchesMask(IPAddress.parseIPAddr(address));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean matchesMask(IPAddress address) {
        if (!this.isMask()) {
            return false;
        }
        if (address.getAddressFamily() != this.getMask().getAddressFamily()) {
            return false;
        }
        char[] addrGroups = address.getGroups();
        char[] maskAddrGroups = this.getMaskAddress().getGroups();
        char[] maskGroups = this.getMask().getGroups();
        for (int i = 0; i < addrGroups.length; ++i) {
            int addrGroup = addrGroups[i] & 0xFFFF;
            int maskGroup = maskGroups[i] & 0xFFFF;
            int maskAddrGroup = maskAddrGroups[i] & 0xFFFF;
            if ((addrGroup & maskGroup) == (maskAddrGroup & maskGroup)) continue;
            return false;
        }
        return true;
    }

    public boolean isRange() {
        return this.ip1 != null && this.maskLength == -1;
    }

    public IPAddress getRangeStart() {
        return this.ip1;
    }

    public IPAddress getRangeEnd() {
        return this.ip2;
    }

    public boolean matchesRange(String address) {
        try {
            return this.matchesRange(IPAddress.parseIPAddr(address));
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean matchesRange(IPAddress address) {
        if (!this.isRange()) {
            return false;
        }
        if (address.getAddressFamily() != this.getRangeStart().getAddressFamily()) {
            return false;
        }
        return this.getRangeStart().compareTo(address) <= 0 && this.getRangeEnd().compareTo(address) >= 0;
    }

    public long getMaskAddressAsLong() {
        return this.convertToLong(this.getMaskAddress());
    }

    public long getMaskAsLong() {
        return this.convertToLong(this.getMask());
    }

    public long getRangeStartAsLong() {
        return this.convertToLong(this.getRangeStart());
    }

    public long getRangeEndAsLong() {
        return this.convertToLong(this.getRangeEnd());
    }

    public long parseAddress(String address) {
        try {
            IPAddress addr = IPAddress.parseIPAddr(address);
            return this.convertToLong(addr);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    protected long convertToLong(IPAddress addr) {
        long longAddr = 0L;
        if (addr != null) {
            char[] groups;
            for (char group : groups = addr.getGroups()) {
                longAddr = longAddr << 8 | (long)group;
            }
            return longAddr;
        }
        return -1L;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ipAddressPattern == null ? 0 : this.ipAddressPattern.hashCode());
        result = 31 * result + (int)(this.locationId ^ this.locationId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationPattern other = (LocationPattern)obj;
        if (this.ipAddressPattern == null ? other.ipAddressPattern != null : !this.ipAddressPattern.equals(other.ipAddressPattern)) {
            return false;
        }
        return this.locationId == other.locationId;
    }

    public String toString() {
        return "LocationPattern[" + this.ipAddressPattern + " --> locationId=" + this.locationId + "]";
    }
}

