/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.datamgr.objectapi;

import com.avaya.asm.datamgr.objectapi.MonitoredEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MonitorSummary
implements Serializable {
    private static final long serialVersionUID = 1L;
    Map<MonitoredEntity.Status, List<String>> statusMap = new HashMap<MonitoredEntity.Status, List<String>>();

    public MonitorSummary(Map<Long, MonitoredEntity> entityMap) {
        for (MonitoredEntity.Status status : MonitoredEntity.Status.values()) {
            ArrayList nameList = new ArrayList();
            this.statusMap.put(status, nameList);
        }
        if (entityMap != null) {
            for (MonitoredEntity entity : entityMap.values()) {
                List<String> nameList = this.statusMap.get((Object)entity.getStatus());
                nameList.add(entity.getName());
            }
        }
    }

    public List<String> getNotMonitored() {
        return this.statusMap.get((Object)MonitoredEntity.Status.NOTMONITORED);
    }

    public List<String> getInitializing() {
        return this.statusMap.get((Object)MonitoredEntity.Status.INITIALIZING);
    }

    public List<String> getUp() {
        return this.statusMap.get((Object)MonitoredEntity.Status.UP);
    }

    public List<String> getPartiallyUp() {
        return this.statusMap.get((Object)MonitoredEntity.Status.PARTIALLYUP);
    }

    public List<String> getDown() {
        return this.statusMap.get((Object)MonitoredEntity.Status.DOWN);
    }

    public List<String> getDeny() {
        return this.statusMap.get((Object)MonitoredEntity.Status.DENY);
    }

    public List<String> getAll() {
        ArrayList<String> allList = new ArrayList<String>();
        for (List<String> nameList : this.statusMap.values()) {
            allList.addAll(nameList);
        }
        return allList;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("NOTMONITORED: " + this.getNotMonitored());
        buf.append("\nINITIALIZING: " + this.getInitializing());
        buf.append("\n          UP: " + this.getUp());
        buf.append("\n PARTIALLYUP: " + this.getPartiallyUp());
        buf.append("\n        DOWN: " + this.getDown());
        buf.append("\n        DENY: " + this.getDeny());
        return buf.toString();
    }
}

