/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.jdom;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.jdom.ElementCheckerDescriptor;
import com.avaya.asm.jdom.ElementLimits;
import com.avaya.asm.jdom.JDomUtils;
import com.avaya.asm.jdom.exceptions.ElementCheckerException;
import com.avaya.asm.jdom.exceptions.MissingElementCheckerException;
import com.avaya.asm.jdom.exceptions.NotNillableElementCheckerException;
import com.avaya.asm.jdom.exceptions.UnexpectedElementCheckerException;
import com.avaya.common.logging.client.Logger;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;

public class ElementChecker {
    private HashMap<String, ElementLimits> elemLimitsMap = new HashMap();
    private static Logger log = AsmLogger.getLogger(ElementChecker.class);

    public ElementCheckerDescriptor openDescriptor() {
        return new ElementCheckerDescriptor(this.elemLimitsMap.size());
    }

    public boolean isRequired(String elemName) {
        ElementLimits limits = this.elemLimitsMap.get(elemName);
        boolean result = limits != null && limits.getMin() > 0;
        return result;
    }

    public void addRequiredElement(String name) {
        this.elemLimitsMap.put(name, new ElementLimits(1, 1, this.elemLimitsMap.size()));
    }

    public void addRequiredElement(String name, boolean nillable) {
        this.elemLimitsMap.put(name, new ElementLimits(1, 1, this.elemLimitsMap.size(), nillable));
    }

    public void addOptionalElement(String elemName) {
        this.elemLimitsMap.put(elemName, new ElementLimits(0, 1, this.elemLimitsMap.size()));
    }

    public void addOptionalElement(String elemName, boolean nillable) {
        this.elemLimitsMap.put(elemName, new ElementLimits(0, 1, this.elemLimitsMap.size(), nillable));
    }

    public void addUnboundedElement(String elemName) {
        this.elemLimitsMap.put(elemName, new ElementLimits(this.elemLimitsMap.size()));
    }

    public void addUnboundedElement(String elemName, boolean nillable) {
        this.elemLimitsMap.put(elemName, new ElementLimits(this.elemLimitsMap.size(), nillable));
    }

    public boolean foundElement(ElementCheckerDescriptor desc, Element elem, Class<?> cls, boolean ignoreUnknownElement) throws UnexpectedElementCheckerException, NotNillableElementCheckerException {
        String elemName = elem.getName();
        boolean isInfo = log.isInfoEnabled();
        String fcn_name = "foundElement";
        ElementLimits limits = this.elemLimitsMap.get(elemName);
        if (limits == null) {
            if (ignoreUnknownElement) {
                if (isInfo) {
                    log.info((Object)("foundElement: unexpected element <" + elemName + "> in request will be ignored"));
                }
                return false;
            }
            throw new UnexpectedElementCheckerException(elemName, cls, null);
        }
        Boolean isNil = JDomUtils.isNilAttribute(elem);
        if (isNil != null && !limits.getNillable()) {
            throw new NotNillableElementCheckerException(elemName, cls, "element contains nil attribute but is not nillable " + elem.getAttributeValue("nil", Namespace.getNamespace((String)"http://www.w3.org/2001/XMLSchema-instance")));
        }
        int index = limits.getIndex();
        int count = desc.getCount(index) + 1;
        desc.setCount(index, count);
        int max = limits.getMax();
        if (max > 0 && count > max) {
            throw new UnexpectedElementCheckerException(elemName, cls, "min allowed " + limits.getMin() + ", max allowed " + max + ", current count " + count);
        }
        return true;
    }

    public void noMoreElements(ElementCheckerDescriptor desc, Class<?> cls) throws ElementCheckerException {
        boolean isFiner = log.isFinerEnabled();
        String fcn_name = "noMoreElements";
        if (isFiner) {
            log.finer((Object)("noMoreElements enter, class " + cls.getName()));
        }
        for (Map.Entry<String, ElementLimits> entry : this.elemLimitsMap.entrySet()) {
            this.checkElemCounter(desc, entry.getKey(), entry.getValue(), cls);
        }
        if (isFiner) {
            log.finer((Object)"noMoreElements leave");
        }
    }

    private void checkElemCounter(ElementCheckerDescriptor desc, String elemName, ElementLimits limits, Class<?> cls) throws ElementCheckerException {
        boolean isFiner = log.isFinerEnabled();
        int count = desc.getCount(limits.getIndex());
        int min = limits.getMin();
        int max = limits.getMax();
        String fcn_name = "checkElemCounter";
        if (isFiner) {
            log.finer((Object)("checkElemCounter enter, elemName " + elemName + ", count " + count + ", min " + min + ", max " + max + ", cls " + cls.getName()));
        }
        if (count < min) {
            throw new MissingElementCheckerException(elemName, cls, " min allowed " + min + ", max allowed " + max + ", actual " + count);
        }
        if (max >= 0 && count > max) {
            throw new UnexpectedElementCheckerException(elemName, cls, "min allowed " + min + ", max allowed " + max + ", actual " + count);
        }
        if (isFiner) {
            log.finer((Object)"checkElemCounter leave");
        }
    }
}

