/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.asm.trustmgmt;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.trustmgmt.TrustMgmtUtil;
import com.avaya.common.logging.client.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Properties;
import javax.net.ssl.SSLContext;

public class IBMTrustMgmtUtil
extends TrustMgmtUtil {
    private static Logger log = AsmLogger.getLogger(IBMTrustMgmtUtil.class);
    private static volatile IBMTrustMgmtUtil instance = null;
    private static final String IBM_KEYSTORE_PWD = "com.ibm.ssl.keyStorePassword";
    private static final String IBM_TRUSTSTORE_KEY = "com.ibm.ssl.trustStore";
    private static final String IBM_KEYSTORE_KEY = "com.ibm.ssl.keyStore";
    private static final String IBM_SSL_PROVIDER_KEY = "com.ibm.ssl.contextProvider";
    private static final String IBM_JSSEHELPER = "com.ibm.websphere.ssl.JSSEHelper";
    private static final String IBM_NODE_DEFAULT_SSL_SETTING = "NodeDefaultSSLSettings";
    private static final String GET_INSTANCE_METHOD = "getInstance";
    private static final String GET_PROPERTIES_METHOD = "getProperties";
    private Properties aNodeDefaultSSLSettingsProperties = null;

    private IBMTrustMgmtUtil() {
    }

    public static synchronized IBMTrustMgmtUtil getInstance() {
        if (instance == null) {
            instance = new IBMTrustMgmtUtil();
        }
        return instance;
    }

    private synchronized boolean init() {
        if (this.aNodeDefaultSSLSettingsProperties == null) {
            String fcn_name = "IBMTrustMgmtUtil";
            Class<?> jsseHelperClass = null;
            try {
                jsseHelperClass = Class.forName(IBM_JSSEHELPER);
            }
            catch (ClassNotFoundException e) {
                log.error((Object)"IBMTrustMgmtUtil: Could not find class com.ibm.websphere.ssl.JSSEHelper", (Throwable)e);
            }
            if (jsseHelperClass == null) {
                return false;
            }
            Method getInstanceMethod = null;
            try {
                getInstanceMethod = jsseHelperClass.getMethod(GET_INSTANCE_METHOD, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"IBMTrustMgmtUtil: Could not find method getInstance", (Throwable)e);
            }
            catch (SecurityException e) {
                log.error((Object)"IBMTrustMgmtUtil: Security problem for method getInstance", (Throwable)e);
            }
            if (getInstanceMethod == null) {
                return false;
            }
            Object aJSSEHelperObject = null;
            try {
                aJSSEHelperObject = getInstanceMethod.invoke(jsseHelperClass, new Object[0]);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"IBMTrustMgmtUtil: bad to access to instance method", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"IBMTrustMgmtUtil: bad argument to instance method", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"IBMTrustMgmtUtil: instance method threw exception", (Throwable)e);
            }
            if (aJSSEHelperObject == null) {
                return false;
            }
            Method getPropertiesMethod = null;
            try {
                getPropertiesMethod = jsseHelperClass.getDeclaredMethod(GET_PROPERTIES_METHOD, String.class);
            }
            catch (NoSuchMethodException e) {
                log.error((Object)"IBMTrustMgmtUtil: Could not find method getProperties", (Throwable)e);
            }
            catch (SecurityException e) {
                log.error((Object)"IBMTrustMgmtUtil: Security problem for method getProperties", (Throwable)e);
            }
            if (getPropertiesMethod == null) {
                return false;
            }
            try {
                this.aNodeDefaultSSLSettingsProperties = (Properties)getPropertiesMethod.invoke(aJSSEHelperObject, new String(IBM_NODE_DEFAULT_SSL_SETTING));
            }
            catch (IllegalAccessException e) {
                log.error((Object)"IBMTrustMgmtUtil: bad to access to method NodeDefaultSSLSettings", (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"IBMTrustMgmtUtil: bad argument to method NodeDefaultSSLSettings", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"IBMTrustMgmtUtil: getProperties method threw exception for NodeDefaultSSLSettings", (Throwable)e);
            }
            if (this.aNodeDefaultSSLSettingsProperties == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected byte[] getStoragePassword() {
        if (!this.init()) {
            return null;
        }
        byte[] decryptedData = null;
        decryptedData = ((String)this.aNodeDefaultSSLSettingsProperties.get(IBM_KEYSTORE_PWD)).getBytes();
        return decryptedData;
    }

    @Override
    protected SSLContext getSSLContext() {
        String fcn_name = "getSSLContext";
        if (!this.init()) {
            return null;
        }
        SSLContext ctx = null;
        String ibmSSLProvider = (String)this.aNodeDefaultSSLSettingsProperties.get(IBM_SSL_PROVIDER_KEY);
        try {
            ctx = SSLContext.getInstance("TLSv1.2", ibmSSLProvider);
        }
        catch (NoSuchAlgorithmException nsae) {
            log.error((Object)"getSSLContext: There is no default algorithm configured for the KeymanagerFactory", (Throwable)nsae);
        }
        catch (NoSuchProviderException nspe) {
            log.error((Object)"getSSLContext: There is no provider for the KeymanagerFactory", (Throwable)nspe);
        }
        return ctx;
    }

    @Override
    protected String getTrustStorePath() {
        if (!this.init()) {
            return null;
        }
        return (String)this.aNodeDefaultSSLSettingsProperties.get(IBM_TRUSTSTORE_KEY);
    }

    @Override
    protected String getKeyStorePath() {
        if (!this.init()) {
            return null;
        }
        return (String)this.aNodeDefaultSSLSettingsProperties.get(IBM_KEYSTORE_KEY);
    }
}

