/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore.client.mgr;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.DeviceDataDM;
import com.avaya.asm.datamgr.dao.cassandra.UserStoreKeyspace;
import com.avaya.asm.datamgr.objectapi.AsmInstance;
import com.avaya.asm.datamgr.objectapi.ppm.AsmSipDeviceData;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.AsmDBMgr;
import com.avaya.ustore.UtilityErrorHandler;
import com.avaya.ustore.objectapi.DeviceDataKey;
import com.avaya.ustore.objectapi.DeviceDataRecord;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class UstoreDeviceMgr {
    private static final Logger log = AsmLogger.getLogger(UstoreDeviceMgr.class);
    private static DeviceDataDM deviceDataDM = new DeviceDataDM();

    public static void setDeviceDataDM(DeviceDataDM ddm) {
        deviceDataDM = ddm;
    }

    public static DeviceDataKey getDeviceDataKey(long acpId, String dataCategory, String deviceHandle, String dataName, List<Long> instanceIds) throws DMException {
        String fcn_name = "getDeviceDataKey";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        if (isFiner) {
            log.finer((Object)("getDeviceDataKey: enter with acpId: " + acpId + ", dataCategory: " + dataCategory + ", deviceHandle: " + deviceHandle + ", dataName: " + dataName + ", list of asmInstanceIds: " + instanceIds));
        }
        AsmDBMgr dbMgr = new AsmDBMgr(new UtilityErrorHandler());
        ArrayList<AsmInstance> asmInstanceList = new ArrayList<AsmInstance>();
        try {
            for (Long id : instanceIds) {
                AsmInstance instance = new AsmInstance(id, 65535L, dbMgr.queryAsmHostName(id), false);
                if (isFinest) {
                    log.finest((Object)("getDeviceDataKey: newly created Asminstance: " + instance));
                }
                asmInstanceList.add(instance);
            }
        }
        catch (SQLException sql) {
            throw new DMException("getDeviceDataKey: had trouble getting the Asm's hostname ", sql);
        }
        UserStoreKeyspace keyspace = new UserStoreKeyspace(asmInstanceList);
        return new DeviceDataKey(acpId, dataCategory, deviceHandle, dataName, keyspace);
    }

    public static void addUserStoreDeviceData(List<DeviceDataRecord> ddrList) throws DMException {
        String fcn_name = "addUserStoreDeviceData ";
        boolean isFiner = log.isFinerEnabled();
        boolean isAtomic = true;
        if (isFiner) {
            log.finer((Object)("addUserStoreDeviceData : Adding device data - " + ddrList));
        }
        deviceDataDM.setDeviceData(ddrList, isAtomic);
    }

    public static List<DeviceDataRecord> getDeviceDataRecordListFromAsmSipDeviceDataList(List<AsmSipDeviceData> asmSipDDList, long acpId, String deviceHandle, UserStoreKeyspace keyspace, Long ownerCsUserId) {
        String fcn_name = "getDeviceDataRecordListFromAsmSipDeviceDataList";
        boolean isFiner = log.isFinerEnabled();
        ArrayList<DeviceDataRecord> ddrList = new ArrayList<DeviceDataRecord>();
        if (isFiner) {
            log.finer((Object)("getDeviceDataRecordListFromAsmSipDeviceDataList: Enter with asmSipDDList: " + asmSipDDList + ", acpId = " + acpId + ", deviceHandle = " + deviceHandle + ", keyspace = " + keyspace + ", ownerCsUserId = " + ownerCsUserId));
        }
        if (deviceHandle != null) {
            long currentTimeInMillis = System.currentTimeMillis();
            for (AsmSipDeviceData asdd : asmSipDDList) {
                DeviceDataKey ddk = new DeviceDataKey(acpId, asdd.getDatacategory(), deviceHandle, asdd.getDataname(), keyspace);
                long updateDateTime = asdd.getUpdatedatetime() != null ? asdd.getUpdatedatetime().getTime() : currentTimeInMillis;
                DeviceDataRecord ddr = new DeviceDataRecord(ddk, ownerCsUserId, currentTimeInMillis, updateDateTime, asdd.getDatavalue());
                ddrList.add(ddr);
            }
            if (isFiner) {
                log.finer((Object)("getDeviceDataRecordListFromAsmSipDeviceDataList: Leave with ddrList: " + ddrList));
            }
        } else {
            log.error((Object)("getDeviceDataRecordListFromAsmSipDeviceDataList: deviceHandle is null for acpId = " + acpId + ", ownerCsUserId = " + ownerCsUserId + ", asmSipDDList = " + asmSipDDList));
        }
        return ddrList;
    }
}

