/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ustore.client.objectapi;

import com.avaya.asm.core.AsmLogger;
import com.avaya.asm.core.exceptions.DMException;
import com.avaya.asm.datamgr.helpers.ContactUtils;
import com.avaya.asm.datamgr.helpers.PostgresConnectionInfo;
import com.avaya.asm.datamgr.helpers.SipUriFormatter;
import com.avaya.asm.datamgr.helpers.UriUtils;
import com.avaya.asm.datamgr.helpers.XmppUriFormatter;
import com.avaya.asm.datamgr.objectapi.CsHandle;
import com.avaya.asm.datamgr.objectapi.ppm.ContactAddress;
import com.avaya.asm.datamgr.objectapi.ppm.ContactAddressLists;
import com.avaya.common.logging.client.Logger;
import com.avaya.ustore.CommonDBUtils;
import com.avaya.ustore.client.objectapi.ContactPhoneData;
import com.avaya.ustore.client.objectapi.HandleInfo;
import com.avaya.ustore.client.objectapi.PostalAddress;
import com.avaya.ustore.objectapi.AddressData;
import com.avaya.ustore.objectapi.AddressDataDTO;
import com.avaya.ustore.objectapi.ContactListMemberData;
import com.avaya.ustore.objectapi.HandleData;
import com.avaya.ustore.objectapi.HandleDataKey;
import com.avaya.ustore.objectapi.StationData;
import com.avaya.ustore.objectapi.UserData;
import com.avaya.ustore.objectapi.UstoreContactRecord;
import com.avaya.ustore.smgr.common.NameValuePair;
import com.avaya.ustore.smgr.common.UStoreContactType;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ContactData {
    private static final Logger log = AsmLogger.getLogger(ContactData.class);
    private String address = null;
    private String fullNameLocal = null;
    private String firstNameLocal = null;
    private String lastNameLocal = null;
    private String preferredLanguage = null;
    private String fullNameAscii = null;
    private String firstNameAscii = null;
    private String lastNameAscii = null;
    private String alias = null;
    private String contactId;
    private String contactGroup;
    private String emailAddress = null;
    private String imAddress = null;
    private String notes;
    private boolean isBuddy = false;
    private boolean videoCapable = false;
    private List<ContactPhoneData> contactPhonesList = new ArrayList<ContactPhoneData>();
    private List<NameValuePair> endpointDataList;
    private List<HandleInfo> handlesList = new ArrayList<HandleInfo>();
    private String manager = null;
    private String pictureUrl;
    private boolean favourite = false;
    private boolean instantConnection = false;
    private List<PostalAddress> addressList = new ArrayList<PostalAddress>();
    private List<NameValuePair> serviceDataList;
    private String smgrLoginName = null;
    static CommonDBUtils dbUtils = null;
    private static List<Long> validPhoneAndSipCpdTypeIds;
    private static final String sip = "sip";
    private static final String phone = "phone";
    private static List<Long> validEmailCpdTypeIds;
    private static final String email = "smtp";
    private static List<Long> validImCpdTypeIds;
    private static final String im = "xmpp";
    private static List<Long> validSipHandleTypeIds;
    private static final String NO_MATCH_FOUND = "NoNatchFound";
    private static Long clmCshandleId;
    private static Long clmCscontactaddressId;
    private static boolean clmIsSpeedDial;

    public void init(PostgresConnectionInfo pConnInfo) {
        String fcn_name = "init";
        try {
            dbUtils = new CommonDBUtils(pConnInfo);
            dbUtils.getSpecificCpdTypes("cscontacttypeenum ");
            dbUtils.getSpecificCpdTypes("cscontactcategoryenum ");
            dbUtils.getSpecificCpdTypes("cshandletypeenum ");
            dbUtils.getSpecificCpdTypes("cshandlesubtypeenum ");
            ArrayList<String> validCpdTypesStrings = new ArrayList<String>();
            validCpdTypesStrings.add(sip);
            validCpdTypesStrings.add(phone);
            validPhoneAndSipCpdTypeIds = dbUtils.getSpecificCpdTypeIds(validCpdTypesStrings);
            validCpdTypesStrings = new ArrayList();
            validCpdTypesStrings.add(email);
            validEmailCpdTypeIds = dbUtils.getSpecificCpdTypeIds(validCpdTypesStrings);
            validCpdTypesStrings = new ArrayList();
            validCpdTypesStrings.add(im);
            validImCpdTypeIds = dbUtils.getSpecificCpdTypeIds(validCpdTypesStrings);
            ArrayList<String> validHandleTypesStrings = new ArrayList<String>();
            validHandleTypesStrings.add(sip);
            validSipHandleTypeIds = dbUtils.getSpecificHandleTypeIds(validHandleTypesStrings);
            log.info((Object)("init: validPhoneAndSipCpdTypeIds: " + validPhoneAndSipCpdTypeIds.toString() + ": validEmailCpdTypeIds: " + validEmailCpdTypeIds.toString() + ": validImCpdTypeIds: " + validImCpdTypeIds.toString() + ": validSipHandleTypeIds: " + validSipHandleTypeIds.toString()));
        }
        catch (SQLException sqle) {
            log.error((Object)("init: SQL exception occurred during the type lists setup: " + sqle));
        }
    }

    public ContactData(UstoreContactRecord uCR, PostgresConnectionInfo pConnInfo) throws DMException {
        if (dbUtils == null) {
            this.init(pConnInfo);
        }
        this.createContactData(uCR);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createContactData(UstoreContactRecord uCR) {
        Map<Long, List<ContactAddress>> contactAddressMap;
        String fcn_name = "ContactData - createContactData";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        UserData userData = null;
        StationData stationData = null;
        String extension = null;
        long nanos = 0L;
        if (isFinest) {
            nanos = System.nanoTime();
        }
        try {
            if (uCR.getType().equals(UStoreContactType.INTERNAL.getUstoreContactType())) {
                userData = dbUtils.getCsUserInfo(uCR.getCsuserId());
                if (userData == null) {
                    String msg = ": Internal contact, no userData was found for csuserId: " + uCR.getCsuserId() + " and contactId: " + uCR.getKey().getId() + ", this is most likely a 'hard' deleted Enterprise user.";
                    log.warn((Object)("ContactData - createContactData" + msg));
                    return;
                }
                if (!userData.isUserIsDeleted()) {
                    if (isFinest) {
                        log.finest((Object)("ContactData - createContactData: Internal contact, userData found for csuserId: " + uCR.getCsuserId() + ": " + userData));
                    }
                } else {
                    this.address = "";
                    String msg = ": Internal contact, userData found for csuserId: " + uCR.getCsuserId() + ": " + userData + ", but since this user is soft deleted, we set the address field to the empty string so it will be ignored.";
                    if (isFiner) {
                        log.finer((Object)("ContactData - createContactData" + msg));
                    }
                    return;
                }
                stationData = dbUtils.getStationDataFromCsUserId(uCR.getCsuserId());
                if (isFinest) {
                    log.finest((Object)("ContactData - createContactData: Internal contact, stationData found for csuserId: " + uCR.getCsuserId() + ": " + stationData));
                }
            } else if (uCR.getType().equals(UStoreContactType.PUBLIC.getUstoreContactType())) {
                userData = dbUtils.getCsContactInfo(uCR.getCscontactId());
                if (isFinest) {
                    log.finest((Object)("ContactData - createContactData: Public contact, userData found for cscontactId: " + uCR.getCscontactId() + ": " + userData));
                }
            } else if (isFinest) {
                log.finest((Object)"ContactData - createContactData: External contact, no userData found.");
            }
            if (userData != null) {
                this.fullNameLocal = ContactUtils.removeStubName(uCR.getDisplayNameLocal() == null ? userData.getDisplayName() : uCR.getDisplayNameLocal());
                this.firstNameLocal = ContactUtils.removeStubName(uCR.getFirstNameLocal() == null ? userData.getGivenName() : uCR.getFirstNameLocal());
                this.lastNameLocal = ContactUtils.removeStubName(uCR.getLastNameLocal() == null ? userData.getSurname() : uCR.getLastNameLocal());
                this.preferredLanguage = uCR.getPreferredLanguage() == null ? userData.getPreferredLanguage() : uCR.getPreferredLanguage();
                this.fullNameAscii = ContactUtils.removeStubName(uCR.getDisplayNameAscii() == null ? userData.getDisplayNameAscii() : uCR.getDisplayNameAscii());
                this.firstNameAscii = ContactUtils.removeStubName(uCR.getFirstNameAscii() == null ? userData.getGivenNameAscii() : uCR.getFirstNameAscii());
                this.lastNameAscii = ContactUtils.removeStubName(uCR.getLastNameAscii() == null ? userData.getSurnameAscii() : uCR.getLastNameAscii());
                this.manager = uCR.getManager() == null ? userData.getManagerName() : uCR.getManager();
                this.smgrLoginName = userData.getSmgrLoginName();
            } else {
                this.fullNameLocal = ContactUtils.removeStubName(uCR.getDisplayNameLocal());
                this.firstNameLocal = ContactUtils.removeStubName(uCR.getFirstNameLocal());
                this.lastNameLocal = ContactUtils.removeStubName(uCR.getLastNameLocal());
                this.preferredLanguage = uCR.getPreferredLanguage();
                this.fullNameAscii = ContactUtils.removeStubName(uCR.getDisplayNameAscii());
                this.firstNameAscii = ContactUtils.removeStubName(uCR.getFirstNameAscii());
                this.lastNameAscii = ContactUtils.removeStubName(uCR.getLastNameAscii());
                this.manager = uCR.getManager();
                this.smgrLoginName = null;
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)("ContactData - createContactData: SQL exception occurred during retrieval of various contact data: " + sqle));
        }
        catch (DMException dme) {
            log.warn((Object)("ContactData - createContactData: DataMgr exception occurred during retrieval of various contact data: " + dme));
        }
        try {
            if (isFinest) {
                log.finest((Object)("ContactData - createContactData: uCR.getAlias(): " + uCR.getAlias() + ", uCR.getCsuserId(): " + uCR.getCsuserId() + ", uCR.getCscontactId(): " + uCR.getCscontactId() + (userData == null ? "" : ", userData.getPreferredGivenName(): " + userData.getPreferredGivenName())));
            }
            if (uCR.getAlias() != null) {
                this.alias = uCR.getAlias();
            }
            if (this.alias == null && uCR.getCsuserId() != null) {
                this.alias = dbUtils.getAliasFromCsPrivateContactInfo(uCR.getKey().getOwnerCsuserId(), uCR.getCsuserId());
            }
            if (this.alias == null && uCR.getCscontactId() != null && userData != null) {
                this.alias = userData.getPreferredGivenName();
            }
            if (isFinest) {
                log.finest((Object)("ContactData - createContactData: alias: " + this.alias));
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)("ContactData - createContactData: SQL exception occurred during retrieval of the contact's alias: " + sqle));
        }
        catch (DMException dme) {
            log.warn((Object)("ContactData - createContactData: DataMgr exception occurred during retrieval of contact's alias: " + dme));
        }
        this.contactId = uCR.getKey().getId().toString();
        this.contactGroup = "N/A";
        this.notes = uCR.getNotes();
        try {
            ContactListMemberData clmData = dbUtils.getClmInfoForContact(uCR.getCscontactlistmemberId());
            if (clmData != null) {
                this.isBuddy = clmData.isIspresencebuddy();
                this.favourite = clmData.isIsfavourite();
                clmCscontactaddressId = clmData.getCscontactaddressid();
                clmCshandleId = clmData.getCshandleid();
                clmIsSpeedDial = clmData.isIsspeeddial();
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)("ContactData - createContactData: A SQL exception occurred while retrieving the cscontactlistmember data: " + sqle));
        }
        catch (DMException dme) {
            log.warn((Object)("ContactData - createContactData: DataMgr exception occurred retrieving the cscontactlistmember data: " + dme));
        }
        if (stationData != null) {
            this.videoCapable = stationData.isVideoCapable();
        }
        ArrayList<Long> contactIdList = new ArrayList<Long>();
        ArrayList<Long> pciIdList = new ArrayList<Long>();
        if (uCR.getCscontactId() != null) {
            contactIdList.add(uCR.getCscontactId());
        }
        if (uCR.getCsprivatecontactinfoId() != null) {
            pciIdList.add(uCR.getCsprivatecontactinfoId());
        }
        ContactAddressLists cALists = new ContactAddressLists();
        try {
            cALists = dbUtils.getAllContactAddressesForContact(contactIdList, pciIdList);
        }
        catch (SQLException sqle) {
            log.warn((Object)("ContactData - createContactData: SQL exception occurred during the retrieving of contact addresses: " + sqle));
        }
        if (cALists.getCscontactList() != null && !cALists.getCscontactList().isEmpty()) {
            contactAddressMap = cALists.getCscontactList();
            for (Map.Entry<Long, List<ContactAddress>> entry : contactAddressMap.entrySet()) {
                this.processContactAddressList(entry.getValue(), uCR);
            }
        }
        if (cALists.getPciList() != null && !cALists.getPciList().isEmpty()) {
            contactAddressMap = cALists.getPciList();
            for (Map.Entry<Long, List<ContactAddress>> entry : contactAddressMap.entrySet()) {
                this.processContactAddressList(entry.getValue(), uCR);
            }
        }
        this.endpointDataList = this.createDataList(uCR.getEndpointData());
        SipUriFormatter sipUriFormatter = null;
        String ppmAddress = uCR.getPpmAddress();
        if (isFinest) {
            log.finest((Object)("ContactData - createContactData: uCR.getCsuserId: " + uCR.getCsuserId() + ", ppmAddress: " + ppmAddress));
        }
        this.address = ppmAddress;
        if (uCR.getCsuserId() != null) {
            List<Object> handleDataListFromPostgres = new ArrayList();
            boolean searchForEmailAddress = this.emailAddress == null;
            Long emailDbIndex = Long.MAX_VALUE;
            boolean searchForImAddress = this.imAddress == null;
            Long imDbIndex = Long.MAX_VALUE;
            try {
                Map<Long, String> csDomains = dbUtils.getAllCsDomains();
                handleDataListFromPostgres = dbUtils.getAllHandlesForContact(uCR.getCsuserId());
                if (isFinest) {
                    log.finest((Object)("ContactData - createContactData: handleDataListFromPostgres: " + handleDataListFromPostgres.toString()));
                }
                Map<HandleDataKey, HandleData> handleDataMapFromCassandra = uCR.getHandleData();
                String domainForPpmAddress = null;
                if (stationData != null) {
                    extension = stationData.getStationExtension();
                }
                for (CsHandle csHandle : handleDataListFromPostgres) {
                    if (csHandle == null) continue;
                    if (isFinest) {
                        log.finest((Object)("ContactData - createContactData: handleDataFromPostgres: " + csHandle.toString()));
                    }
                    HandleInfo handleInfo = null;
                    String handle = csHandle.getHandle();
                    if (ppmAddress != null && !ppmAddress.contains("@") && handle.equals(ppmAddress)) {
                        domainForPpmAddress = csDomains.get(csHandle.getCsDomainId());
                    }
                    sipUriFormatter = new SipUriFormatter(null, handle, handle.contains("@") && !csDomains.get(csHandle.getCsDomainId()).equals("__foreign__") ? "__foreign__" : csDomains.get(csHandle.getCsDomainId()), null);
                    if (validSipHandleTypeIds.contains(csHandle.getCsHandleTypeId())) {
                        UriUtils.normalizeSipURIWithoutScheme(sipUriFormatter, "__foreign__");
                        HandleData handleDataValueFromCassandra = this.findMatchingHandleDataFromCassandra(csHandle.getId(), handleDataMapFromCassandra);
                        Map<String, String> srvDataMap = null;
                        String label1 = null;
                        String label2 = null;
                        Boolean speedDial = null;
                        if (clmIsSpeedDial && clmCshandleId != null && clmCshandleId.equals(csHandle.getId())) {
                            speedDial = true;
                        }
                        if (handleDataValueFromCassandra != null) {
                            srvDataMap = handleDataValueFromCassandra.getServiceData();
                            label1 = handleDataValueFromCassandra.getLabel1();
                            label2 = handleDataValueFromCassandra.getLabel2();
                            if (isFinest) {
                                log.finest((Object)("ContactData - createContactData: handleDataValueFromCassandra: " + handleDataValueFromCassandra));
                            }
                        } else if (isFinest) {
                            log.finest((Object)"ContactData - createContactData: handleDataValueFromCassandra: null ");
                        }
                        String primaryNumber = uCR.getPrimaryNumber();
                        SipUriFormatter primaryNumberURI = new SipUriFormatter(primaryNumber);
                        boolean primaryNumberMatch = false;
                        String category = null;
                        SipUriFormatter handleUri = new SipUriFormatter(handle);
                        if (UriUtils.equalSipURI(primaryNumberURI, sipUriFormatter) || UriUtils.equalSipURI(primaryNumberURI, handleUri)) {
                            primaryNumberMatch = true;
                        } else if (UriUtils.isValidData(primaryNumber) && UriUtils.isValidData(handle) && primaryNumber.equals(handle)) {
                            primaryNumberMatch = true;
                        }
                        String phoneNumber = sipUriFormatter.getUri();
                        if (primaryNumberMatch) {
                            category = primaryNumber;
                        }
                        if (isFinest) {
                            log.finest((Object)("ContactData - createContactData: phoneNumber: " + phoneNumber + ", primaryNumber: " + primaryNumber));
                        }
                        if (isFinest) {
                            log.finest((Object)("ContactData - createContactData: handle type id: " + csHandle.getCsHandleTypeId() + ", handle type name: " + dbUtils.getSpecificHandleTypeName(csHandle.getCsHandleTypeId())));
                        }
                        ContactPhoneData cPData = new ContactPhoneData(phoneNumber, label1 != null ? label1 : null, label2 != null ? label2 : null, category, ContactUtils.getContactType("", dbUtils.getSpecificHandleTypeName(csHandle.getCsHandleTypeId())).toString(), speedDial != null ? speedDial : false, this.createDataList(srvDataMap));
                        this.contactPhonesList.add(cPData);
                        if (isFinest) {
                            log.finest((Object)("ContactData - createContactData: handle data: " + cPData + " was added to the contactPhonesList"));
                        }
                        if (extension != null && !extension.isEmpty() && !sipUriFormatter.getUser().equals(extension)) {
                            sipUriFormatter.setParameters("avext=" + extension);
                        }
                    } else {
                        UriUtils.normalizeURI(sipUriFormatter, "__foreign__");
                        if (isFinest) {
                            log.finest((Object)("ContactData - createContactData: handle: " + handle + " was not added to the contactPhonesList"));
                        }
                    }
                    handleInfo = new HandleInfo(sipUriFormatter.getUri(), dbUtils.getSpecificHandleTypeName(csHandle.getCsHandleTypeId()), dbUtils.getSpecificHandleSubtypeName(csHandle.getCsHandleSubTypeId()));
                    this.handlesList.add(handleInfo);
                    if (isFinest) {
                        log.finest((Object)("ContactData - createContactData: handleInfo: " + handleInfo + " was added to the handlesList"));
                    }
                    if (isFinest) {
                        log.finest((Object)("ContactData - createContactData: emailDbIndex: " + emailDbIndex + ", imDbIndex: " + imDbIndex));
                    }
                    if (searchForEmailAddress) {
                        if (validEmailCpdTypeIds.contains(csHandle.getCsHandleTypeId())) {
                            emailDbIndex = this.findAddressWithTheLowestDbId(sipUriFormatter.getUri(), emailDbIndex, "Email", csHandle.getId());
                        } else if (isFinest) {
                            log.finest((Object)("ContactData - createContactData: this handle is not an email address: " + handle));
                        }
                    }
                    if (!searchForImAddress) continue;
                    XmppUriFormatter xmppUriFormatter = new XmppUriFormatter(handle);
                    xmppUriFormatter.setScheme(null);
                    if (validImCpdTypeIds.contains(csHandle.getCsHandleTypeId())) {
                        imDbIndex = this.findAddressWithTheLowestDbId(xmppUriFormatter.getUri(), imDbIndex, "IM", csHandle.getId());
                        continue;
                    }
                    if (!isFinest) continue;
                    log.finest((Object)("ContactData - createContactData: this handle is not an IM address: " + handle));
                }
                if (isFinest) {
                    log.finest((Object)"ContactData - createContactData: done searching for email and IM addresses ");
                }
            }
            catch (SQLException sqle) {
                log.warn((Object)("ContactData - createContactData: A problem occurred while getting domains or handles: " + sqle));
            }
        } else if (isFinest) {
            log.finest((Object)"ContactData - createContactData: This is not an Enterprise user.");
        }
        if (isFinest) {
            log.finest((Object)("ContactData - createContactData: handlesList: " + this.handlesList.toString() + ", this.address: " + this.address));
        }
        this.pictureUrl = uCR.getPictureUrl();
        this.instantConnection = uCR.isInstantConnection();
        try {
            Map<String, AddressData> addressDataMapFromPostgres = null;
            if (uCR.getType().equals(UStoreContactType.INTERNAL.getUstoreContactType())) {
                addressDataMapFromPostgres = dbUtils.getCsAddressInfo(uCR.getCsuserId(), true);
            } else if (uCR.getType().equals(UStoreContactType.EXTERNAL.getUstoreContactType()) || uCR.getType().equals(UStoreContactType.PUBLIC.getUstoreContactType())) {
                addressDataMapFromPostgres = dbUtils.getCsAddressInfo(uCR.getCscontactId(), false);
            }
            Map<String, AddressData> addressDataMapFromCassandra = uCR.getAddressData();
            if (isFinest) {
                log.finest((Object)("ContactData - createContactData: addressDataMapFromPostgres: " + addressDataMapFromPostgres.toString() + ": addressDataMapFromCassandra: " + addressDataMapFromCassandra.toString()));
            }
            PostalAddress postalAddress = null;
            for (String addressDataKeyFromCassandra : addressDataMapFromCassandra.keySet()) {
                AddressData addressDataValueFromCassandra = addressDataMapFromCassandra.get(addressDataKeyFromCassandra);
                if (addressDataValueFromCassandra == null) {
                    log.finest((Object)"ContactData - createContactData: addressDataValueFromCassandra was null ");
                    continue;
                }
                AddressDataDTO addressDataFromPostgresDTO = this.findMatchingAddressData(addressDataValueFromCassandra.getCsaddressId(), addressDataMapFromPostgres);
                if (!addressDataFromPostgresDTO.getAddressName().equals(NO_MATCH_FOUND)) {
                    postalAddress = new PostalAddress(addressDataKeyFromCassandra != null ? addressDataKeyFromCassandra : addressDataFromPostgresDTO.getAddressName(), addressDataValueFromCassandra.getStreetAddress() != null ? addressDataValueFromCassandra.getStreetAddress() : addressDataFromPostgresDTO.getAddressData().getStreetAddress(), addressDataValueFromCassandra.getCompany() != null ? addressDataValueFromCassandra.getCompany() : addressDataFromPostgresDTO.getAddressData().getCompany(), addressDataValueFromCassandra.getLocation() != null ? addressDataValueFromCassandra.getLocation() : addressDataFromPostgresDTO.getAddressData().getLocation(), addressDataValueFromCassandra.getCity() != null ? addressDataValueFromCassandra.getCity() : addressDataFromPostgresDTO.getAddressData().getCity(), addressDataValueFromCassandra.getState() != null ? addressDataValueFromCassandra.getState() : addressDataFromPostgresDTO.getAddressData().getState(), addressDataValueFromCassandra.getCountry() != null ? addressDataValueFromCassandra.getCountry() : addressDataFromPostgresDTO.getAddressData().getCountry(), addressDataValueFromCassandra.getPostalCode() != null ? addressDataValueFromCassandra.getPostalCode() : addressDataFromPostgresDTO.getAddressData().getPostalCode(), addressDataValueFromCassandra.getDepartment() != null ? addressDataValueFromCassandra.getDepartment() : addressDataFromPostgresDTO.getAddressData().getDepartment(), addressDataValueFromCassandra.getWorkRoomNo() != null ? addressDataValueFromCassandra.getWorkRoomNo() : addressDataFromPostgresDTO.getAddressData().getWorkRoomNo(), this.createDataList(addressDataValueFromCassandra.getServiceData()));
                    addressDataMapFromPostgres.remove(addressDataFromPostgresDTO.getAddressName());
                } else {
                    postalAddress = new PostalAddress(addressDataKeyFromCassandra, addressDataValueFromCassandra.getStreetAddress(), addressDataValueFromCassandra.getCompany(), addressDataValueFromCassandra.getLocation(), addressDataValueFromCassandra.getCity(), addressDataValueFromCassandra.getState(), addressDataValueFromCassandra.getCountry(), addressDataValueFromCassandra.getPostalCode(), addressDataValueFromCassandra.getDepartment(), addressDataValueFromCassandra.getWorkRoomNo(), this.createDataList(addressDataValueFromCassandra.getServiceData()));
                }
                this.addressList.add(postalAddress);
            }
            for (String addressDataKeyFromPostgres : addressDataMapFromPostgres.keySet()) {
                AddressData addressDataValueFromPostgres = addressDataMapFromPostgres.get(addressDataKeyFromPostgres);
                if (addressDataValueFromPostgres == null) {
                    log.finest((Object)"ContactData - createContactData: addressDataValueFromPostgres was null ");
                    continue;
                }
                postalAddress = new PostalAddress(addressDataKeyFromPostgres, addressDataValueFromPostgres.getStreetAddress(), addressDataValueFromPostgres.getCompany(), addressDataValueFromPostgres.getLocation(), addressDataValueFromPostgres.getCity(), addressDataValueFromPostgres.getState(), addressDataValueFromPostgres.getCountry(), addressDataValueFromPostgres.getPostalCode(), addressDataValueFromPostgres.getDepartment(), addressDataValueFromPostgres.getWorkRoomNo(), this.createDataList(addressDataValueFromPostgres.getServiceData()));
                this.addressList.add(postalAddress);
            }
            if (isFinest) {
                log.finest((Object)("ContactData - createContactData: addressList: " + this.addressList.toString()));
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)("ContactData - createContactData: A problem occurred while getting the address data from Postgres: " + sqle));
        }
        this.serviceDataList = this.createDataList(uCR.getServiceData());
        if (isFinest) {
            log.finest((Object)("ContactData - createContactData: processing contactlistmemberid: " + uCR.getCscontactlistmemberId() + " took " + String.format("%.3f", (double)(System.nanoTime() - nanos) / 1000000.0) + " milliseconds"));
        }
        if (isFiner) {
            log.finer((Object)("ContactData - createContactData: leave with ContactData: " + this));
        }
    }

    private void processContactAddressList(List<ContactAddress> contactAddressList, UstoreContactRecord uCR) {
        String fcn_name = "processContactAddressList";
        boolean isFinest = log.isFinestEnabled();
        boolean searchForEmailAddress = this.emailAddress == null;
        long emailDbIndex = Long.MAX_VALUE;
        boolean searchForImAddress = this.imAddress == null;
        long imDbIndex = Long.MAX_VALUE;
        Map<HandleDataKey, HandleData> handleDataMapFromCassandra = uCR.getHandleData();
        for (ContactAddress contactAddress : contactAddressList) {
            if (contactAddress == null) continue;
            if (isFinest) {
                log.finest((Object)("processContactAddressList: contactAddress: " + contactAddress + ": validPhoneAndSipCpdTypeIds: " + validPhoneAndSipCpdTypeIds.toString()));
            }
            HandleData handleDataValueFromCassandra = this.findMatchingContactAddressDataFromCassandra(contactAddress.getId(), handleDataMapFromCassandra);
            Map<String, String> srvDataMap = null;
            String label1 = null;
            String label2 = null;
            Boolean speedDial = null;
            if (clmIsSpeedDial && clmCscontactaddressId != null && clmCscontactaddressId.equals(contactAddress.getId())) {
                speedDial = true;
            }
            if (handleDataValueFromCassandra != null) {
                if (isFinest) {
                    log.finest((Object)("processContactAddressList: handleDataValueFromCassandra: " + handleDataValueFromCassandra));
                }
                srvDataMap = handleDataValueFromCassandra.getServiceData();
                label1 = handleDataValueFromCassandra.getLabel1();
                label2 = handleDataValueFromCassandra.getLabel2();
            } else if (isFinest) {
                log.finest((Object)"processContactAddressList: handleDataValueFromCassandra: null ");
            }
            SipUriFormatter sipUriFormatter = new SipUriFormatter(contactAddress.getAddress());
            UriUtils.normalizeSipURIWithoutScheme(sipUriFormatter, null);
            String phoneNumber = null;
            if (validPhoneAndSipCpdTypeIds.contains(contactAddress.getTypeid().longValue())) {
                phoneNumber = sipUriFormatter.getUri();
                String primaryNumber = uCR.getPrimaryNumber();
                SipUriFormatter primaryNumberURI = new SipUriFormatter(primaryNumber);
                UriUtils.normalizeSipURIWithoutScheme(primaryNumberURI, null);
                if (isFinest) {
                    log.finest((Object)("processContactAddressList: phoneNumber: " + phoneNumber + ", primaryNumber: " + primaryNumber));
                    if (isFinest) {
                        log.finest((Object)("processContactAddressList: phoneNumberURI: " + sipUriFormatter + ", primaryNumberURI: " + primaryNumberURI));
                    }
                }
                if (phoneNumber != null && phoneNumber.startsWith("ep__")) {
                    log.finest((Object)"processContactAddressList: Skip this phoneNumber because it starts with an ep__ and is not dialable.");
                    continue;
                }
                if (isFinest) {
                    log.finest((Object)("processContactAddressList: address type id: " + contactAddress.getTypeid() + ", address type name: " + dbUtils.getSpecificContactAddressTypeName(contactAddress.getTypeid().longValue()).toString()));
                }
                boolean primaryNumberMatch = false;
                String category = null;
                if (UriUtils.equalSipURI(primaryNumberURI, sipUriFormatter)) {
                    primaryNumberMatch = true;
                } else if (UriUtils.isValidData(primaryNumber) && UriUtils.isValidData(phoneNumber) && primaryNumber.equals(phoneNumber)) {
                    primaryNumberMatch = true;
                }
                if (primaryNumberMatch) {
                    category = primaryNumber;
                }
                ContactPhoneData cPData = new ContactPhoneData(phoneNumber, label1 != null ? label1 : contactAddress.getLabel(), label2 != null ? label2 : contactAddress.getAltlabel(), category, ContactUtils.getContactType(dbUtils.getSpecificContactAddressCategoryName(contactAddress.getCategoryid().longValue()), dbUtils.getSpecificContactAddressTypeName(contactAddress.getTypeid().longValue())).toString(), speedDial != null ? speedDial : false, this.createDataList(srvDataMap));
                this.contactPhonesList.add(cPData);
                if (isFinest) {
                    log.finest((Object)("processContactAddressList: contact address: " + phoneNumber + " was added to the contactPhonesList as " + cPData));
                }
            } else if (isFinest) {
                log.finest((Object)("processContactAddressList: contact address: " + phoneNumber + " was not added to the contactPhonesList"));
            }
            if (isFinest) {
                log.finest((Object)("processContactAddressList: emailDbIndex: " + emailDbIndex + ", imDbIndex: " + imDbIndex));
            }
            if (searchForEmailAddress) {
                if (validEmailCpdTypeIds.contains(contactAddress.getTypeid().longValue())) {
                    emailDbIndex = this.findAddressWithTheLowestDbId(sipUriFormatter.getUri(), emailDbIndex, "Email", contactAddress.getId());
                } else if (isFinest) {
                    log.finest((Object)("processContactAddressList: this contact address is not an email address: " + phoneNumber));
                }
            }
            if (!searchForImAddress) continue;
            XmppUriFormatter xmppUriFormatter = new XmppUriFormatter(contactAddress.getAddress());
            xmppUriFormatter.setScheme(null);
            if (validImCpdTypeIds.contains(contactAddress.getTypeid().longValue())) {
                imDbIndex = this.findAddressWithTheLowestDbId(xmppUriFormatter.getUri(), imDbIndex, "IM", contactAddress.getId());
                continue;
            }
            if (!isFinest) continue;
            log.finest((Object)("processContactAddressList: this contact address is not an IM address: " + phoneNumber));
        }
    }

    private List<NameValuePair> createDataList(Map<String, String> dataMap) {
        ArrayList<NameValuePair> dataList = null;
        if (dataMap != null) {
            NameValuePair nVP = new NameValuePair();
            dataList = new ArrayList<NameValuePair>();
            for (Map.Entry<String, String> entry : dataMap.entrySet()) {
                nVP.setName(entry.getKey());
                nVP.setValue(entry.getValue());
                dataList.add(nVP);
                nVP = new NameValuePair();
            }
        }
        return dataList;
    }

    private HandleData findMatchingHandleDataFromCassandra(long cshandleIdFromPostgres, Map<HandleDataKey, HandleData> handleDataMapFromCassandra) {
        String fcn_name = "findMatchingHandleDataFromCassandra";
        boolean isFinest = log.isFinestEnabled();
        for (HandleDataKey handleDataKeyFromCassandra : handleDataMapFromCassandra.keySet()) {
            Long csHandleId;
            HandleData handleDataValueFromCassandra = handleDataMapFromCassandra.get(handleDataKeyFromCassandra);
            if (handleDataValueFromCassandra == null) continue;
            if (isFinest) {
                log.finest((Object)("findMatchingHandleDataFromCassandra: handleDataValueFromCassandra.getCshandleId(): " + handleDataValueFromCassandra.getCshandleId() + ", cshandleIdFromPostgres: " + cshandleIdFromPostgres));
            }
            if ((csHandleId = handleDataValueFromCassandra.getCshandleId()) == null || !csHandleId.equals(cshandleIdFromPostgres)) continue;
            if (isFinest) {
                log.finest((Object)"findMatchingHandleDataFromCassandra: returning handleDataValueFromCassandra ");
            }
            return handleDataValueFromCassandra;
        }
        return null;
    }

    private HandleData findMatchingContactAddressDataFromCassandra(long cscontactaddressIdFromPostgres, Map<HandleDataKey, HandleData> handleDataMapFromCassandra) {
        String fcn_name = "findMatchingContactAddressDataFromCassandra";
        boolean isFinest = log.isFinestEnabled();
        for (HandleDataKey handleDataKeyFromCassandra : handleDataMapFromCassandra.keySet()) {
            Long cscontactaddressId;
            HandleData handleDataValueFromCassandra = handleDataMapFromCassandra.get(handleDataKeyFromCassandra);
            if (handleDataValueFromCassandra == null) continue;
            if (isFinest) {
                log.finest((Object)("findMatchingContactAddressDataFromCassandra: handleDataValueFromCassandra.getCscontactaddressId(): " + handleDataValueFromCassandra.getCscontactaddressId() + ", cscontactaddressIdFromPostgres: " + cscontactaddressIdFromPostgres));
            }
            if ((cscontactaddressId = handleDataValueFromCassandra.getCscontactaddressId()) == null || !cscontactaddressId.equals(cscontactaddressIdFromPostgres)) continue;
            if (isFinest) {
                log.finest((Object)"findMatchingContactAddressDataFromCassandra: returning handleDataValueFromCassandra ");
            }
            return handleDataValueFromCassandra;
        }
        return null;
    }

    private AddressDataDTO findMatchingAddressData(long csaddressIdFromCassandra, Map<String, AddressData> addressDataMapFromPostgres) {
        for (String addressDataKeyFromPostgres : addressDataMapFromPostgres.keySet()) {
            AddressData addressDataValueFromPostgres = addressDataMapFromPostgres.get(addressDataKeyFromPostgres);
            if (addressDataValueFromPostgres.getCsaddressId() != csaddressIdFromCassandra) continue;
            return new AddressDataDTO(addressDataKeyFromPostgres, addressDataValueFromPostgres);
        }
        return new AddressDataDTO(NO_MATCH_FOUND, new AddressData(null, null, null, null, null, null, null, null, null, null, null));
    }

    private Long findAddressWithTheLowestDbId(String address, long currentLowestDBId, String addressType, long dbIdForAddress) {
        String fcn_name = "findAddressWithTheLowestDbId";
        boolean isFiner = log.isFinerEnabled();
        boolean isFinest = log.isFinestEnabled();
        if (isFiner) {
            log.finer((Object)("findAddressWithTheLowestDbId: entered with " + addressType + " address: " + address + ", the current lowest DB id: " + currentLowestDBId + ", the DB id for this address: " + dbIdForAddress));
        }
        if (dbIdForAddress < currentLowestDBId) {
            if (addressType.equals("IM")) {
                this.imAddress = address;
            } else {
                this.emailAddress = address;
            }
            currentLowestDBId = dbIdForAddress;
            if (isFinest) {
                log.finest((Object)("findAddressWithTheLowestDbId: this address is the lowest DB id " + addressType + " address: " + this.emailAddress + " so far. "));
            }
            if (isFinest) {
                log.finest((Object)("findAddressWithTheLowestDbId: " + addressType + "DbIndex will be updated to: " + currentLowestDBId));
            }
        } else if (isFinest) {
            log.finest((Object)("findAddressWithTheLowestDbId: this address is not the lowest DB id " + addressType + " address: " + address + " so far. "));
        }
        if (isFiner) {
            log.finer((Object)"findAddressWithTheLowestDbId: leave");
        }
        return currentLowestDBId;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getFullNameLocal() {
        return this.fullNameLocal;
    }

    public void setFullNameLocal(String fullNameLocal) {
        this.fullNameLocal = fullNameLocal;
    }

    public String getFirstNameLocal() {
        return this.firstNameLocal;
    }

    public void setFirstNameLocal(String firstNameLocal) {
        this.firstNameLocal = firstNameLocal;
    }

    public String getLastNameLocal() {
        return this.lastNameLocal;
    }

    public void setLastNameLocal(String lastNameLocal) {
        this.lastNameLocal = lastNameLocal;
    }

    public String getPreferredLanguage() {
        return this.preferredLanguage;
    }

    public void setPreferredLanguage(String preferredLanguage) {
        this.preferredLanguage = preferredLanguage;
    }

    public String getFullNameAscii() {
        return this.fullNameAscii;
    }

    public void setFullNameAscii(String fullNameAscii) {
        this.fullNameAscii = fullNameAscii;
    }

    public String getFirstNameAscii() {
        return this.firstNameAscii;
    }

    public void setFirstNameAscii(String firstNameAscii) {
        this.firstNameAscii = firstNameAscii;
    }

    public String getLastNameAscii() {
        return this.lastNameAscii;
    }

    public void setLastNameAscii(String lastNameAscii) {
        this.lastNameAscii = lastNameAscii;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getContactId() {
        return this.contactId;
    }

    public void setContactId(String contactId) {
        this.contactId = contactId;
    }

    public String getContactGroup() {
        return this.contactGroup;
    }

    public void setContactGroup(String contactGroup) {
        this.contactGroup = contactGroup;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getImAddress() {
        return this.imAddress;
    }

    public void setImAddress(String imAddress) {
        this.imAddress = imAddress;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public boolean isBuddy() {
        return this.isBuddy;
    }

    public void setBuddy(boolean isBuddy) {
        this.isBuddy = isBuddy;
    }

    public boolean isVideoCapable() {
        return this.videoCapable;
    }

    public void setVideoCapable(boolean videoCapable) {
        this.videoCapable = videoCapable;
    }

    public List<ContactPhoneData> getContactPhonesList() {
        return this.contactPhonesList;
    }

    public void setContactPhonesList(List<ContactPhoneData> contactPhonesList) {
        this.contactPhonesList = contactPhonesList;
    }

    public List<NameValuePair> getEndpointDataList() {
        return this.endpointDataList;
    }

    public void setEndpointDataList(List<NameValuePair> endpointDataList) {
        this.endpointDataList = endpointDataList;
    }

    public List<HandleInfo> getHandlesList() {
        return this.handlesList;
    }

    public void setHandlesList(List<HandleInfo> handlesList) {
        this.handlesList = handlesList;
    }

    public String getManager() {
        return this.manager;
    }

    public void setManager(String manager) {
        this.manager = manager;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public boolean isFavourite() {
        return this.favourite;
    }

    public void setFavourite(boolean favourite) {
        this.favourite = favourite;
    }

    public boolean isInstantConnection() {
        return this.instantConnection;
    }

    public void setInstantConnection(boolean instantConnection) {
        this.instantConnection = instantConnection;
    }

    public List<PostalAddress> getAddressList() {
        return this.addressList;
    }

    public void setAddressList(List<PostalAddress> addressList) {
        this.addressList = addressList;
    }

    public List<NameValuePair> getServiceDataList() {
        return this.serviceDataList;
    }

    public void setServiceDataList(List<NameValuePair> serviceDataList) {
        this.serviceDataList = serviceDataList;
    }

    public String getSmgrLoginName() {
        return this.smgrLoginName;
    }

    public void setSmgrLoginName(String smgrLoginName) {
        this.smgrLoginName = smgrLoginName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.addressList == null ? 0 : this.addressList.hashCode());
        result = 31 * result + (this.alias == null ? 0 : this.alias.hashCode());
        result = 31 * result + (this.contactGroup == null ? 0 : this.contactGroup.hashCode());
        result = 31 * result + (this.contactId == null ? 0 : this.contactId.hashCode());
        result = 31 * result + (this.contactPhonesList == null ? 0 : this.contactPhonesList.hashCode());
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        result = 31 * result + (this.endpointDataList == null ? 0 : this.endpointDataList.hashCode());
        result = 31 * result + (this.favourite ? 1231 : 1237);
        result = 31 * result + (this.firstNameAscii == null ? 0 : this.firstNameAscii.hashCode());
        result = 31 * result + (this.firstNameLocal == null ? 0 : this.firstNameLocal.hashCode());
        result = 31 * result + (this.fullNameAscii == null ? 0 : this.fullNameAscii.hashCode());
        result = 31 * result + (this.fullNameLocal == null ? 0 : this.fullNameLocal.hashCode());
        result = 31 * result + (this.handlesList == null ? 0 : this.handlesList.hashCode());
        result = 31 * result + (this.imAddress == null ? 0 : this.imAddress.hashCode());
        result = 31 * result + (this.instantConnection ? 1231 : 1237);
        result = 31 * result + (this.isBuddy ? 1231 : 1237);
        result = 31 * result + (this.lastNameAscii == null ? 0 : this.lastNameAscii.hashCode());
        result = 31 * result + (this.lastNameLocal == null ? 0 : this.lastNameLocal.hashCode());
        result = 31 * result + (this.manager == null ? 0 : this.manager.hashCode());
        result = 31 * result + (this.notes == null ? 0 : this.notes.hashCode());
        result = 31 * result + (this.pictureUrl == null ? 0 : this.pictureUrl.hashCode());
        result = 31 * result + (this.preferredLanguage == null ? 0 : this.preferredLanguage.hashCode());
        result = 31 * result + (this.serviceDataList == null ? 0 : this.serviceDataList.hashCode());
        result = 31 * result + (this.smgrLoginName == null ? 0 : this.smgrLoginName.hashCode());
        result = 31 * result + (this.videoCapable ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ContactData other = (ContactData)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.addressList == null ? other.addressList != null : !this.addressList.equals(other.addressList)) {
            return false;
        }
        if (this.alias == null ? other.alias != null : !this.alias.equals(other.alias)) {
            return false;
        }
        if (this.contactGroup == null ? other.contactGroup != null : !this.contactGroup.equals(other.contactGroup)) {
            return false;
        }
        if (this.contactId == null ? other.contactId != null : !this.contactId.equals(other.contactId)) {
            return false;
        }
        if (this.contactPhonesList == null ? other.contactPhonesList != null : !this.contactPhonesList.equals(other.contactPhonesList)) {
            return false;
        }
        if (this.emailAddress == null ? other.emailAddress != null : !this.emailAddress.equals(other.emailAddress)) {
            return false;
        }
        if (this.endpointDataList == null ? other.endpointDataList != null : !this.endpointDataList.equals(other.endpointDataList)) {
            return false;
        }
        if (this.favourite != other.favourite) {
            return false;
        }
        if (this.firstNameAscii == null ? other.firstNameAscii != null : !this.firstNameAscii.equals(other.firstNameAscii)) {
            return false;
        }
        if (this.firstNameLocal == null ? other.firstNameLocal != null : !this.firstNameLocal.equals(other.firstNameLocal)) {
            return false;
        }
        if (this.fullNameAscii == null ? other.fullNameAscii != null : !this.fullNameAscii.equals(other.fullNameAscii)) {
            return false;
        }
        if (this.fullNameLocal == null ? other.fullNameLocal != null : !this.fullNameLocal.equals(other.fullNameLocal)) {
            return false;
        }
        if (this.handlesList == null ? other.handlesList != null : !this.handlesList.equals(other.handlesList)) {
            return false;
        }
        if (this.imAddress == null ? other.imAddress != null : !this.imAddress.equals(other.imAddress)) {
            return false;
        }
        if (this.instantConnection != other.instantConnection) {
            return false;
        }
        if (this.isBuddy != other.isBuddy) {
            return false;
        }
        if (this.lastNameAscii == null ? other.lastNameAscii != null : !this.lastNameAscii.equals(other.lastNameAscii)) {
            return false;
        }
        if (this.lastNameLocal == null ? other.lastNameLocal != null : !this.lastNameLocal.equals(other.lastNameLocal)) {
            return false;
        }
        if (this.manager == null ? other.manager != null : !this.manager.equals(other.manager)) {
            return false;
        }
        if (this.notes == null ? other.notes != null : !this.notes.equals(other.notes)) {
            return false;
        }
        if (this.pictureUrl == null ? other.pictureUrl != null : !this.pictureUrl.equals(other.pictureUrl)) {
            return false;
        }
        if (this.preferredLanguage == null ? other.preferredLanguage != null : !this.preferredLanguage.equals(other.preferredLanguage)) {
            return false;
        }
        if (this.serviceDataList == null ? other.serviceDataList != null : !this.serviceDataList.equals(other.serviceDataList)) {
            return false;
        }
        if (this.smgrLoginName == null ? other.smgrLoginName != null : !this.smgrLoginName.equals(other.smgrLoginName)) {
            return false;
        }
        return this.videoCapable == other.videoCapable;
    }

    public String toString() {
        return "ContactData [address=" + this.address + ", fullNameLocal=" + this.fullNameLocal + ", firstNameLocal=" + this.firstNameLocal + ", lastNameLocal=" + this.lastNameLocal + ", preferredLanguage=" + this.preferredLanguage + ", fullNameAscii=" + this.fullNameAscii + ", firstNameAscii=" + this.firstNameAscii + ", lastNameAscii=" + this.lastNameAscii + ", alias=" + this.alias + ", contactId=" + this.contactId + ", contactGroup=" + this.contactGroup + ", emailAddress=" + this.emailAddress + ", imAddress=" + this.imAddress + ", notes=" + this.notes + ", isBuddy=" + this.isBuddy + ", videoCapable=" + this.videoCapable + ", contactPhonesList=" + this.contactPhonesList + ", endpointDataList=" + this.endpointDataList + ", handlesList=" + this.handlesList + ", manager=" + this.manager + ", pictureUrl=" + this.pictureUrl + ", favourite=" + this.favourite + ", instantConnection=" + this.instantConnection + ", addressList=" + this.addressList + ", serviceDataList=" + this.serviceDataList + ", smgrLoginName=" + this.smgrLoginName + "]";
    }

    static {
        clmCshandleId = null;
        clmCscontactaddressId = null;
        clmIsSpeedDial = false;
    }
}

