/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.avaya.commons.lang.ProcessRunner;
import com.avaya.commons.lang.ProcessRunnerFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

final class ExeFileProcessRunnerFactory
implements ProcessRunnerFactory {
    private final File executableFile;
    private final ProcessRunnerFactory factory;

    ExeFileProcessRunnerFactory(File executableFile, ProcessRunnerFactory factory) {
        ArgAssert.assertNotNull(executableFile, "executableFile");
        ArgAssert.assertNotNull(factory, "factory");
        this.executableFile = executableFile;
        this.factory = factory;
    }

    public ProcessRunner newProcessRunner(String ... arguments) {
        ArgAssert.assertNotNull(arguments, "arguments");
        return this.factory.newProcessRunner(this.insertExecutableAbsolutePath(arguments));
    }

    public ProcessRunner newProcessRunner(File workingDir, String ... arguments) {
        ArgAssert.assertNotNull(arguments, "arguments");
        return this.factory.newProcessRunner(workingDir, this.insertExecutableAbsolutePath(arguments));
    }

    private String[] insertExecutableAbsolutePath(String ... arguments) {
        ArrayList<String> argumentsAsList = new ArrayList<String>(Arrays.asList(arguments));
        argumentsAsList.add(0, this.executableFile.getAbsolutePath());
        return argumentsAsList.toArray(arguments);
    }
}

