/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.commons.lang;

import com.avaya.commons.lang.ArgAssert;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternsThatMustNotOccur {
    private final Map<Pattern, Integer> maxNumOccurrencesMap;

    private PatternsThatMustNotOccur(Map<Pattern, Integer> maxNumOccurrencesMap) {
        this.maxNumOccurrencesMap = Maps.newHashMap(maxNumOccurrencesMap);
    }

    public Set<Pattern> getPatterns() {
        return Sets.newHashSet(this.maxNumOccurrencesMap.keySet());
    }

    public int getMaxNumOccurrences(Pattern pattern) {
        ArgAssert.assertNotNull(pattern, "pattern");
        if (this.maxNumOccurrencesMap.containsKey(pattern)) {
            return this.maxNumOccurrencesMap.get(pattern);
        }
        throw new IllegalArgumentException("Pattern not found:" + pattern);
    }

    public static final class Builder {
        private final Map<Pattern, Integer> maxNumOccurrencesMap = Maps.newHashMap();

        public Builder setMaxNumOccurrences(Pattern pattern, int maxNumOccurrences) {
            ArgAssert.assertNotNull(pattern, "pattern");
            ArgAssert.assertZeroOrPositive(maxNumOccurrences, "maxNumOccurrences");
            this.maxNumOccurrencesMap.put(pattern, maxNumOccurrences);
            return this;
        }

        public PatternsThatMustNotOccur build() {
            return new PatternsThatMustNotOccur(this.maxNumOccurrencesMap);
        }
    }
}

