/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.common.logging.client;

import com.avaya.common.logging.client.CommonLogManager;
import com.avaya.common.logging.client.Logger;
import com.avaya.common.logging.helper.LogRecordJDO;
import java.io.File;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Priority;

public class ExtendedCommonLogger
extends Logger {
    protected static ConcurrentMap<String, Logger> extendedLoggerMap = null;
    private static Logger logger = CommonLogManager.getLogger((String)ExtendedCommonLogger.class.getName());
    private String logJDO = null;
    private static String pid = null;
    private static String hostname = null;

    public ExtendedCommonLogger() {
    }

    public ExtendedCommonLogger(String loggerType) {
        super(loggerType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getPrivateLogger(String loggerKey, String serviceName) {
        String loggerName = serviceName == null ? loggerKey : serviceName;
        try {
            ConcurrentMap<String, Logger> concurrentMap = extendedLoggerMap;
            synchronized (concurrentMap) {
                Logger existingLogger;
                Logger privateLogger = (Logger)extendedLoggerMap.get(loggerKey);
                if (privateLogger == null) {
                    privateLogger = new com.avaya.collaboration.util.logger.Logger(loggerName);
                    privateLogger.setJDO(loggerName);
                }
                Logger logger = (existingLogger = extendedLoggerMap.putIfAbsent(loggerKey, privateLogger)) != null ? existingLogger : privateLogger;
                return logger;
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error creating logger for " + loggerKey), (Throwable)e);
            return null;
        }
    }

    protected final void setJDO(String logJDO) {
        super.setJDO(logJDO);
        this.logJDO = logJDO;
    }

    protected final void log(String fqcn, Priority level, Object message, Throwable t) {
        LogRecordJDO localLogRecordJDO = new LogRecordJDO(ExtendedCommonLogger.getHostName(), this.logJDO, ExtendedCommonLogger.getProcessID(), "CESNAPIN", TimeZone.getDefault(), message);
        localLogRecordJDO.setSeverity(level.getSyslogEquivalent());
        this.log4jLogger.log(fqcn, level, (Object)localLogRecordJDO, t);
    }

    protected static String getHostName() {
        if (hostname == null) {
            hostname = "";
            try {
                InetAddress iadd = InetAddress.getLocalHost();
                hostname = iadd.getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                logger.error((Object)"Error getting hostname", (Throwable)e);
            }
        }
        return hostname;
    }

    protected static String getProcessID() {
        if (pid == null) {
            pid = "0000";
            try {
                pid = new File("/proc/self").getCanonicalFile().getName();
            }
            catch (Exception e) {
                logger.error((Object)"Error getting process ID", (Throwable)e);
            }
        }
        return pid;
    }

    static {
        try {
            Field f = CommonLogManager.class.getDeclaredField("staticLoggerList");
            f.setAccessible(true);
            extendedLoggerMap = (ConcurrentMap)f.get(null);
        }
        catch (Exception e) {
            logger.error((Object)"Exception setting up ExtendedCommonLogger, loggers will not be cached", (Throwable)e);
        }
    }
}

