/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.CleanupUncomittedChangesDialog;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;

public final class UIRepositoryUtils {
    private UIRepositoryUtils() {
    }

    public static boolean handleUncommittedFiles(Repository repo, Shell shell) throws GitAPIException {
        String repoName = Activator.getDefault().getRepositoryUtil().getRepositoryName(repo);
        return UIRepositoryUtils.handleUncommittedFiles(repo, shell, MessageFormat.format(UIText.AbstractRebaseCommandHandler_cleanupDialog_title, repoName));
    }

    public static boolean handleUncommittedFiles(Repository repo, Shell shell, String dialogTitle) throws GitAPIException {
        Status status = null;
        Throwable throwable = null;
        Object var5_6 = null;
        try (Git git = new Git(repo);){
            status = git.status().call();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (status != null && status.hasUncommittedChanges()) {
            ArrayList<String> files = new ArrayList<String>(status.getModified());
            return UIRepositoryUtils.showCleanupDialog(repo, files, dialogTitle, shell);
        }
        return true;
    }

    public static boolean showCleanupDialog(Repository repo, List<String> files, String title, Shell shell) {
        Collections.sort(files);
        CleanupUncomittedChangesDialog cleanupUncomittedChangesDialog = new CleanupUncomittedChangesDialog(shell, title, UIText.AbstractRebaseCommandHandler_cleanupDialog_text, repo, files);
        cleanupUncomittedChangesDialog.open();
        return cleanupUncomittedChangesDialog.shouldContinue();
    }
}

