/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.history.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.CommitUtil;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.history.GitHistoryPage;
import org.eclipse.egit.ui.internal.history.command.AbstractHistoryCommandHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class RewordHandler
extends AbstractHistoryCommandHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(event);
        RevCommit commit = this.getSelectedCommit(event);
        try {
            if (!CommitUtil.isCommitInCurrentBranch((RevCommit)commit, (Repository)repository)) {
                MessageDialog.openError((Shell)HandlerUtil.getActiveShellChecked((ExecutionEvent)event), (String)UIText.RewordHandler_Error_Title, (String)UIText.RewordHandler_CommitNotOnCurrentBranch);
                return null;
            }
        }
        catch (IOException e) {
            throw new ExecutionException(UIText.RewordHandler_ErrorCheckingIfCommitIsOnCurrentBranch, (Throwable)e);
        }
        StructuredSelection selected = new StructuredSelection((Object)new RepositoryCommit(repository, commit));
        CommonUtils.runCommand("org.eclipse.egit.ui.commit.Reword", (IStructuredSelection)selected);
        return null;
    }

    public boolean isEnabled() {
        GitHistoryPage page = this.getPage();
        if (page == null) {
            return false;
        }
        IStructuredSelection selection = this.getSelection(page);
        if (selection.size() != 1) {
            return false;
        }
        Repository repository = this.getRepository(page);
        if (repository.getRepositoryState() != RepositoryState.SAFE) {
            return false;
        }
        RevCommit commit = (RevCommit)selection.getFirstElement();
        return commit.getParentCount() == 1;
    }
}

