/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.egit.core.internal.rebase.RebaseInteractivePlan;

public class RebasePlanIndexer {
    private RebaseInteractivePlan plan;
    private List<RebaseInteractivePlan.PlanElement> filteredPlan;
    private RebaseInteractivePlan.RebaseInteractivePlanChangeListener listener;
    private int lastFoundElementPosition;

    public RebasePlanIndexer(RebaseInteractivePlan plan) {
        this.plan = plan;
        this.filteredPlan = new ArrayList<RebaseInteractivePlan.PlanElement>();
        this.listener = new RebasePlanChangeListener();
        plan.addRebaseInteractivePlanChangeListener(this.listener);
        this.createIndex();
    }

    private void createIndex() {
        this.lastFoundElementPosition = 0;
        this.filteredPlan.clear();
        for (RebaseInteractivePlan.PlanElement element : this.plan.getList()) {
            if (element.isComment()) continue;
            this.filteredPlan.add(element);
        }
    }

    public int indexOf(Object element) {
        if (this.filteredPlan.isEmpty()) {
            return -1;
        }
        if (this.filteredPlan.get(this.lastFoundElementPosition).equals(element)) {
            return this.lastFoundElementPosition;
        }
        int upIndex = this.mapToCircularIndex(this.lastFoundElementPosition + 1);
        if (this.filteredPlan.get(upIndex).equals(element)) {
            this.lastFoundElementPosition = upIndex;
            return this.lastFoundElementPosition;
        }
        int downIndex = this.mapToCircularIndex(this.lastFoundElementPosition - 1);
        if (this.filteredPlan.get(downIndex).equals(element)) {
            this.lastFoundElementPosition = downIndex;
            return this.lastFoundElementPosition;
        }
        int index = this.mapToCircularIndex(upIndex + 1);
        while (index != downIndex) {
            if (this.filteredPlan.get(index).equals(element)) {
                this.lastFoundElementPosition = index;
                return this.lastFoundElementPosition;
            }
            index = this.mapToCircularIndex(index + 1);
        }
        this.lastFoundElementPosition = 0;
        return -1;
    }

    private int mapToCircularIndex(int index) {
        int size = this.filteredPlan.size();
        if (index < 0) {
            return size + index;
        }
        if (index >= size) {
            return index - size;
        }
        return index;
    }

    public void dispose() {
        this.plan.removeRebaseInteractivePlanChangeListener(this.listener);
    }

    private class RebasePlanChangeListener
    implements RebaseInteractivePlan.RebaseInteractivePlanChangeListener {
        private RebasePlanChangeListener() {
        }

        public void planElementTypeChanged(RebaseInteractivePlan rebaseInteractivePlan, RebaseInteractivePlan.PlanElement element, RebaseInteractivePlan.ElementAction oldType, RebaseInteractivePlan.ElementAction newType) {
        }

        public void planElementsOrderChanged(RebaseInteractivePlan rebaseInteractivePlan, RebaseInteractivePlan.PlanElement element, int oldIndex, int newIndex) {
            RebasePlanIndexer.this.createIndex();
        }

        public void planWasUpdatedFromRepository(RebaseInteractivePlan newPlan) {
            RebasePlanIndexer.this.createIndex();
        }
    }
}

