/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.reflog;

import java.util.Objects;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.internal.IRepositoryObject;
import org.eclipse.egit.ui.internal.reflog.ReflogViewContentProvider;
import org.eclipse.jgit.lib.CheckoutEntry;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;

public class ReflogItem
implements ReflogEntry,
IAdaptable,
IRepositoryObject {
    private final ReflogEntry entry;
    private final ReflogViewContentProvider.ReflogInput input;
    private final String commitMessage;

    ReflogItem(ReflogViewContentProvider.ReflogInput input, ReflogEntry entry, String commitMessage) {
        this.entry = entry;
        this.input = input;
        this.commitMessage = commitMessage;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.isInstance(this)) {
            return this;
        }
        if (Repository.class.equals((Object)adapter)) {
            return this.getRepository();
        }
        return null;
    }

    public ObjectId getOldId() {
        return this.entry.getOldId();
    }

    public ObjectId getNewId() {
        return this.entry.getNewId();
    }

    public PersonIdent getWho() {
        return this.entry.getWho();
    }

    public String getComment() {
        return this.entry.getComment();
    }

    public CheckoutEntry parseCheckout() {
        return this.entry.parseCheckout();
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ReflogItem)) {
            return false;
        }
        ReflogItem other = (ReflogItem)obj;
        return this.input == other.input && Objects.equals(this.commitMessage, other.commitMessage) && Objects.equals(this.getNewId(), other.getNewId()) && Objects.equals(this.getOldId(), other.getOldId()) && Objects.equals(this.getWho(), other.getWho()) && Objects.equals(this.getComment(), other.getComment());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.input, this.commitMessage, this.getNewId(), this.getOldId(), this.getWho(), this.getComment()});
    }

    public Repository getRepository() {
        return this.input.getRepository();
    }

    public ObjectId getObjectId() {
        return this.getNewId();
    }
}

