/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.util.WeakHashMap;
import org.eclipse.egit.ui.internal.GitLabels;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RepositoryTreeNodeLabelProvider
extends DecoratingStyledCellLabelProvider
implements ILabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    private final WorkbenchLabelProvider labelProvider;
    private final WeakHashMap<Object, StyledString> previousDecoratedLabels = new WeakHashMap();

    public RepositoryTreeNodeLabelProvider() {
        this(new WorkbenchLabelProvider());
    }

    private RepositoryTreeNodeLabelProvider(WorkbenchLabelProvider labelProvider) {
        super((DelegatingStyledCellLabelProvider.IStyledLabelProvider)labelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator(), null);
        this.labelProvider = labelProvider;
    }

    public void dispose() {
        super.dispose();
        this.previousDecoratedLabels.clear();
    }

    public StyledString getStyledText(Object element) {
        Repository repository;
        String simpleValue;
        StyledString decoratedLabel = super.getStyledText(element);
        String decoratedValue = decoratedLabel.getString();
        if (decoratedValue.equals(simpleValue = this.labelProvider.getText(element))) {
            StyledString previousLabel = this.previousDecoratedLabels.get(element);
            if (previousLabel != null) {
                return previousLabel;
            }
        } else if (decoratedValue.trim().equals(simpleValue)) {
            decoratedLabel = this.labelProvider.getStyledText(element);
        }
        if (element instanceof RepositoryNode) {
            repository = ((RepositoryNode)element).getRepository();
            if (repository != null) {
                decoratedLabel.append(" - ", StyledString.QUALIFIER_STYLER).append(repository.getDirectory().getAbsolutePath(), StyledString.QUALIFIER_STYLER);
            }
        } else if (element instanceof WorkingDirNode && (repository = ((WorkingDirNode)element).getRepository()) != null) {
            decoratedLabel.append(" - ", StyledString.QUALIFIER_STYLER).append(repository.getWorkTree().getAbsolutePath(), StyledString.QUALIFIER_STYLER);
        }
        this.previousDecoratedLabels.put(element, decoratedLabel);
        return decoratedLabel;
    }

    public String getText(Object element) {
        return this.labelProvider.getText(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof AdditionalRefNode) {
            AdditionalRefNode additionalRefNode = (AdditionalRefNode)element;
            Ref ref = (Ref)additionalRefNode.getObject();
            return GitLabels.getRefDescription(ref);
        }
        return null;
    }
}

