/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.ssl.util;

import com.avaya.collaboration.ssl.util.SSLProtocolType;
import com.avaya.collaboration.ssl.util.SSLUtilityException;
import com.avaya.collaboration.ssl.util.SSLUtilityFactoryDelegate;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.ProviderException;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public final class SSLUtilityFactory {
    private static String sslUtilityImplName = "com.avaya.collaboration.ssl.util.SSLUtilityFactoryImpl";
    private static SSLUtilityFactoryDelegate delegate = null;
    private static Object lock = new Object();

    private SSLUtilityFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SSLUtilityFactoryDelegate getSSLUtilityFactoryDelegate() {
        Object object = lock;
        synchronized (object) {
            if (delegate == null) {
                Constructor<?> constructor;
                Class<?> clazz;
                try {
                    clazz = Class.forName(sslUtilityImplName);
                }
                catch (ClassNotFoundException e) {
                    throw new ProviderException("failed to find delegate class: " + sslUtilityImplName, e);
                }
                try {
                    constructor = clazz.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException e) {
                    throw new ProviderException("failed to find the default constructor of the delegate class: " + sslUtilityImplName, e);
                }
                try {
                    delegate = (SSLUtilityFactoryDelegate)constructor.newInstance(new Object[0]);
                }
                catch (ClassCastException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                    throw new ProviderException("failed to instanstiate the delegate class: " + sslUtilityImplName, e);
                }
            }
        }
        return delegate;
    }

    public static SSLContext createSSLContext() throws SSLUtilityException {
        return SSLUtilityFactory.getSSLUtilityFactoryDelegate().createSSLContext();
    }

    public static SSLContext createSSLContext(SSLProtocolType sslProtocolType) throws SSLUtilityException {
        return SSLUtilityFactory.getSSLUtilityFactoryDelegate().createSSLContext(sslProtocolType);
    }

    public static SSLContext createSSLContext(String serviceName, String serviceVersion, SSLProtocolType sslProtocolType) throws SSLUtilityException {
        return SSLUtilityFactory.getSSLUtilityFactoryDelegate().createSSLContext(serviceName, serviceVersion, sslProtocolType);
    }

    public static SSLContext createSSLContext(String serviceName, String serviceVersion) throws SSLUtilityException {
        return SSLUtilityFactory.getSSLUtilityFactoryDelegate().createSSLContext(serviceName, serviceVersion);
    }

    public static List<KeyManager> getKeyManagers() throws SSLUtilityException {
        return SSLUtilityFactory.getSSLUtilityFactoryDelegate().getKeyManagers();
    }

    public static List<TrustManager> getTrustManagers() throws SSLUtilityException {
        return SSLUtilityFactory.getSSLUtilityFactoryDelegate().getTrustManagers();
    }
}

