/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lfs.lib.AnyLongObjectId;
import org.eclipse.jgit.lfs.server.fs.FileLfsRepository;
import org.eclipse.jgit.lfs.server.fs.FileLfsServlet;

public class ObjectDownloadListener
implements WriteListener {
    private static Logger LOG = Logger.getLogger(ObjectDownloadListener.class.getName());
    private final AsyncContext context;
    private final HttpServletResponse response;
    private final ServletOutputStream out;
    private final ReadableByteChannel in;
    private final WritableByteChannel outChannel;
    private ByteBuffer buffer = ByteBuffer.allocateDirect(8192);

    public ObjectDownloadListener(FileLfsRepository repository, AsyncContext context, HttpServletResponse response, AnyLongObjectId id) throws IOException {
        this.context = context;
        this.response = response;
        this.in = repository.getReadChannel(id);
        this.out = response.getOutputStream();
        this.outChannel = Channels.newChannel((OutputStream)this.out);
        response.addHeader("Content-Length", String.valueOf(repository.getSize(id)));
        response.setContentType("application/octet-stream");
    }

    public void onWritePossible() throws IOException {
        while (this.out.isReady()) {
            try {
                try {
                    this.buffer.clear();
                    if (this.in.read(this.buffer) < 0) {
                        this.buffer = null;
                    } else {
                        this.buffer.flip();
                    }
                }
                catch (Throwable t) {
                    LOG.log(Level.SEVERE, t.getMessage(), t);
                    this.buffer = null;
                    if (this.buffer != null) {
                        this.outChannel.write(this.buffer);
                        continue;
                    }
                    try {
                        this.out.close();
                    }
                    finally {
                        this.context.complete();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (this.buffer == null) {
                    try {
                        this.out.close();
                    }
                    finally {
                        this.context.complete();
                    }
                    return;
                }
                this.outChannel.write(this.buffer);
                throw throwable;
            }
            if (this.buffer != null) {
                this.outChannel.write(this.buffer);
                continue;
            }
            try {
                this.out.close();
            }
            finally {
                this.context.complete();
            }
            return;
        }
    }

    public void onError(Throwable e) {
        try {
            FileLfsServlet.sendError(this.response, 500, e.getMessage());
            this.context.complete();
            this.in.close();
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
        }
    }
}

