/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.zephyr.common.testutils.deencapsulation;

import com.avaya.zephyr.common.testutils.deencapsulation.AutoBoxing;
import com.avaya.zephyr.common.testutils.deencapsulation.ParameterReflection;
import com.avaya.zephyr.common.testutils.deencapsulation.Utilities;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public final class FieldReflection {
    public static <T> T getField(Class<?> theClass, String fieldName, Object targetObject) {
        Field field = FieldReflection.getDeclaredField(theClass, fieldName, targetObject != null);
        return FieldReflection.getFieldValue(field, targetObject);
    }

    private static Field getDeclaredField(Class<?> theClass, String fieldName, boolean instanceField) {
        try {
            return theClass.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException ignore) {
            Class<?> superClass = theClass.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                return FieldReflection.getDeclaredField(superClass, fieldName, instanceField);
            }
            String kind = instanceField ? "instance" : "static";
            throw new IllegalArgumentException("No " + kind + " field of name \"" + fieldName + "\" found in " + theClass);
        }
    }

    public static <T> T getFieldValue(Field field, Object targetObject) {
        Utilities.ensureThatMemberIsAccessible(field);
        try {
            return (T)field.get(targetObject);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T getField(Class<?> theClass, Class<T> fieldType, Object targetObject) {
        Field field = FieldReflection.getDeclaredField(theClass, fieldType, targetObject != null, false);
        return FieldReflection.getFieldValue(field, targetObject);
    }

    public static <T> T getField(Class<?> theClass, Type fieldType, Object targetObject) {
        Field field = FieldReflection.getDeclaredField(theClass, fieldType, targetObject != null, false);
        return FieldReflection.getFieldValue(field, targetObject);
    }

    public static Field setField(Class<?> theClass, Object targetObject, String fieldName, Object fieldValue) {
        boolean instanceField = targetObject != null;
        Field field = fieldName == null ? FieldReflection.getDeclaredField(theClass, fieldValue.getClass(), instanceField, true) : FieldReflection.getDeclaredField(theClass, fieldName, instanceField);
        FieldReflection.setFieldValue(field, targetObject, fieldValue);
        return field;
    }

    private static Field getDeclaredField(Class<?> theClass, Type desiredType, boolean instanceField, boolean forAssignment) {
        Field found = FieldReflection.getDeclaredFieldInSingleClass(theClass, desiredType, instanceField, forAssignment);
        if (found == null) {
            Class<?> superClass = theClass.getSuperclass();
            if (superClass != null && superClass != Object.class) {
                return FieldReflection.getDeclaredField(superClass, desiredType, instanceField, forAssignment);
            }
            StringBuilder errorMsg = new StringBuilder(instanceField ? "Instance" : "Static");
            String typeName = FieldReflection.getTypeName(desiredType);
            errorMsg.append(" field of type ").append(typeName).append(" not found in ").append(theClass);
            throw new IllegalArgumentException(errorMsg.toString());
        }
        return found;
    }

    private static Field getDeclaredFieldInSingleClass(Class<?> theClass, Type desiredType, boolean instanceField, boolean forAssignment) {
        Field found = null;
        for (Field field : theClass.getDeclaredFields()) {
            if (field.isSynthetic()) continue;
            Type fieldType = field.getGenericType();
            if (instanceField == Modifier.isStatic(field.getModifiers()) || !FieldReflection.isCompatibleFieldType(fieldType, desiredType, forAssignment)) continue;
            if (found != null) {
                String message = FieldReflection.errorMessageForMoreThanOneFieldFound(desiredType, instanceField, forAssignment, found, field);
                throw new IllegalArgumentException(message);
            }
            found = field;
        }
        return found;
    }

    private static boolean isCompatibleFieldType(Type fieldType, Type desiredType, boolean forAssignment) {
        Class<?> fieldClass = Utilities.getClassType(fieldType);
        Class<?> desiredClass = Utilities.getClassType(desiredType);
        if (ParameterReflection.isSameTypeIgnoringAutoBoxing(desiredClass, fieldClass)) {
            return true;
        }
        if (forAssignment) {
            return fieldClass.isAssignableFrom(desiredClass);
        }
        return desiredClass.isAssignableFrom(fieldClass) || fieldClass.isAssignableFrom(desiredClass);
    }

    private static String errorMessageForMoreThanOneFieldFound(Type desiredFieldType, boolean instanceField, boolean forAssignment, Field firstField, Field secondField) {
        StringBuilder message = new StringBuilder("More than one ");
        message.append(instanceField ? "instance" : "static").append(" field ");
        message.append(forAssignment ? "to" : "from");
        message.append(" which a value of type ");
        message.append(FieldReflection.getTypeName(desiredFieldType));
        message.append(forAssignment ? " can be assigned" : " can be read");
        message.append(" exists in ").append(secondField.getDeclaringClass()).append(": ");
        message.append(firstField.getName()).append(", ").append(secondField.getName());
        return message.toString();
    }

    private static String getTypeName(Type type) {
        Class<?> classType = Utilities.getClassType(type);
        Class<?> primitiveType = AutoBoxing.getPrimitiveType(classType);
        if (primitiveType != null) {
            return primitiveType + " or " + classType.getSimpleName();
        }
        String name = classType.getName();
        return name.startsWith("java.lang.") ? name.substring(10) : name;
    }

    public static void setFieldValue(Field field, Object targetObject, Object value) {
        try {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                FieldReflection.setStaticFinalField(field, value);
            } else {
                Utilities.ensureThatMemberIsAccessible(field);
                field.set(targetObject, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void setStaticFinalField(Field field, Object value) throws IllegalAccessException {
        Field modifiersField;
        field.setAccessible(true);
        try {
            modifiersField = Field.class.getDeclaredField("modifiers");
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, value);
    }
}

