/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.collaboration.eventing;

import com.avaya.collaboration.eventing.EventFilter;
import com.avaya.collaboration.eventing.EventMetaData;
import com.avaya.collaboration.eventing.EventProducer;
import com.avaya.collaboration.eventing.EventSubscriptionAttributes;
import com.avaya.collaboration.eventing.EventingFactoryDelegate;
import com.avaya.collaboration.eventing.EventingService;
import com.avaya.collaboration.eventing.SubscriptionSelectionFilter;
import com.avaya.collaboration.util.logger.Logger;
import com.avaya.commons.lang.ArgAssert;
import java.security.ProviderException;
import java.util.List;

public final class EventingFactory {
    private static volatile EventingFactoryDelegate eventingFactoryDelegate;
    private static String eventingFactoryImplName;
    private static final Logger LOGGER;

    private EventingFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static EventingFactoryDelegate getEventingFactoryDelegate() {
        if (eventingFactoryDelegate == null) {
            try {
                Class<EventingFactory> clazz = EventingFactory.class;
                synchronized (EventingFactory.class) {
                    Class<?> clazz2 = Class.forName(eventingFactoryImplName);
                    eventingFactoryDelegate = (EventingFactoryDelegate)clazz2.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                    // ** MonitorExit[var0] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"getEventingFactoryDelegate Could not find delegate class for EventingFactory");
                throw new ProviderException("Failed to find delegate class for EventingFactory", e);
            }
        }
        {
            return eventingFactoryDelegate;
        }
    }

    public static EventProducer createEventProducer(String family, String type, EventMetaData metaData, String eventBody, String eventVersion) {
        ArgAssert.assertNotNull((Object)metaData, (String)"metaData");
        return EventingFactory.getEventingFactoryDelegate().createEventProducer(family, type, metaData, eventBody, eventVersion);
    }

    public static EventSubscriptionAttributes createEventSubscriptionAttributes(String family) {
        return EventingFactory.getEventingFactoryDelegate().createEventSubscriptionAttributes(family);
    }

    public static EventSubscriptionAttributes createEventSubscriptionAttributes(String family, String type) {
        return EventingFactory.getEventingFactoryDelegate().createEventSubscriptionAttributes(family, type);
    }

    public static EventSubscriptionAttributes createEventSubscriptionAttributes(String family, List<String> type) {
        return EventingFactory.getEventingFactoryDelegate().createEventSubscriptionAttributes(family, type);
    }

    public static EventFilter createEventFilter() {
        return EventingFactory.getEventingFactoryDelegate().createEventFilter();
    }

    public static SubscriptionSelectionFilter createSubscriptionSelectionFilter() {
        return EventingFactory.getEventingFactoryDelegate().createSubscriptionSelectionFilter();
    }

    public static EventMetaData createEventMetaData() {
        return EventingFactory.getEventingFactoryDelegate().createEventMetaData();
    }

    public static EventingService createEventingService() {
        return EventingFactory.getEventingFactoryDelegate().createEventingService();
    }

    public static boolean isEventingReady() {
        return EventingFactory.getEventingFactoryDelegate().isEventingReady();
    }

    static String junit() {
        return EventingFactory.getEventingFactoryDelegate().junit();
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Can't clone it");
    }

    static {
        eventingFactoryImplName = "com.avaya.collaboration.eventing.internal.EventingFactoryInternalImpl";
        LOGGER = Logger.getLogger(EventingFactory.class);
    }
}

