/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.eclipse.plugin;

import com.avaya.eclipse.plugin.Activator;
import com.avaya.eclipse.plugin.CEProjectModel;
import com.avaya.eclipse.plugin.PluginUtilities;
import com.avaya.eclipse.plugin.PropertyWindowEditor;
import com.avaya.eclipse.plugin.model.ElementInfo;
import com.avaya.eclipse.plugin.util.SelectedProjectFinder;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CEProjectUtils {
    public static final String KEY_GROUP_NAME = "groupId";
    public static final String KEY_SERVICE_NAME = "serviceName";
    public static final String KEY_SERVICE_VERSION = "serviceVersion";
    public static final String KEY_PROPERTIES = "properties";
    public static final String KEY_POM_NAME = "pom.xml";
    public static final String KEY_PROPERTIES_NAME = "properties.xml";
    public static final String KEY_ALARMS_NAME = "alarms.xml";
    public static boolean isDemo = false;
    private static Map<String, CEProjectModel> list = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, CEProjectModel> getAllCEProjects(boolean refresh) {
        Class<CEProjectUtils> clazz = CEProjectUtils.class;
        synchronized (CEProjectUtils.class) {
            if (list == null || refresh) {
                list = new HashMap<String, CEProjectModel>();
                File baseFolder = null;
                baseFolder = isDemo ? new File(System.getProperty("workspace")) : new File(ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toString());
                File[] baseFolderFileArray = baseFolder.listFiles();
                if (baseFolderFileArray != null) {
                    for (File f : baseFolderFileArray) {
                        CEProjectUtils.evaluateAsCEProject(f, list);
                    }
                }
                try {
                    IProject[] projects;
                    for (IProject project : projects = PluginUtilities.getInstance().getWorkspace().getRoot().getProjects()) {
                        String prPath = project.getLocation().toFile().getAbsolutePath();
                        CEProjectUtils.evaluateAsCEProject(new File(prPath), list);
                    }
                }
                catch (Exception e) {
                    Activator.log(4, 0, "Error getting all Avaya Breeze\u00ae projects", e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return list;
        }
    }

    public static void evaluateAsCEProject(File f, Map<String, CEProjectModel> list) {
        CEProjectModel cep = CEProjectUtils.evaluateAsCEProject(f);
        if (cep != null) {
            list.put(f.getName(), cep);
        }
    }

    public static CEProjectModel evaluateAsCEProject(File f) {
        File[] fPoms;
        CEProjectModel cep = null;
        if (f.isDirectory() && (fPoms = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(CEProjectUtils.KEY_POM_NAME);
            }
        })) != null) {
            for (File fp : fPoms) {
                String svarName;
                cep = CEProjectUtils.readPomXML(f.getName(), fp);
                if (cep == null || (svarName = CEProjectUtils.checkForSvarFile(f, ".svar")) == null) continue;
                cep.setAbsolutePathToSvar(svarName);
                cep.setDeploySvarName(new File(svarName).getName());
            }
        }
        if (cep != null) {
            String alarmsName;
            CEProjectUtils.setAssociatedElements(cep);
            String propertiesName = CEProjectUtils.checkForSvarFile(f, KEY_PROPERTIES_NAME);
            if (propertiesName != null) {
                cep.setAbsolutePathToProperties(propertiesName);
            }
            if ((alarmsName = CEProjectUtils.checkForSvarFile(f, KEY_ALARMS_NAME)) != null) {
                cep.setAbsolutePathToAlarms(alarmsName);
            }
        }
        return cep;
    }

    public static void setAssociatedElements(CEProjectModel ceProject) {
        ceProject.setAssociatedElements(PropertyWindowEditor.getSMGREmements());
    }

    public static Map<String, ElementInfo> getElementsIPMap(Collection<ElementInfo> elements) {
        HashMap<String, ElementInfo> elementMap = new HashMap<String, ElementInfo>();
        for (ElementInfo elemenet : elements) {
            elementMap.put(elemenet.getIp(), elemenet);
        }
        return elementMap;
    }

    private static CEProjectModel readPomXML(String parentName, File f) {
        CEProjectModel ceP = null;
        try {
            DocumentBuilder docb = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document d = docb.parse(f);
            boolean isCEProject = true;
            ceP = new CEProjectModel();
            ceP.setName(parentName);
            ceP.setBasePath(f.getParent());
            if (d.getElementsByTagName(KEY_PROPERTIES) == null || d.getElementsByTagName(KEY_PROPERTIES).getLength() == 0) {
                return null;
            }
            if (d.getElementsByTagName(KEY_GROUP_NAME) != null && d.getElementsByTagName(KEY_GROUP_NAME).getLength() != 0) {
                String groupId = d.getElementsByTagName(KEY_GROUP_NAME).item(0).getFirstChild().getNodeValue();
                ceP.setGroupId(groupId);
            }
            Node parent = d.getElementsByTagName(KEY_PROPERTIES).item(0);
            NodeList tags = parent.getChildNodes();
            String serviceName = null;
            String serviceVersion = null;
            for (int i = 0; i < tags.getLength(); ++i) {
                String n1;
                Node n = tags.item(i);
                if (n.getNodeType() != 1) continue;
                if (n.getNodeName().equals(KEY_SERVICE_NAME)) {
                    serviceName = n1 = n.getFirstChild().getNodeValue();
                    continue;
                }
                if (!n.getNodeName().equals(KEY_SERVICE_VERSION)) continue;
                n1 = n.getFirstChild().getNodeValue();
                if (n1 != null && n1.equals("${main.pom.project.version.no.snapshot}")) {
                    Node parentNode = d.getElementsByTagName("parent").item(0);
                    if (parentNode == null) continue;
                    NodeList childTags = parentNode.getChildNodes();
                    for (int j = 0; j < childTags.getLength(); ++j) {
                        Node node = childTags.item(j);
                        if (node.getNodeType() != 1 || !node.getNodeName().equals("version") || (serviceVersion = node.getFirstChild().getNodeValue()) == null || !serviceVersion.contains("SNAPSHOT") || !serviceVersion.contains("-")) continue;
                        serviceVersion = serviceVersion.substring(0, serviceVersion.lastIndexOf(45));
                    }
                    continue;
                }
                serviceVersion = n1;
            }
            if (serviceName == null || serviceVersion == null) {
                return null;
            }
            ceP.setServiceName(serviceName);
            ceP.setServiceVersion(serviceVersion);
        }
        catch (Exception e) {
            Activator.log(4, 0, "Error reading project pom.xml", e);
        }
        return ceP;
    }

    private static String checkForSvarFile(File rootPath, String fileName) {
        File[] flist;
        if (rootPath.isFile()) {
            if (rootPath.getName().endsWith(fileName)) {
                return rootPath.getAbsolutePath();
            }
            return null;
        }
        if (rootPath.isDirectory() && (flist = rootPath.listFiles()) != null) {
            for (File fr : flist) {
                String out = CEProjectUtils.checkForSvarFile(fr, fileName);
                if (out == null) continue;
                return out;
            }
        }
        return null;
    }

    public static String getSelectedService() {
        CEProjectModel cep = CEProjectUtils.evaluateAsCEProject(SelectedProjectFinder.getCurrentProject().getLocation().toFile());
        String serString = null;
        if (cep != null) {
            serString = cep.getFullServiceName();
        }
        return serString;
    }

    public static CEProjectModel getSelectedCEProject() {
        return CEProjectUtils.evaluateAsCEProject(SelectedProjectFinder.getCurrentProject().getLocation().toFile());
    }

    public static String getSelectedPomFile(File f) {
        if (f.isDirectory()) {
            File[] fPoms = f.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.equals(CEProjectUtils.KEY_POM_NAME);
                }
            });
            return fPoms != null && fPoms.length > 0 ? fPoms[0].getAbsolutePath() : null;
        }
        return null;
    }

    public static CEProjectModel checkForSvar() {
        CEProjectModel cep = CEProjectUtils.getSelectedCEProject();
        if (cep == null) {
            MessageDialog.openError(null, (String)"Execution Error", (String)"Selected Project is a not a valid Avaya Breeze\u00ae project to execute the required action");
            throw new RuntimeException("Invalid Avaya Breeze\u00ae project");
        }
        if (cep.getDeploySvarName() == null || cep.getDeploySvarName().isEmpty()) {
            MessageDialog.openError(null, (String)"Execution Error", (String)"Target svar file is not present in the selected project.Execute 'mvn install' to create the required svar file");
            throw new RuntimeException("Action requires svar file");
        }
        return cep;
    }

    public static void failOnInvalidProject() {
        MessageDialog.openError(null, (String)"Execution Error", (String)"Selected Project is a not a valid Avaya Breeze\u00ae project to execute the required action");
        throw new RuntimeException("Invalid Avaya Breeze\u00ae project");
    }
}

